/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.blob;

import com.microsoft.windowsazure.storage.DoesServiceRequest;
import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.ResultContinuation;
import com.microsoft.windowsazure.storage.ResultSegment;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.StorageUri;
import com.microsoft.windowsazure.storage.blob.BlobListingDetails;
import com.microsoft.windowsazure.storage.blob.BlobRequestOptions;
import com.microsoft.windowsazure.storage.blob.CloudBlob;
import com.microsoft.windowsazure.storage.blob.CloudBlobClient;
import com.microsoft.windowsazure.storage.blob.CloudBlobContainer;
import com.microsoft.windowsazure.storage.blob.CloudBlockBlob;
import com.microsoft.windowsazure.storage.blob.CloudPageBlob;
import com.microsoft.windowsazure.storage.blob.ListBlobItem;
import com.microsoft.windowsazure.storage.core.PathUtility;
import com.microsoft.windowsazure.storage.core.Utility;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;

public final class CloudBlobDirectory
implements ListBlobItem {
    private final CloudBlobContainer container;
    private CloudBlobDirectory parent;
    private final CloudBlobClient blobServiceClient;
    private final StorageUri storageUri;
    private final String prefix;

    protected CloudBlobDirectory(StorageUri uri, String prefix, CloudBlobClient client, CloudBlobContainer container) {
        Utility.assertNotNull("uri", uri);
        Utility.assertNotNull("client", client);
        Utility.assertNotNull("container", container);
        this.blobServiceClient = client;
        this.container = container;
        this.prefix = prefix;
        this.storageUri = uri;
    }

    protected CloudBlobDirectory(StorageUri uri, String prefix, CloudBlobClient client, CloudBlobContainer container, CloudBlobDirectory parent) {
        Utility.assertNotNull("uri", uri);
        Utility.assertNotNull("client", client);
        Utility.assertNotNull("container", container);
        this.blobServiceClient = client;
        this.parent = parent;
        this.container = container;
        this.prefix = prefix;
        this.storageUri = uri;
    }

    public CloudBlockBlob getBlockBlobReference(String blobName) throws URISyntaxException, StorageException {
        return this.getBlockBlobReference(blobName, null);
    }

    public CloudBlockBlob getBlockBlobReference(String blobName, String snapshotID) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("blobName", blobName);
        StorageUri address = PathUtility.appendPathToUri(this.storageUri, blobName, this.blobServiceClient.getDirectoryDelimiter());
        CloudBlockBlob retBlob = new CloudBlockBlob(address, snapshotID, this.blobServiceClient);
        retBlob.setContainer(this.container);
        return retBlob;
    }

    @Override
    public CloudBlobContainer getContainer() throws StorageException, URISyntaxException {
        return this.container;
    }

    public CloudPageBlob getPageBlobReference(String blobName) throws URISyntaxException, StorageException {
        return this.getPageBlobReference(blobName, null);
    }

    public CloudPageBlob getPageBlobReference(String blobName, String snapshotID) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("blobName", blobName);
        StorageUri address = PathUtility.appendPathToUri(this.storageUri, blobName, this.blobServiceClient.getDirectoryDelimiter());
        CloudPageBlob retBlob = new CloudPageBlob(address, snapshotID, this.blobServiceClient);
        retBlob.setContainer(this.container);
        return retBlob;
    }

    @Override
    public CloudBlobDirectory getParent() throws URISyntaxException, StorageException {
        String parentName;
        if (this.parent == null && (parentName = CloudBlob.getParentNameFromURI(this.getStorageUri(), this.blobServiceClient.getDirectoryDelimiter(), this.getContainer())) != null) {
            StorageUri parentURI = PathUtility.appendPathToUri(this.container.getStorageUri(), parentName);
            this.parent = new CloudBlobDirectory(parentURI, parentName, this.blobServiceClient, this.getContainer());
        }
        return this.parent;
    }

    public String getPrefix() throws StorageException, URISyntaxException {
        return this.prefix;
    }

    public CloudBlobClient getServiceClient() {
        return this.blobServiceClient;
    }

    public CloudBlobDirectory getSubDirectoryReference(String directoryName) throws StorageException, URISyntaxException {
        Utility.assertNotNullOrEmpty("directoryName", directoryName);
        if (!directoryName.endsWith(this.blobServiceClient.getDirectoryDelimiter())) {
            directoryName = directoryName.concat(this.blobServiceClient.getDirectoryDelimiter());
        }
        String subDirName = this.getPrefix().concat(directoryName);
        StorageUri address = PathUtility.appendPathToUri(this.storageUri, directoryName, this.blobServiceClient.getDirectoryDelimiter());
        return new CloudBlobDirectory(address, subDirName, this.blobServiceClient, this.container, this);
    }

    @Override
    public URI getUri() {
        return this.storageUri.getPrimaryUri();
    }

    @Override
    public final StorageUri getStorageUri() {
        return this.storageUri;
    }

    @DoesServiceRequest
    public Iterable<ListBlobItem> listBlobs() throws StorageException, URISyntaxException {
        return this.getContainer().listBlobs(this.getPrefix());
    }

    @DoesServiceRequest
    public Iterable<ListBlobItem> listBlobs(String prefix) throws URISyntaxException, StorageException {
        prefix = prefix == null ? "" : prefix;
        return this.getContainer().listBlobs(this.getPrefix().concat(prefix));
    }

    @DoesServiceRequest
    public Iterable<ListBlobItem> listBlobs(String prefix, boolean useFlatBlobListing, EnumSet<BlobListingDetails> listingDetails, BlobRequestOptions options, OperationContext opContext) throws URISyntaxException, StorageException {
        prefix = prefix == null ? "" : prefix;
        return this.getContainer().listBlobs(this.getPrefix().concat(prefix), useFlatBlobListing, listingDetails, options, opContext);
    }

    @DoesServiceRequest
    public ResultSegment<ListBlobItem> listBlobsSegmented() throws StorageException, URISyntaxException {
        return this.getContainer().listBlobsSegmented(this.getPrefix());
    }

    @DoesServiceRequest
    public ResultSegment<ListBlobItem> listBlobsSegmented(String prefix) throws StorageException, URISyntaxException {
        prefix = prefix == null ? "" : prefix;
        return this.getContainer().listBlobsSegmented(this.getPrefix().concat(prefix));
    }

    @DoesServiceRequest
    public ResultSegment<ListBlobItem> listBlobsSegmented(String prefix, boolean useFlatBlobListing, EnumSet<BlobListingDetails> listingDetails, int maxResults, ResultContinuation continuationToken, BlobRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        prefix = prefix == null ? "" : prefix;
        return this.getContainer().listBlobsSegmented(this.getPrefix().concat(prefix), useFlatBlobListing, listingDetails, maxResults, continuationToken, options, opContext);
    }
}

