/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.blob;

import com.microsoft.windowsazure.storage.AccessCondition;
import com.microsoft.windowsazure.storage.DoesServiceRequest;
import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.RequestOptions;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.StorageUri;
import com.microsoft.windowsazure.storage.blob.BlobDeserializer;
import com.microsoft.windowsazure.storage.blob.BlobOutputStream;
import com.microsoft.windowsazure.storage.blob.BlobRequest;
import com.microsoft.windowsazure.storage.blob.BlobRequestOptions;
import com.microsoft.windowsazure.storage.blob.BlobType;
import com.microsoft.windowsazure.storage.blob.BlockEntry;
import com.microsoft.windowsazure.storage.blob.BlockEntryListSerializer;
import com.microsoft.windowsazure.storage.blob.BlockListingFilter;
import com.microsoft.windowsazure.storage.blob.CloudBlob;
import com.microsoft.windowsazure.storage.blob.CloudBlobClient;
import com.microsoft.windowsazure.storage.blob.CloudBlobContainer;
import com.microsoft.windowsazure.storage.core.Base64;
import com.microsoft.windowsazure.storage.core.ExecutionEngine;
import com.microsoft.windowsazure.storage.core.RequestLocationMode;
import com.microsoft.windowsazure.storage.core.StorageRequest;
import com.microsoft.windowsazure.storage.core.StreamMd5AndLength;
import com.microsoft.windowsazure.storage.core.Utility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;

public final class CloudBlockBlob
extends CloudBlob {
    public CloudBlockBlob(URI uri) throws StorageException {
        this(new StorageUri(uri));
    }

    public CloudBlockBlob(StorageUri uri) throws StorageException {
        super(BlobType.BLOCK_BLOB);
        Utility.assertNotNull("blobAbsoluteUri", uri);
        this.setStorageUri(uri);
        this.parseURIQueryStringAndVerify(uri, null, Utility.determinePathStyleFromUri(uri.getPrimaryUri(), null));
    }

    public CloudBlockBlob(CloudBlockBlob otherBlob) throws StorageException {
        super(otherBlob);
    }

    public CloudBlockBlob(URI uri, CloudBlobClient client) throws StorageException {
        this(new StorageUri(uri), client);
    }

    public CloudBlockBlob(StorageUri uri, CloudBlobClient client) throws StorageException {
        super(BlobType.BLOCK_BLOB, uri, client);
    }

    public CloudBlockBlob(URI uri, CloudBlobClient client, CloudBlobContainer container) throws StorageException {
        this(new StorageUri(uri), client, container);
    }

    public CloudBlockBlob(StorageUri uri, CloudBlobClient client, CloudBlobContainer container) throws StorageException {
        super(BlobType.BLOCK_BLOB, uri, client, container);
    }

    public CloudBlockBlob(URI uri, String snapshotID, CloudBlobClient client) throws StorageException {
        this(new StorageUri(uri), snapshotID, client);
    }

    public CloudBlockBlob(StorageUri uri, String snapshotID, CloudBlobClient client) throws StorageException {
        super(BlobType.BLOCK_BLOB, uri, snapshotID, client);
    }

    @DoesServiceRequest
    public void commitBlockList(Iterable<BlockEntry> blockList) throws StorageException {
        this.commitBlockList(blockList, null, null, null);
    }

    @DoesServiceRequest
    public void commitBlockList(Iterable<BlockEntry> blockList, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        options = BlobRequestOptions.applyDefaults(options, BlobType.BLOCK_BLOB, this.blobServiceClient);
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.commitBlockListImpl(blockList, accessCondition, options, opContext), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Void> commitBlockListImpl(Iterable<BlockEntry> blockList, final AccessCondition accessCondition, final BlobRequestOptions options, OperationContext opContext) throws StorageException {
        try {
            byte[] blockListBytes = BlockEntryListSerializer.writeBlockListToStream(blockList, opContext);
            final ByteArrayInputStream blockListInputStream = new ByteArrayInputStream(blockListBytes);
            final StreamMd5AndLength descriptor = Utility.analyzeStream(blockListInputStream, -1L, -1L, true, true);
            StorageRequest<CloudBlobClient, CloudBlob, Void> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, Void>((RequestOptions)options, this.getStorageUri()){

                @Override
                public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                    this.setSendStream(blockListInputStream);
                    this.setLength(descriptor.getLength());
                    return BlobRequest.putBlockList(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options.getTimeoutIntervalInMs(), blob.properties, accessCondition, options, context);
                }

                @Override
                public void setHeaders(HttpURLConnection connection, CloudBlob blob, OperationContext context) {
                    BlobRequest.addMetadata(connection, blob.metadata, context);
                    connection.setRequestProperty("Content-MD5", descriptor.getMd5());
                }

                @Override
                public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                    StorageRequest.signBlobAndQueueRequest(connection, client, this.getLength(), null);
                }

                @Override
                public Void preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                    if (this.getResult().getStatusCode() != 201) {
                        this.setNonExceptionedRetryableFailure(true);
                        return null;
                    }
                    blob.updateEtagAndLastModifiedFromResponse(this.getConnection());
                    return null;
                }

                @Override
                public void recoveryAction(OperationContext context) throws IOException {
                    blockListInputStream.reset();
                    blockListInputStream.mark(0x4000000);
                }
            };
            return putRequest;
        }
        catch (XMLStreamException e) {
            StorageException translatedException = StorageException.translateException(null, e, null);
            throw translatedException;
        }
        catch (IOException e) {
            StorageException translatedException = StorageException.translateException(null, e, null);
            throw translatedException;
        }
    }

    @DoesServiceRequest
    public ArrayList<BlockEntry> downloadBlockList() throws StorageException {
        return this.downloadBlockList(BlockListingFilter.COMMITTED, null, null, null);
    }

    @DoesServiceRequest
    public ArrayList<BlockEntry> downloadBlockList(BlockListingFilter blockListingFilter, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("blockListingFilter", (Object)blockListingFilter);
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.applyDefaults(options, BlobType.BLOCK_BLOB, this.blobServiceClient);
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.downloadBlockListImpl(blockListingFilter, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, ArrayList<BlockEntry>> downloadBlockListImpl(final BlockListingFilter blockListingFilter, final AccessCondition accessCondition, final BlobRequestOptions options) throws StorageException {
        StorageRequest<CloudBlobClient, CloudBlob, ArrayList<BlockEntry>> getRequest = new StorageRequest<CloudBlobClient, CloudBlob, ArrayList<BlockEntry>>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.getBlockList(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options.getTimeoutIntervalInMs(), blob.snapshotID, blockListingFilter, accessCondition, options, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobAndQueueRequest(connection, client, -1L, null);
            }

            @Override
            public ArrayList<BlockEntry> preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }

            @Override
            public ArrayList<BlockEntry> postProcessResponse(HttpURLConnection connection, CloudBlob blob, CloudBlobClient client, OperationContext context, ArrayList<BlockEntry> storageObject) throws Exception {
                blob.updateEtagAndLastModifiedFromResponse(this.getConnection());
                blob.updateLengthFromResponse(this.getConnection());
                return BlobDeserializer.getBlockList(this.getConnection().getInputStream());
            }
        };
        return getRequest;
    }

    public BlobOutputStream openOutputStream() throws StorageException {
        return this.openOutputStream(null, null, null);
    }

    public BlobOutputStream openOutputStream(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        this.assertNoWriteOperationForSnapshot();
        options = BlobRequestOptions.applyDefaults(options, BlobType.BLOCK_BLOB, this.blobServiceClient, false);
        return new BlobOutputStream(this, accessCondition, options, opContext);
    }

    @Override
    @DoesServiceRequest
    public void upload(InputStream sourceStream, long length) throws StorageException, IOException {
        this.upload(sourceStream, length, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @DoesServiceRequest
    public void upload(InputStream sourceStream, long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        if (length < -1L) {
            throw new IllegalArgumentException("Invalid stream length, specify -1 for unknown length stream, or a positive number of bytes.");
        }
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.applyDefaults(options, BlobType.BLOCK_BLOB, this.blobServiceClient);
        StreamMd5AndLength descriptor = new StreamMd5AndLength();
        descriptor.setLength(length);
        if (sourceStream.markSupported()) {
            sourceStream.mark(0x4000000);
        }
        if (sourceStream.markSupported() && (length < 0L || options.getStoreBlobContentMD5().booleanValue() && length <= (long)options.getSingleBlobPutThresholdInBytes().intValue()) && (descriptor = Utility.analyzeStream(sourceStream, length, options.getSingleBlobPutThresholdInBytes() + 1, true, options.getStoreBlobContentMD5())).getMd5() != null && options.getStoreBlobContentMD5().booleanValue()) {
            this.properties.setContentMD5(descriptor.getMd5());
        }
        if (sourceStream.markSupported() && descriptor.getLength() != -1L && descriptor.getLength() < (long)(options.getSingleBlobPutThresholdInBytes() + 1)) {
            this.uploadFullBlob(sourceStream, descriptor.getLength(), accessCondition, options, opContext);
        } else {
            BlobOutputStream writeStream = this.openOutputStream(accessCondition, options, opContext);
            try {
                writeStream.write(sourceStream, length);
            }
            finally {
                writeStream.close();
            }
        }
    }

    @DoesServiceRequest
    public void uploadBlock(String blockId, InputStream sourceStream, long length) throws StorageException, IOException {
        this.uploadBlock(blockId, sourceStream, length, null, null, null);
    }

    @DoesServiceRequest
    public void uploadBlock(String blockId, InputStream sourceStream, long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        if (length < -1L) {
            throw new IllegalArgumentException("Invalid stream length, specify -1 for unknown length stream, or a positive number of bytes.");
        }
        if (length > 0x400000L) {
            throw new IllegalArgumentException("Invalid stream length, length must be less than or equal to 4 MB in size.");
        }
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        options = BlobRequestOptions.applyDefaults(options, BlobType.BLOCK_BLOB, this.blobServiceClient);
        if (Utility.isNullOrEmpty(blockId) || !Base64.validateIsBase64String(blockId)) {
            throw new IllegalArgumentException("Invalid blockID, blockID must be a valid Base64 String.");
        }
        if (sourceStream.markSupported()) {
            sourceStream.mark(0x4000000);
        }
        InputStream bufferedStreamReference = sourceStream;
        StreamMd5AndLength descriptor = new StreamMd5AndLength();
        descriptor.setLength(length);
        if (!sourceStream.markSupported()) {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            descriptor = Utility.writeToOutputStream(sourceStream, byteStream, length, false, options.getUseTransactionalContentMD5(), opContext, options);
            bufferedStreamReference = new ByteArrayInputStream(byteStream.toByteArray());
        } else if (length < 0L || options.getUseTransactionalContentMD5().booleanValue()) {
            descriptor = Utility.analyzeStream(sourceStream, length, -1L, true, options.getUseTransactionalContentMD5());
        }
        if (descriptor.getLength() > 0x400000L) {
            throw new IllegalArgumentException("Invalid stream length, length must be less than or equal to 4 MB in size.");
        }
        this.uploadBlockInternal(blockId, descriptor.getMd5(), bufferedStreamReference, descriptor.getLength(), accessCondition, options, opContext);
    }

    @DoesServiceRequest
    private void uploadBlockInternal(String blockId, String md5, InputStream sourceStream, long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.uploadBlockImpl(blockId, md5, sourceStream, length, accessCondition, options, opContext), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Void> uploadBlockImpl(final String blockId, final String md5, final InputStream sourceStream, final long length, final AccessCondition accessCondition, final BlobRequestOptions options, final OperationContext opContext) throws StorageException, IOException {
        StorageRequest<CloudBlobClient, CloudBlob, Void> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                this.setSendStream(sourceStream);
                this.setLength(length);
                return BlobRequest.putBlock(blob.getTransformedAddress(opContext).getUri(this.getCurrentLocation()), options.getTimeoutIntervalInMs(), blockId, accessCondition, options, opContext);
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudBlob blob, OperationContext context) {
                if (options.getUseTransactionalContentMD5().booleanValue()) {
                    connection.setRequestProperty("Content-MD5", md5);
                }
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobAndQueueRequest(connection, client, length, null);
            }

            @Override
            public Void preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                return null;
            }

            @Override
            public void recoveryAction(OperationContext context) throws IOException {
                sourceStream.reset();
                sourceStream.mark(0x4000000);
            }
        };
        return putRequest;
    }

    public void uploadText(String content) throws StorageException, IOException {
        this.uploadText(content, null, null, null, null);
    }

    public void uploadText(String content, String charsetName, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        byte[] bytes = charsetName == null ? content.getBytes() : content.getBytes(charsetName);
        this.uploadFromByteArray(bytes, 0, bytes.length, accessCondition, options, opContext);
    }

    public String downloadText() throws StorageException, IOException {
        return this.downloadText(null, null, null, null);
    }

    public String downloadText(String charsetName, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.download(baos, accessCondition, options, opContext);
        return charsetName == null ? baos.toString() : baos.toString(charsetName);
    }

    @Override
    public void setStreamWriteSizeInBytes(int streamWriteSizeInBytes) {
        if (streamWriteSizeInBytes > 0x400000 || streamWriteSizeInBytes < 16384) {
            throw new IllegalArgumentException("StreamWriteSizeInBytes");
        }
        this.streamWriteSizeInBytes = streamWriteSizeInBytes;
    }
}

