/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.blob;

import com.microsoft.windowsazure.storage.AccessCondition;
import com.microsoft.windowsazure.storage.Credentials;
import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.blob.BlobContainerPublicAccessType;
import com.microsoft.windowsazure.storage.blob.BlobRequestOptions;
import com.microsoft.windowsazure.storage.blob.ContainerListingDetails;
import com.microsoft.windowsazure.storage.blob.LeaseAction;
import com.microsoft.windowsazure.storage.core.BaseRequest;
import com.microsoft.windowsazure.storage.core.ListingContext;
import com.microsoft.windowsazure.storage.core.UriQueryBuilder;
import com.microsoft.windowsazure.storage.core.Utility;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.HashMap;

final class ContainerRequest {
    public static void addMetadata(HttpURLConnection request, HashMap<String, String> metadata, OperationContext opContext) {
        BaseRequest.addMetadata(request, metadata, opContext);
    }

    public static void addMetadata(HttpURLConnection request, String name, String value, OperationContext opContext) {
        BaseRequest.addMetadata(request, name, value, opContext);
    }

    public static HttpURLConnection create(URI uri, int timeout, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder containerBuilder = ContainerRequest.getContainerUriQueryBuilder();
        return BaseRequest.create(uri, timeout, containerBuilder, opContext);
    }

    private static HttpURLConnection createURLConnection(URI uri, int timeout, UriQueryBuilder query, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        return BaseRequest.createURLConnection(uri, timeout, query, opContext);
    }

    public static HttpURLConnection delete(URI uri, int timeout, AccessCondition accessCondition, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder containerBuilder = ContainerRequest.getContainerUriQueryBuilder();
        HttpURLConnection request = BaseRequest.delete(uri, timeout, containerBuilder, opContext);
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection getAcl(URI uri, int timeout, AccessCondition accessCondition, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = ContainerRequest.getContainerUriQueryBuilder();
        builder.add("comp", "acl");
        HttpURLConnection request = ContainerRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setRequestMethod("GET");
        if (accessCondition != null && !Utility.isNullOrEmpty(accessCondition.getLeaseID())) {
            BaseRequest.addLeaseId(request, accessCondition.getLeaseID());
        }
        return request;
    }

    protected static UriQueryBuilder getContainerUriQueryBuilder() throws StorageException {
        UriQueryBuilder uriBuilder = new UriQueryBuilder();
        try {
            uriBuilder.add("restype", "container");
        }
        catch (IllegalArgumentException e) {
            throw Utility.generateNewUnexpectedStorageException(e);
        }
        return uriBuilder;
    }

    public static HttpURLConnection getMetadata(URI uri, int timeout, AccessCondition accessCondition, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder containerBuilder = ContainerRequest.getContainerUriQueryBuilder();
        HttpURLConnection request = BaseRequest.getMetadata(uri, timeout, containerBuilder, opContext);
        if (accessCondition != null && !Utility.isNullOrEmpty(accessCondition.getLeaseID())) {
            BaseRequest.addLeaseId(request, accessCondition.getLeaseID());
        }
        return request;
    }

    public static HttpURLConnection getProperties(URI uri, int timeout, AccessCondition accessCondition, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder containerBuilder = ContainerRequest.getContainerUriQueryBuilder();
        HttpURLConnection request = BaseRequest.getProperties(uri, timeout, containerBuilder, opContext);
        if (accessCondition != null && !Utility.isNullOrEmpty(accessCondition.getLeaseID())) {
            BaseRequest.addLeaseId(request, accessCondition.getLeaseID());
        }
        return request;
    }

    public static HttpURLConnection list(URI uri, int timeout, ListingContext listingContext, ContainerListingDetails detailsIncluded, OperationContext opContext) throws URISyntaxException, IOException, StorageException {
        UriQueryBuilder builder = ContainerRequest.getContainerUriQueryBuilder();
        builder.add("comp", "list");
        if (listingContext != null) {
            if (!Utility.isNullOrEmpty(listingContext.getPrefix())) {
                builder.add("prefix", listingContext.getPrefix());
            }
            if (!Utility.isNullOrEmpty(listingContext.getMarker())) {
                builder.add("marker", listingContext.getMarker());
            }
            if (listingContext.getMaxResults() != null && listingContext.getMaxResults() > 0) {
                builder.add("maxresults", listingContext.getMaxResults().toString());
            }
        }
        if (detailsIncluded == ContainerListingDetails.ALL || detailsIncluded == ContainerListingDetails.METADATA) {
            builder.add("include", "metadata");
        }
        HttpURLConnection request = ContainerRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setRequestMethod("GET");
        return request;
    }

    public static HttpURLConnection setAcl(URI uri, int timeout, BlobContainerPublicAccessType publicAccess, AccessCondition accessCondition, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = ContainerRequest.getContainerUriQueryBuilder();
        builder.add("comp", "acl");
        HttpURLConnection request = ContainerRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setRequestMethod("PUT");
        request.setDoOutput(true);
        if (publicAccess != BlobContainerPublicAccessType.OFF) {
            request.setRequestProperty("x-ms-blob-public-access", publicAccess.toString().toLowerCase());
        }
        if (accessCondition != null && !Utility.isNullOrEmpty(accessCondition.getLeaseID())) {
            BaseRequest.addLeaseId(request, accessCondition.getLeaseID());
        }
        return request;
    }

    public static HttpURLConnection setMetadata(URI uri, int timeout, AccessCondition accessCondition, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder containerBuilder = ContainerRequest.getContainerUriQueryBuilder();
        HttpURLConnection request = BaseRequest.setMetadata(uri, timeout, containerBuilder, opContext);
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection lease(URI uri, int timeout, LeaseAction action, Integer leaseTimeInSeconds, String proposedLeaseId, Integer breakPeriodInSeconds, AccessCondition accessCondition, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = ContainerRequest.getContainerUriQueryBuilder();
        builder.add("comp", "lease");
        HttpURLConnection request = ContainerRequest.createURLConnection(uri, timeout, builder, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        request.setFixedLengthStreamingMode(0);
        request.setRequestProperty("x-ms-lease-action", action.toString());
        if (leaseTimeInSeconds != null) {
            request.setRequestProperty("x-ms-lease-duration", leaseTimeInSeconds.toString());
        } else {
            request.setRequestProperty("x-ms-lease-duration", "-1");
        }
        if (proposedLeaseId != null) {
            request.setRequestProperty("x-ms-proposed-lease-id", proposedLeaseId);
        }
        if (breakPeriodInSeconds != null) {
            request.setRequestProperty("x-ms-lease-break-period", breakPeriodInSeconds.toString());
        }
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static void signRequest(HttpURLConnection request, Credentials credentials, Long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        BaseRequest.signRequestForBlobAndQueue(request, credentials, contentLength, opContext);
    }

    public static void signRequestForSharedKeyLite(HttpURLConnection request, Credentials credentials, Long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        BaseRequest.signRequestForBlobAndQueueSharedKeyLite(request, credentials, contentLength, opContext);
    }

    private ContainerRequest() {
    }
}

