/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.blob;

import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.blob.BlobDeserializationHelper;
import com.microsoft.windowsazure.storage.blob.BlockEntry;
import com.microsoft.windowsazure.storage.blob.BlockSearchMode;
import com.microsoft.windowsazure.storage.core.Utility;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class GetBlockListResponse {
    private final ArrayList<BlockEntry> blocks = new ArrayList();

    protected GetBlockListResponse(InputStream stream) throws XMLStreamException, StorageException {
        this.parseResponse(stream);
    }

    protected ArrayList<BlockEntry> getBlocks() {
        return this.blocks;
    }

    private void parseResponse(InputStream streamRef) throws XMLStreamException, StorageException {
        XMLStreamReader xmlr = Utility.createXMLStreamReaderFromStream((InputStream)streamRef);
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        eventType = xmlr.next();
        xmlr.require(1, null, "BlockList");
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType != 1 && eventType != 2) continue;
            String name = xmlr.getName().toString();
            if (name.equals("CommittedBlocks")) {
                eventType = xmlr.next();
                if (eventType != 1 || !"Block".equals(xmlr.getName().toString())) continue;
                this.blocks.addAll(BlobDeserializationHelper.readBlobBlocks(xmlr, BlockSearchMode.COMMITTED));
                xmlr.require(2, null, "CommittedBlocks");
                continue;
            }
            if (name.equals("UncommittedBlocks")) {
                eventType = xmlr.next();
                if (eventType != 1 || !"Block".equals(xmlr.getName().toString())) continue;
                this.blocks.addAll(BlobDeserializationHelper.readBlobBlocks(xmlr, BlockSearchMode.UNCOMMITTED));
                xmlr.require(2, null, "UncommittedBlocks");
                continue;
            }
            if (name.equals("BlockList") && eventType == 2) break;
            throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
        }
    }
}

