/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.blob;

import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.blob.BlobDeserializationHelper;
import com.microsoft.windowsazure.storage.blob.CloudBlobClient;
import com.microsoft.windowsazure.storage.blob.CloudBlobContainer;
import com.microsoft.windowsazure.storage.core.Utility;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class ListContainersResponse {
    private ArrayList<CloudBlobContainer> containers = new ArrayList();
    private boolean isParsed;
    private String marker;
    private int maxResults;
    private String nextMarker;
    private String prefix;
    private final InputStream streamRef;

    public ListContainersResponse(InputStream stream) {
        this.streamRef = stream;
    }

    public ArrayList<CloudBlobContainer> getContainers(CloudBlobClient serviceClient) throws XMLStreamException, StorageException {
        if (!this.isParsed) {
            this.parseResponse(serviceClient);
        }
        return this.containers;
    }

    public String getMarker() {
        return this.marker;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void parseResponse(CloudBlobClient serviceClient) throws XMLStreamException, StorageException {
        XMLStreamReader xmlr = Utility.createXMLStreamReaderFromStream((InputStream)this.streamRef);
        String tempParseString = null;
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        eventType = xmlr.next();
        xmlr.require(1, null, "EnumerationResults");
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType != 1 && eventType != 2) continue;
            String name = xmlr.getName().toString();
            if (eventType == 1 && name.equals("MaxResults")) {
                tempParseString = Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"MaxResults");
                this.maxResults = Integer.parseInt(tempParseString);
                continue;
            }
            if (eventType == 1 && name.equals("Marker")) {
                this.marker = Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"Marker");
                continue;
            }
            if (eventType == 1 && name.equals("NextMarker")) {
                this.nextMarker = Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"NextMarker");
                continue;
            }
            if (eventType == 1 && name.equals("Prefix")) {
                this.prefix = Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"Prefix");
                continue;
            }
            if (eventType == 1 && name.equals("Containers")) {
                try {
                    this.containers = BlobDeserializationHelper.readContainers(xmlr, serviceClient);
                }
                catch (URISyntaxException e) {
                    throw new XMLStreamException(e);
                }
                catch (ParseException e) {
                    throw new XMLStreamException(e);
                }
                xmlr.require(2, null, "Containers");
                continue;
            }
            if (eventType != 2 || !"EnumerationResults".equals(name)) continue;
            break;
        }
        this.isParsed = true;
    }
}

