/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.core;

import com.microsoft.windowsazure.storage.Credentials;
import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.StorageKey;
import com.microsoft.windowsazure.storage.core.Canonicalizer;
import com.microsoft.windowsazure.storage.core.CanonicalizerFactory;
import com.microsoft.windowsazure.storage.core.UriQueryBuilder;
import com.microsoft.windowsazure.storage.core.Utility;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.Map;

public final class BaseRequest {
    private static final String METADATA = "metadata";
    private static final String SERVICE = "service";
    private static final String STATS = "stats";
    private static final String TIMEOUT = "timeout";
    private static String userAgent;

    public static void addLeaseId(HttpURLConnection request, String leaseId) {
        if (leaseId != null) {
            BaseRequest.addOptionalHeader(request, "x-ms-lease-id", leaseId);
        }
    }

    public static void addMetadata(HttpURLConnection request, HashMap<String, String> metadata, OperationContext opContext) {
        if (metadata != null) {
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                BaseRequest.addMetadata(request, entry.getKey(), entry.getValue(), opContext);
            }
        }
    }

    public static void addMetadata(HttpURLConnection request, String name, String value, OperationContext opContext) {
        Utility.assertNotNullOrEmpty("value", value);
        request.setRequestProperty("x-ms-meta-" + name, value);
    }

    public static void addOptionalHeader(HttpURLConnection request, String name, String value) {
        if (value != null && !value.equals("")) {
            request.setRequestProperty(name, value);
        }
    }

    public static void addSnapshot(UriQueryBuilder builder, String snapshotVersion) throws StorageException {
        if (snapshotVersion != null) {
            builder.add("snapshot", snapshotVersion);
        }
    }

    public static HttpURLConnection create(URI uri, int timeout, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        retConnection.setFixedLengthStreamingMode(0);
        retConnection.setDoOutput(true);
        retConnection.setRequestMethod("PUT");
        return retConnection;
    }

    public static HttpURLConnection createURLConnection(URI uri, int timeoutInMs, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        if (timeoutInMs != 0) {
            builder.add(TIMEOUT, String.valueOf(timeoutInMs / 1000));
        }
        URL resourceUrl = builder.addToURI(uri).toURL();
        HttpURLConnection retConnection = (HttpURLConnection)resourceUrl.openConnection();
        retConnection.setReadTimeout(timeoutInMs);
        retConnection.setRequestProperty("Accept", "application/xml");
        retConnection.setRequestProperty("Accept-Charset", "UTF-8");
        retConnection.setRequestProperty("Content-Type", "");
        retConnection.setRequestProperty("x-ms-version", "2013-08-15");
        retConnection.setRequestProperty("User-Agent", BaseRequest.getUserAgent());
        retConnection.setRequestProperty("x-ms-client-request-id", opContext.getClientRequestID());
        return retConnection;
    }

    public static HttpURLConnection delete(URI uri, int timeout, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        retConnection.setRequestMethod("DELETE");
        return retConnection;
    }

    public static HttpURLConnection getMetadata(URI uri, int timeout, UriQueryBuilder builder, OperationContext opContext) throws StorageException, IOException, URISyntaxException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        builder.add("comp", METADATA);
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        retConnection.setRequestMethod("HEAD");
        return retConnection;
    }

    public static HttpURLConnection getProperties(URI uri, int timeout, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        retConnection.setRequestMethod("HEAD");
        return retConnection;
    }

    public static HttpURLConnection getServiceProperties(URI uri, int timeout, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        builder.add("comp", "properties");
        builder.add("restype", SERVICE);
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        retConnection.setRequestMethod("GET");
        return retConnection;
    }

    public static HttpURLConnection getServiceStats(URI uri, int timeout, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        builder.add("comp", STATS);
        builder.add("restype", SERVICE);
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        retConnection.setRequestMethod("GET");
        return retConnection;
    }

    public static String getUserAgent() {
        if (userAgent == null) {
            String userAgentComment = String.format(Utility.LOCALE_US, "(JavaJRE %s; %s %s)", System.getProperty("java.version"), System.getProperty("os.name").replaceAll(" ", ""), System.getProperty("os.version"));
            userAgent = String.format("%s/%s %s", "WA-Storage", "0.6.0", userAgentComment);
        }
        return userAgent;
    }

    public static HttpURLConnection setMetadata(URI uri, int timeout, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        builder.add("comp", METADATA);
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        retConnection.setFixedLengthStreamingMode(0);
        retConnection.setDoOutput(true);
        retConnection.setRequestMethod("PUT");
        return retConnection;
    }

    public static HttpURLConnection setServiceProperties(URI uri, int timeout, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        builder.add("comp", "properties");
        builder.add("restype", SERVICE);
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, timeout, builder, opContext);
        retConnection.setDoOutput(true);
        retConnection.setRequestMethod("PUT");
        return retConnection;
    }

    public static void signRequestForBlobAndQueue(HttpURLConnection request, Credentials credentials, Long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        request.setRequestProperty("x-ms-date", Utility.getGMTTime());
        Canonicalizer canonicalizer = CanonicalizerFactory.getBlobQueueFullCanonicalizer(request);
        String stringToSign = canonicalizer.canonicalize(request, credentials.getAccountName(), contentLength);
        String computedBase64Signature = StorageKey.computeMacSha256(credentials.getKey(), stringToSign);
        request.setRequestProperty("Authorization", String.format("%s %s:%s", "SharedKey", credentials.getAccountName(), computedBase64Signature));
    }

    public static void signRequestForBlobAndQueueSharedKeyLite(HttpURLConnection request, Credentials credentials, Long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        request.setRequestProperty("x-ms-date", Utility.getGMTTime());
        Canonicalizer canonicalizer = CanonicalizerFactory.getBlobQueueLiteCanonicalizer(request);
        String stringToSign = canonicalizer.canonicalize(request, credentials.getAccountName(), contentLength);
        String computedBase64Signature = StorageKey.computeMacSha256(credentials.getKey(), stringToSign);
        request.setRequestProperty("Authorization", String.format("%s %s:%s", "SharedKeyLite", credentials.getAccountName(), computedBase64Signature));
    }

    public static void signRequestForTableSharedKey(HttpURLConnection request, Credentials credentials, Long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        request.setRequestProperty("x-ms-date", Utility.getGMTTime());
        Canonicalizer canonicalizer = CanonicalizerFactory.getTableFullCanonicalizer(request);
        String stringToSign = canonicalizer.canonicalize(request, credentials.getAccountName(), contentLength);
        String computedBase64Signature = StorageKey.computeMacSha256(credentials.getKey(), stringToSign);
        request.setRequestProperty("Authorization", String.format("%s %s:%s", "SharedKey", credentials.getAccountName(), computedBase64Signature));
    }

    public static void signRequestForTableSharedKeyLite(HttpURLConnection request, Credentials credentials, Long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        request.setRequestProperty("x-ms-date", Utility.getGMTTime());
        Canonicalizer canonicalizer = CanonicalizerFactory.getTableLiteCanonicalizer(request);
        String stringToSign = canonicalizer.canonicalize(request, credentials.getAccountName(), contentLength);
        String computedBase64Signature = StorageKey.computeMacSha256(credentials.getKey(), stringToSign);
        request.setRequestProperty("Authorization", String.format("%s %s:%s", "SharedKeyLite", credentials.getAccountName(), computedBase64Signature));
    }

    private BaseRequest() {
    }
}

