/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.core;

import com.microsoft.windowsazure.storage.AccessCondition;
import com.microsoft.windowsazure.storage.AuthenticationScheme;
import com.microsoft.windowsazure.storage.LocationMode;
import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.RequestOptions;
import com.microsoft.windowsazure.storage.RequestResult;
import com.microsoft.windowsazure.storage.ServiceClient;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.StorageLocation;
import com.microsoft.windowsazure.storage.StorageUri;
import com.microsoft.windowsazure.storage.core.RequestLocationMode;
import com.microsoft.windowsazure.storage.core.StreamMd5AndLength;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.security.InvalidKeyException;

public abstract class StorageRequest<C, P, R> {
    private StorageException exceptionReference;
    private boolean nonExceptionedRetryableFailure;
    private RequestOptions requestOptions;
    private RequestResult result;
    private HttpURLConnection connection;
    private InputStream sendStream;
    private Long blobOffset = null;
    private Long length = null;
    private String lockedETag = null;
    private AccessCondition etagLockCondition = null;
    private boolean arePropertiesPopulated = false;
    private String contentMD5 = null;
    private StorageUri storageUri;
    private LocationMode locationMode;
    private RequestLocationMode requestLocationMode;
    private StorageLocation currentLocation;
    private long currentRequestByteCount = 0L;
    private boolean isSent = false;

    protected StorageRequest() {
    }

    public StorageRequest(RequestOptions options, StorageUri storageUri) {
        this.setRequestOptions(options);
        this.setStorageUri(storageUri);
        this.locationMode = LocationMode.PRIMARY_ONLY;
        this.requestLocationMode = RequestLocationMode.PRIMARY_ONLY;
    }

    public final StorageException getException() {
        return this.exceptionReference;
    }

    public final RequestOptions getRequestOptions() {
        return this.requestOptions;
    }

    public final RequestResult getResult() {
        return this.result;
    }

    public final HttpURLConnection getConnection() {
        return this.connection;
    }

    public final InputStream getSendStream() {
        return this.sendStream;
    }

    public Long getBlobOffset() {
        return this.blobOffset;
    }

    public Long getLength() {
        return this.length;
    }

    public final String getLockedETag() {
        return this.lockedETag;
    }

    public final String getContentMD5() {
        return this.contentMD5;
    }

    public LocationMode getLocationMode() {
        return this.locationMode;
    }

    public RequestLocationMode getRequestLocationMode() {
        return this.requestLocationMode;
    }

    public StorageLocation getCurrentLocation() {
        return this.currentLocation;
    }

    public AccessCondition getETagLockCondition() {
        return this.etagLockCondition;
    }

    public boolean getArePropertiesPopulated() {
        return this.arePropertiesPopulated;
    }

    public StorageUri getStorageUri() {
        return this.storageUri;
    }

    public long getCurrentRequestByteCount() {
        return this.currentRequestByteCount;
    }

    protected boolean isSent() {
        return this.isSent;
    }

    protected final void initialize(OperationContext opContext) {
        RequestResult currResult = new RequestResult();
        this.setResult(currResult);
        opContext.appendRequestResult(currResult);
        this.setException(null);
        this.setNonExceptionedRetryableFailure(false);
        this.setIsSent(false);
    }

    public final boolean isNonExceptionedRetryableFailure() {
        return this.nonExceptionedRetryableFailure;
    }

    protected final StorageException materializeException(HttpURLConnection request, OperationContext opContext) {
        if (this.getException() != null) {
            return this.getException();
        }
        return StorageException.translateException(request, null, opContext);
    }

    public static final void signBlobAndQueueRequest(HttpURLConnection request, ServiceClient client, long contentLength, OperationContext context) throws InvalidKeyException, StorageException {
        if (client.getAuthenticationScheme() == AuthenticationScheme.SHAREDKEYFULL) {
            client.getCredentials().signBlobAndQueueRequest(request, contentLength, context);
        } else {
            client.getCredentials().signBlobAndQueueRequestLite(request, contentLength, context);
        }
    }

    public static final void signTableRequest(HttpURLConnection request, ServiceClient client, long contentLength, OperationContext context) throws InvalidKeyException, StorageException {
        if (client.getAuthenticationScheme() == AuthenticationScheme.SHAREDKEYFULL) {
            client.getCredentials().signTableRequest(request, contentLength, context);
        } else {
            client.getCredentials().signTableRequestLite(request, contentLength, context);
        }
    }

    public void applyLocationModeToRequest() {
        if (this.getRequestOptions().getLocationMode() != null) {
            this.setLocationMode(this.getRequestOptions().getLocationMode());
        }
    }

    public void initializeLocation() {
        block5: {
            block4: {
                if (this.getStorageUri() == null) break block4;
                switch (this.getLocationMode()) {
                    case PRIMARY_ONLY: 
                    case PRIMARY_THEN_SECONDARY: {
                        this.setCurrentLocation(StorageLocation.PRIMARY);
                        break block5;
                    }
                    case SECONDARY_ONLY: 
                    case SECONDARY_THEN_PRIMARY: {
                        this.setCurrentLocation(StorageLocation.SECONDARY);
                        break block5;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("The argument is out of range. Argument name: %s, Value passed: %s.", new Object[]{"locationMode", this.getLocationMode()}));
                    }
                }
            }
            this.setCurrentLocation(StorageLocation.PRIMARY);
        }
    }

    public void validateLocation() {
        if (this.getStorageUri() != null && !this.getStorageUri().validateLocationMode(this.locationMode)) {
            throw new UnsupportedOperationException("The URI for the target storage location is not specified. Please consider changing the request's location mode.");
        }
        switch (this.getRequestLocationMode()) {
            case PRIMARY_ONLY: {
                if (this.getLocationMode() == LocationMode.SECONDARY_ONLY) {
                    throw new IllegalArgumentException("This operation can only be executed against the primary storage location.");
                }
                this.setCurrentLocation(StorageLocation.PRIMARY);
                this.setLocationMode(LocationMode.PRIMARY_ONLY);
                break;
            }
            case SECONDARY_ONLY: {
                if (this.getLocationMode() == LocationMode.PRIMARY_ONLY) {
                    throw new IllegalArgumentException("This operation can only be executed against the secondary storage location.");
                }
                this.setCurrentLocation(StorageLocation.SECONDARY);
                this.setLocationMode(LocationMode.SECONDARY_ONLY);
            }
        }
        this.getResult().setTargetLocation(this.currentLocation);
    }

    protected final void setException(StorageException exceptionReference) {
        this.exceptionReference = exceptionReference;
    }

    public final void setNonExceptionedRetryableFailure(boolean nonExceptionedRetryableFailure) {
        this.nonExceptionedRetryableFailure = nonExceptionedRetryableFailure;
    }

    protected final void setRequestOptions(RequestOptions requestOptions) {
        this.requestOptions = requestOptions;
    }

    public final void setResult(RequestResult result) {
        this.result = result;
    }

    public final void setConnection(HttpURLConnection connection) {
        this.connection = connection;
    }

    public void setSendStream(InputStream sendStream) {
        this.sendStream = sendStream;
    }

    public void setBlobOffset(Long blobOffset) {
        this.blobOffset = blobOffset;
    }

    public void setLength(Long length) {
        this.length = length;
    }

    public void setLockedETag(String lockedETag) {
        this.lockedETag = lockedETag;
    }

    public void setContentMD5(String contentMD5) {
        this.contentMD5 = contentMD5;
    }

    public void setETagLockCondition(AccessCondition etagLockCondition) {
        this.etagLockCondition = etagLockCondition;
    }

    public void setArePropertiesPopulated(boolean arePropertiesPopulated) {
        this.arePropertiesPopulated = arePropertiesPopulated;
    }

    public void setLocationMode(LocationMode locationMode) {
        this.locationMode = locationMode;
    }

    public void setRequestLocationMode(RequestLocationMode requestLocationMode) {
        this.requestLocationMode = requestLocationMode;
    }

    public void setCurrentLocation(StorageLocation currentLocation) {
        this.currentLocation = currentLocation;
    }

    public void setStorageUri(StorageUri storageUri) {
        this.storageUri = storageUri;
    }

    public void setCurrentRequestByteCount(long currentRequestByteCount) {
        this.currentRequestByteCount = currentRequestByteCount;
    }

    public void setRequestLocationMode() {
    }

    protected void setIsSent(boolean isSent) {
        this.isSent = isSent;
    }

    public abstract HttpURLConnection buildRequest(C var1, P var2, OperationContext var3) throws Exception;

    public void setHeaders(HttpURLConnection connection, P parentObject, OperationContext context) {
    }

    public abstract void signRequest(HttpURLConnection var1, C var2, OperationContext var3) throws Exception;

    public abstract R preProcessResponse(P var1, C var2, OperationContext var3) throws Exception;

    public R postProcessResponse(HttpURLConnection connection, P parentObject, C client, OperationContext context, R storageObject) throws Exception {
        return storageObject;
    }

    public void validateStreamWrite(StreamMd5AndLength descriptor) throws StorageException {
    }

    public void recoveryAction(OperationContext context) throws IOException {
    }
}

