/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.queue;

import com.microsoft.windowsazure.storage.DoesServiceRequest;
import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.RequestOptions;
import com.microsoft.windowsazure.storage.StorageCredentials;
import com.microsoft.windowsazure.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.windowsazure.storage.StorageErrorCode;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.StorageUri;
import com.microsoft.windowsazure.storage.core.BaseResponse;
import com.microsoft.windowsazure.storage.core.ExecutionEngine;
import com.microsoft.windowsazure.storage.core.PathUtility;
import com.microsoft.windowsazure.storage.core.RequestLocationMode;
import com.microsoft.windowsazure.storage.core.SharedAccessPolicyDeserializer;
import com.microsoft.windowsazure.storage.core.SharedAccessPolicySerializer;
import com.microsoft.windowsazure.storage.core.SharedAccessSignatureHelper;
import com.microsoft.windowsazure.storage.core.StorageRequest;
import com.microsoft.windowsazure.storage.core.UriQueryBuilder;
import com.microsoft.windowsazure.storage.core.Utility;
import com.microsoft.windowsazure.storage.queue.CloudQueueClient;
import com.microsoft.windowsazure.storage.queue.CloudQueueMessage;
import com.microsoft.windowsazure.storage.queue.MessageUpdateFields;
import com.microsoft.windowsazure.storage.queue.QueueDeserializer;
import com.microsoft.windowsazure.storage.queue.QueueMessageSerializer;
import com.microsoft.windowsazure.storage.queue.QueuePermissions;
import com.microsoft.windowsazure.storage.queue.QueueRequest;
import com.microsoft.windowsazure.storage.queue.QueueRequestOptions;
import com.microsoft.windowsazure.storage.queue.QueueResponse;
import com.microsoft.windowsazure.storage.queue.SharedAccessQueuePolicy;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;

public final class CloudQueue {
    private String name;
    private CloudQueueClient queueServiceClient;
    private HashMap<String, String> metadata;
    private long approximateMessageCount;
    private StorageUri messageRequestAddress;
    private StorageUri storageUri;
    private boolean shouldEncodeMessage;

    private static CloudQueueMessage getFirstOrNull(Iterable<CloudQueueMessage> messages) {
        Iterator<CloudQueueMessage> i$ = messages.iterator();
        if (i$.hasNext()) {
            CloudQueueMessage m = i$.next();
            return m;
        }
        return null;
    }

    public CloudQueue(String queueName, CloudQueueClient client) throws URISyntaxException, StorageException {
        Utility.assertNotNull("client", client);
        Utility.assertNotNull("queueName", queueName);
        this.storageUri = PathUtility.appendPathToUri(client.getStorageUri(), queueName);
        this.name = queueName;
        this.queueServiceClient = client;
        this.shouldEncodeMessage = true;
        this.parseQueryAndVerify(this.storageUri, client, client.isUsePathStyleUris());
    }

    public CloudQueue(URI uri, CloudQueueClient client) throws URISyntaxException, StorageException {
        this(new StorageUri(uri, null), client);
    }

    public CloudQueue(StorageUri uri, CloudQueueClient client) throws URISyntaxException, StorageException {
        Utility.assertNotNull("storageUri", uri);
        this.storageUri = uri;
        boolean usePathStyleUris = client == null ? Utility.determinePathStyleFromUri(this.storageUri.getPrimaryUri(), null) : client.isUsePathStyleUris();
        this.name = PathUtility.getQueueNameFromUri(uri.getPrimaryUri(), usePathStyleUris);
        this.queueServiceClient = client;
        this.shouldEncodeMessage = true;
        this.parseQueryAndVerify(this.storageUri, client, usePathStyleUris);
    }

    @DoesServiceRequest
    public void addMessage(CloudQueueMessage message) throws StorageException {
        this.addMessage(message, 0, 0, null, null);
    }

    @DoesServiceRequest
    public void addMessage(CloudQueueMessage message, int timeToLiveInSeconds, int initialVisibilityDelayInSeconds, QueueRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("message", message);
        Utility.assertNotNull("messageContent", message.getMessageContentAsByte());
        Utility.assertInBounds("timeToLiveInSeconds", timeToLiveInSeconds, 0L, 604800L);
        int realTimeToLiveInSeconds = timeToLiveInSeconds == 0 ? 604800 : timeToLiveInSeconds;
        Utility.assertInBounds("initialVisibilityDelayInSeconds", initialVisibilityDelayInSeconds, 0L, realTimeToLiveInSeconds - 1);
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = QueueRequestOptions.applyDefaults(options, this.queueServiceClient);
        ExecutionEngine.executeWithRetry(this.queueServiceClient, this, this.addMessageImpl(message, realTimeToLiveInSeconds, initialVisibilityDelayInSeconds, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudQueueClient, CloudQueue, Void> addMessageImpl(CloudQueueMessage message, final int timeToLiveInSeconds, final int initialVisibilityDelayInSeconds, final QueueRequestOptions options) throws StorageException {
        String stringToSend = message.getMessageContentForTransfer(this.shouldEncodeMessage);
        try {
            final byte[] messageBytes = QueueMessageSerializer.generateMessageRequestBody(stringToSend);
            StorageRequest<CloudQueueClient, CloudQueue, Void> putRequest = new StorageRequest<CloudQueueClient, CloudQueue, Void>((RequestOptions)options, this.getStorageUri()){

                @Override
                public HttpURLConnection buildRequest(CloudQueueClient client, CloudQueue queue, OperationContext context) throws Exception {
                    this.setSendStream(new ByteArrayInputStream(messageBytes));
                    this.setLength(Long.valueOf(messageBytes.length));
                    return QueueRequest.putMessage(queue.getMessageRequestAddress(context).getUri(this.getCurrentLocation()), options.getTimeoutIntervalInMs(), initialVisibilityDelayInSeconds, timeToLiveInSeconds, context);
                }

                @Override
                public void signRequest(HttpURLConnection connection, CloudQueueClient client, OperationContext context) throws Exception {
                    StorageRequest.signBlobAndQueueRequest(connection, client, messageBytes.length, null);
                }

                @Override
                public Void preProcessResponse(CloudQueue parentObject, CloudQueueClient client, OperationContext context) throws Exception {
                    if (this.getResult().getStatusCode() != 201) {
                        this.setNonExceptionedRetryableFailure(true);
                        return null;
                    }
                    return null;
                }
            };
            return putRequest;
        }
        catch (XMLStreamException e) {
            StorageException translatedException = StorageException.translateException(null, e, null);
            throw translatedException;
        }
    }

    @DoesServiceRequest
    public void clear() throws StorageException {
        this.clear(null, null);
    }

    @DoesServiceRequest
    public void clear(QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = QueueRequestOptions.applyDefaults(options, this.queueServiceClient);
        ExecutionEngine.executeWithRetry(this.queueServiceClient, this, this.clearImpl(options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudQueueClient, CloudQueue, Void> clearImpl(final QueueRequestOptions options) throws StorageException {
        StorageRequest<CloudQueueClient, CloudQueue, Void> putRequest = new StorageRequest<CloudQueueClient, CloudQueue, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudQueueClient client, CloudQueue queue, OperationContext context) throws Exception {
                return QueueRequest.clearMessages(queue.getMessageRequestAddress(context).getUri(this.getCurrentLocation()), options.getTimeoutIntervalInMs(), context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudQueueClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobAndQueueRequest(connection, client, -1L, null);
            }

            @Override
            public Void preProcessResponse(CloudQueue parentObject, CloudQueueClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 204) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public void create() throws StorageException {
        this.create(null, null);
    }

    @DoesServiceRequest
    public void create(QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = QueueRequestOptions.applyDefaults(options, this.queueServiceClient);
        ExecutionEngine.executeWithRetry(this.queueServiceClient, this, this.createImpl(options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudQueueClient, CloudQueue, Void> createImpl(final QueueRequestOptions options) throws StorageException {
        StorageRequest<CloudQueueClient, CloudQueue, Void> putRequest = new StorageRequest<CloudQueueClient, CloudQueue, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudQueueClient client, CloudQueue queue, OperationContext context) throws Exception {
                return QueueRequest.create(queue.getTransformedAddress(context).getUri(this.getCurrentLocation()), options.getTimeoutIntervalInMs(), context);
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudQueue queue, OperationContext context) {
                QueueRequest.addMetadata(connection, queue.metadata, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudQueueClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobAndQueueRequest(connection, client, 0L, null);
            }

            @Override
            public Void preProcessResponse(CloudQueue parentObject, CloudQueueClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 201 && this.getResult().getStatusCode() != 204) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public boolean createIfNotExists() throws StorageException {
        return this.createIfNotExists(null, null);
    }

    @DoesServiceRequest
    public boolean createIfNotExists(QueueRequestOptions options, OperationContext opContext) throws StorageException {
        boolean exists = this.exists(true, options = QueueRequestOptions.applyDefaults(options, this.queueServiceClient), opContext);
        if (exists) {
            return false;
        }
        try {
            this.create(options, opContext);
            return true;
        }
        catch (StorageException e) {
            if (e.getHttpStatusCode() == 409 && "QueueAlreadyExists".equals(e.getErrorCode())) {
                return false;
            }
            throw e;
        }
    }

    @DoesServiceRequest
    public void delete() throws StorageException {
        this.delete(null, null);
    }

    @DoesServiceRequest
    public void delete(QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = QueueRequestOptions.applyDefaults(options, this.queueServiceClient);
        ExecutionEngine.executeWithRetry(this.queueServiceClient, this, this.deleteImpl(options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudQueueClient, CloudQueue, Void> deleteImpl(final QueueRequestOptions options) throws StorageException {
        StorageRequest<CloudQueueClient, CloudQueue, Void> deleteRequest = new StorageRequest<CloudQueueClient, CloudQueue, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudQueueClient client, CloudQueue queue, OperationContext context) throws Exception {
                return QueueRequest.delete(queue.getTransformedAddress(context).getUri(this.getCurrentLocation()), options.getTimeoutIntervalInMs(), context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudQueueClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobAndQueueRequest(connection, client, -1L, null);
            }

            @Override
            public Void preProcessResponse(CloudQueue parentObject, CloudQueueClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 204) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }
        };
        return deleteRequest;
    }

    @DoesServiceRequest
    public boolean deleteIfExists() throws StorageException {
        return this.deleteIfExists(null, null);
    }

    @DoesServiceRequest
    public boolean deleteIfExists(QueueRequestOptions options, OperationContext opContext) throws StorageException {
        boolean exists = this.exists(true, options = QueueRequestOptions.applyDefaults(options, this.queueServiceClient), opContext);
        if (exists) {
            try {
                this.delete(options, opContext);
                return true;
            }
            catch (StorageException e) {
                if (e.getHttpStatusCode() == 404 && StorageErrorCode.RESOURCE_NOT_FOUND.toString().equals(e.getErrorCode())) {
                    return false;
                }
                throw e;
            }
        }
        return false;
    }

    @DoesServiceRequest
    public void deleteMessage(CloudQueueMessage message) throws StorageException {
        this.deleteMessage(message, null, null);
    }

    @DoesServiceRequest
    public void deleteMessage(CloudQueueMessage message, QueueRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("message", message);
        Utility.assertNotNullOrEmpty("messageId", message.getId());
        Utility.assertNotNullOrEmpty("popReceipt", message.getPopReceipt());
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = QueueRequestOptions.applyDefaults(options, this.queueServiceClient);
        ExecutionEngine.executeWithRetry(this.queueServiceClient, this, this.deleteMessageImpl(message, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudQueueClient, CloudQueue, Void> deleteMessageImpl(CloudQueueMessage message, final QueueRequestOptions options) throws StorageException {
        final String messageId = message.getId();
        final String messagePopReceipt = message.getPopReceipt();
        StorageRequest<CloudQueueClient, CloudQueue, Void> putRequest = new StorageRequest<CloudQueueClient, CloudQueue, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudQueueClient client, CloudQueue queue, OperationContext context) throws Exception {
                return QueueRequest.deleteMessage(queue.getIndividualMessageAddress(messageId, context).getUri(this.getCurrentLocation()), options.getTimeoutIntervalInMs(), messagePopReceipt, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudQueueClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobAndQueueRequest(connection, client, -1L, null);
            }

            @Override
            public Void preProcessResponse(CloudQueue parentObject, CloudQueueClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 204) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public void downloadAttributes() throws StorageException {
        this.downloadAttributes(null, null);
    }

    @DoesServiceRequest
    public void downloadAttributes(QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = QueueRequestOptions.applyDefaults(options, this.queueServiceClient);
        ExecutionEngine.executeWithRetry(this.queueServiceClient, this, this.downloadAttributesImpl(options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudQueueClient, CloudQueue, Void> downloadAttributesImpl(final QueueRequestOptions options) throws StorageException {
        StorageRequest<CloudQueueClient, CloudQueue, Void> getRequest = new StorageRequest<CloudQueueClient, CloudQueue, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudQueueClient client, CloudQueue queue, OperationContext context) throws Exception {
                return QueueRequest.downloadAttributes(queue.getTransformedAddress(context).getUri(this.getCurrentLocation()), options.getTimeoutIntervalInMs(), context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudQueueClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobAndQueueRequest(connection, client, -1L, null);
            }

            @Override
            public Void preProcessResponse(CloudQueue queue, CloudQueueClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                queue.metadata = BaseResponse.getMetadata(this.getConnection());
                queue.approximateMessageCount = QueueResponse.getApproximateMessageCount(this.getConnection());
                return null;
            }
        };
        return getRequest;
    }

    @DoesServiceRequest
    public boolean exists() throws StorageException {
        return this.exists(null, null);
    }

    @DoesServiceRequest
    public boolean exists(QueueRequestOptions options, OperationContext opContext) throws StorageException {
        return this.exists(false, options, opContext);
    }

    @DoesServiceRequest
    private boolean exists(boolean primaryOnly, QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = QueueRequestOptions.applyDefaults(options, this.queueServiceClient);
        return ExecutionEngine.executeWithRetry(this.queueServiceClient, this, this.existsImpl(primaryOnly, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudQueueClient, CloudQueue, Boolean> existsImpl(final boolean primaryOnly, final QueueRequestOptions options) throws StorageException {
        StorageRequest<CloudQueueClient, CloudQueue, Boolean> getRequest = new StorageRequest<CloudQueueClient, CloudQueue, Boolean>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(primaryOnly ? RequestLocationMode.PRIMARY_ONLY : RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudQueueClient client, CloudQueue queue, OperationContext context) throws Exception {
                return QueueRequest.downloadAttributes(queue.getTransformedAddress(context).getUri(this.getCurrentLocation()), options.getTimeoutIntervalInMs(), context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudQueueClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobAndQueueRequest(connection, client, -1L, null);
            }

            @Override
            public Boolean preProcessResponse(CloudQueue parentObject, CloudQueueClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() == 200) {
                    return true;
                }
                if (this.getResult().getStatusCode() == 404) {
                    return false;
                }
                this.setNonExceptionedRetryableFailure(true);
                return false;
            }
        };
        return getRequest;
    }

    public long getApproximateMessageCount() {
        return this.approximateMessageCount;
    }

    private StorageUri getIndividualMessageAddress(String messageId, OperationContext opContext) throws URISyntaxException, StorageException {
        return PathUtility.appendPathToUri(this.getMessageRequestAddress(opContext), messageId);
    }

    private StorageUri getMessageRequestAddress(OperationContext opContext) throws URISyntaxException, StorageException {
        if (this.messageRequestAddress == null) {
            this.messageRequestAddress = PathUtility.appendPathToUri(this.getTransformedAddress(opContext), "messages");
        }
        return this.messageRequestAddress;
    }

    public HashMap<String, String> getMetadata() {
        return this.metadata;
    }

    public String getName() {
        return this.name;
    }

    public CloudQueueClient getServiceClient() {
        return this.queueServiceClient;
    }

    public boolean getShouldEncodeMessage() {
        return this.shouldEncodeMessage;
    }

    public final StorageUri getStorageUri() {
        return this.storageUri;
    }

    public URI getUri() {
        return this.storageUri.getPrimaryUri();
    }

    @DoesServiceRequest
    public CloudQueueMessage peekMessage() throws StorageException {
        return this.peekMessage(null, null);
    }

    @DoesServiceRequest
    public CloudQueueMessage peekMessage(QueueRequestOptions options, OperationContext opContext) throws StorageException {
        return CloudQueue.getFirstOrNull(this.peekMessages(1, null, null));
    }

    @DoesServiceRequest
    public Iterable<CloudQueueMessage> peekMessages(int numberOfMessages) throws StorageException {
        return this.peekMessages(numberOfMessages, null, null);
    }

    @DoesServiceRequest
    public Iterable<CloudQueueMessage> peekMessages(int numberOfMessages, QueueRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertInBounds("numberOfMessages", numberOfMessages, 1L, 32L);
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = QueueRequestOptions.applyDefaults(options, this.queueServiceClient);
        return ExecutionEngine.executeWithRetry(this.queueServiceClient, this, this.peekMessagesImpl(numberOfMessages, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudQueueClient, CloudQueue, ArrayList<CloudQueueMessage>> peekMessagesImpl(final int numberOfMessages, final QueueRequestOptions options) throws StorageException {
        StorageRequest<CloudQueueClient, CloudQueue, ArrayList<CloudQueueMessage>> getRequest = new StorageRequest<CloudQueueClient, CloudQueue, ArrayList<CloudQueueMessage>>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudQueueClient client, CloudQueue queue, OperationContext context) throws Exception {
                return QueueRequest.peekMessages(queue.getMessageRequestAddress(context).getUri(this.getCurrentLocation()), options.getTimeoutIntervalInMs(), numberOfMessages, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudQueueClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobAndQueueRequest(connection, client, -1L, null);
            }

            @Override
            public ArrayList<CloudQueueMessage> preProcessResponse(CloudQueue queue, CloudQueueClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                return QueueDeserializer.readMessages(this.getConnection().getInputStream(), queue.shouldEncodeMessage);
            }
        };
        return getRequest;
    }

    @DoesServiceRequest
    public CloudQueueMessage retrieveMessage() throws StorageException {
        return this.retrieveMessage(30, null, null);
    }

    @DoesServiceRequest
    public CloudQueueMessage retrieveMessage(int visibilityTimeoutInSeconds, QueueRequestOptions options, OperationContext opContext) throws StorageException {
        return CloudQueue.getFirstOrNull(this.retrieveMessages(1, visibilityTimeoutInSeconds, options, opContext));
    }

    @DoesServiceRequest
    public Iterable<CloudQueueMessage> retrieveMessages(int numberOfMessages) throws StorageException {
        return this.retrieveMessages(numberOfMessages, 30, null, null);
    }

    @DoesServiceRequest
    public Iterable<CloudQueueMessage> retrieveMessages(int numberOfMessages, int visibilityTimeoutInSeconds, QueueRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertInBounds("numberOfMessages", numberOfMessages, 1L, 32L);
        Utility.assertInBounds("visibilityTimeoutInSeconds", visibilityTimeoutInSeconds, 0L, 604800L);
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = QueueRequestOptions.applyDefaults(options, this.queueServiceClient);
        return ExecutionEngine.executeWithRetry(this.queueServiceClient, this, this.retrieveMessagesImpl(numberOfMessages, visibilityTimeoutInSeconds, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudQueueClient, CloudQueue, ArrayList<CloudQueueMessage>> retrieveMessagesImpl(final int numberOfMessages, final int visibilityTimeoutInSeconds, final QueueRequestOptions options) throws StorageException {
        StorageRequest<CloudQueueClient, CloudQueue, ArrayList<CloudQueueMessage>> getRequest = new StorageRequest<CloudQueueClient, CloudQueue, ArrayList<CloudQueueMessage>>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudQueueClient client, CloudQueue queue, OperationContext context) throws Exception {
                return QueueRequest.retrieveMessages(queue.getMessageRequestAddress(context).getUri(this.getCurrentLocation()), options.getTimeoutIntervalInMs(), numberOfMessages, visibilityTimeoutInSeconds, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudQueueClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobAndQueueRequest(connection, client, -1L, null);
            }

            @Override
            public ArrayList<CloudQueueMessage> preProcessResponse(CloudQueue queue, CloudQueueClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                return QueueDeserializer.readMessages(this.getConnection().getInputStream(), queue.shouldEncodeMessage);
            }
        };
        return getRequest;
    }

    public void setMetadata(HashMap<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setShouldEncodeMessage(boolean shouldEncodeMessage) {
        this.shouldEncodeMessage = shouldEncodeMessage;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public void updateMessage(CloudQueueMessage message, int visibilityTimeoutInSeconds) throws StorageException {
        this.updateMessage(message, visibilityTimeoutInSeconds, EnumSet.of(MessageUpdateFields.VISIBILITY), null, null);
    }

    @DoesServiceRequest
    public void updateMessage(CloudQueueMessage message, int visibilityTimeoutInSeconds, EnumSet<MessageUpdateFields> messageUpdateFields, QueueRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("message", message);
        Utility.assertNotNullOrEmpty("messageId", message.getId());
        Utility.assertNotNullOrEmpty("popReceipt", message.getPopReceipt());
        Utility.assertInBounds("visibilityTimeoutInSeconds", visibilityTimeoutInSeconds, 0L, 604800L);
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = QueueRequestOptions.applyDefaults(options, this.queueServiceClient);
        ExecutionEngine.executeWithRetry(this.queueServiceClient, this, this.updateMessageImpl(message, visibilityTimeoutInSeconds, messageUpdateFields, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudQueueClient, CloudQueue, Void> updateMessageImpl(final CloudQueueMessage message, final int visibilityTimeoutInSeconds, final EnumSet<MessageUpdateFields> messageUpdateFields, final QueueRequestOptions options) throws StorageException {
        final String stringToSend = message.getMessageContentForTransfer(this.shouldEncodeMessage);
        StorageRequest<CloudQueueClient, CloudQueue, Void> putRequest = new StorageRequest<CloudQueueClient, CloudQueue, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudQueueClient client, CloudQueue queue, OperationContext context) throws Exception {
                if (messageUpdateFields.contains((Object)MessageUpdateFields.CONTENT)) {
                    byte[] messageBytes = QueueMessageSerializer.generateMessageRequestBody(stringToSend);
                    this.setSendStream(new ByteArrayInputStream(messageBytes));
                    this.setLength(Long.valueOf(messageBytes.length));
                }
                return QueueRequest.updateMessage(queue.getIndividualMessageAddress(message.getId(), context).getUri(this.getCurrentLocation()), options.getTimeoutIntervalInMs(), message.getPopReceipt(), visibilityTimeoutInSeconds, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudQueueClient client, OperationContext context) throws Exception {
                if (messageUpdateFields.contains((Object)MessageUpdateFields.CONTENT)) {
                    StorageRequest.signBlobAndQueueRequest(connection, client, this.getLength(), null);
                } else {
                    connection.setFixedLengthStreamingMode(0);
                    StorageRequest.signBlobAndQueueRequest(connection, client, 0L, null);
                }
            }

            @Override
            public Void preProcessResponse(CloudQueue queue, CloudQueueClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 204) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                message.setPopReceipt(this.getConnection().getHeaderField("x-ms-popreceipt"));
                message.setNextVisibleTime(Utility.parseRFC1123DateFromStringInGMT(this.getConnection().getHeaderField("x-ms-time-next-visible")));
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public void uploadMetadata() throws StorageException {
        this.uploadMetadata(null, null);
    }

    @DoesServiceRequest
    public void uploadMetadata(QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = QueueRequestOptions.applyDefaults(options, this.queueServiceClient);
        ExecutionEngine.executeWithRetry(this.queueServiceClient, this, this.uploadMetadataImpl(options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudQueueClient, CloudQueue, Void> uploadMetadataImpl(final QueueRequestOptions options) throws StorageException {
        StorageRequest<CloudQueueClient, CloudQueue, Void> putRequest = new StorageRequest<CloudQueueClient, CloudQueue, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudQueueClient client, CloudQueue queue, OperationContext context) throws Exception {
                return QueueRequest.setMetadata(queue.getTransformedAddress(context).getUri(this.getCurrentLocation()), options.getTimeoutIntervalInMs(), context);
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudQueue queue, OperationContext context) {
                QueueRequest.addMetadata(connection, queue.metadata, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudQueueClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobAndQueueRequest(connection, client, 0L, null);
            }

            @Override
            public Void preProcessResponse(CloudQueue parentObject, CloudQueueClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 204) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public void uploadPermissions(QueuePermissions permissions) throws StorageException {
        this.uploadPermissions(permissions, null, null);
    }

    @DoesServiceRequest
    public void uploadPermissions(QueuePermissions permissions, QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = QueueRequestOptions.applyDefaults(options, this.queueServiceClient);
        ExecutionEngine.executeWithRetry(this.queueServiceClient, this, this.uploadPermissionsImpl(permissions, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudQueueClient, CloudQueue, Void> uploadPermissionsImpl(QueuePermissions permissions, final QueueRequestOptions options) throws StorageException {
        StringWriter outBuffer = new StringWriter();
        try {
            SharedAccessPolicySerializer.writeSharedAccessIdentifiersToStream(permissions.getSharedAccessPolicies(), outBuffer);
            final byte[] aclBytes = outBuffer.toString().getBytes("UTF-8");
            StorageRequest<CloudQueueClient, CloudQueue, Void> putRequest = new StorageRequest<CloudQueueClient, CloudQueue, Void>((RequestOptions)options, this.getStorageUri()){

                @Override
                public HttpURLConnection buildRequest(CloudQueueClient client, CloudQueue queue, OperationContext context) throws Exception {
                    this.setSendStream(new ByteArrayInputStream(aclBytes));
                    this.setLength(Long.valueOf(aclBytes.length));
                    return QueueRequest.setAcl(queue.getTransformedAddress(context).getUri(this.getCurrentLocation()), options.getTimeoutIntervalInMs(), context);
                }

                @Override
                public void signRequest(HttpURLConnection connection, CloudQueueClient client, OperationContext context) throws Exception {
                    StorageRequest.signBlobAndQueueRequest(connection, client, aclBytes.length, null);
                }

                @Override
                public Void preProcessResponse(CloudQueue parentObject, CloudQueueClient client, OperationContext context) throws Exception {
                    if (this.getResult().getStatusCode() != 204) {
                        this.setNonExceptionedRetryableFailure(true);
                    }
                    return null;
                }
            };
            return putRequest;
        }
        catch (IllegalArgumentException e) {
            StorageException translatedException = StorageException.translateException(null, e, null);
            throw translatedException;
        }
        catch (XMLStreamException e) {
            StorageException translatedException = StorageException.translateException(null, e, null);
            throw translatedException;
        }
        catch (UnsupportedEncodingException e) {
            StorageException translatedException = StorageException.translateException(null, e, null);
            throw translatedException;
        }
    }

    @DoesServiceRequest
    public QueuePermissions downloadPermissions() throws StorageException {
        return this.downloadPermissions(null, null);
    }

    @DoesServiceRequest
    public QueuePermissions downloadPermissions(QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = QueueRequestOptions.applyDefaults(options, this.queueServiceClient);
        return ExecutionEngine.executeWithRetry(this.queueServiceClient, this, this.downloadPermissionsImpl(options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudQueueClient, CloudQueue, QueuePermissions> downloadPermissionsImpl(final QueueRequestOptions options) throws StorageException {
        StorageRequest<CloudQueueClient, CloudQueue, QueuePermissions> getRequest = new StorageRequest<CloudQueueClient, CloudQueue, QueuePermissions>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudQueueClient client, CloudQueue queue, OperationContext context) throws Exception {
                return QueueRequest.getAcl(queue.getTransformedAddress(context).getUri(this.getCurrentLocation()), options.getTimeoutIntervalInMs(), context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudQueueClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobAndQueueRequest(connection, client, -1L, null);
            }

            @Override
            public QueuePermissions preProcessResponse(CloudQueue parentObject, CloudQueueClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                return new QueuePermissions();
            }

            @Override
            public QueuePermissions postProcessResponse(HttpURLConnection connection, CloudQueue queue, CloudQueueClient client, OperationContext context, QueuePermissions queuePermissions) throws Exception {
                HashMap<String, SharedAccessQueuePolicy> accessIds = SharedAccessPolicyDeserializer.getAccessIdentifiers(this.getConnection().getInputStream(), SharedAccessQueuePolicy.class);
                for (String key : accessIds.keySet()) {
                    queuePermissions.getSharedAccessPolicies().put(key, accessIds.get(key));
                }
                return queuePermissions;
            }
        };
        return getRequest;
    }

    public String generateSharedAccessSignature(SharedAccessQueuePolicy policy, String groupPolicyIdentifier) throws InvalidKeyException, StorageException {
        if (!this.queueServiceClient.getCredentials().canCredentialsSignRequest()) {
            String errorMessage = "Cannot create Shared Access Signature unless the Account Key credentials are used by the ServiceClient.";
            throw new IllegalArgumentException("Cannot create Shared Access Signature unless the Account Key credentials are used by the ServiceClient.");
        }
        String resourceName = this.getSharedAccessCanonicalName();
        String signature = SharedAccessSignatureHelper.generateSharedAccessSignatureHashForQueue(policy, groupPolicyIdentifier, resourceName, this.queueServiceClient, null);
        UriQueryBuilder builder = SharedAccessSignatureHelper.generateSharedAccessSignatureForQueue(policy, groupPolicyIdentifier, signature);
        return builder.toString();
    }

    private String getSharedAccessCanonicalName() {
        String accountName = this.getServiceClient().getCredentials().getAccountName();
        String queueName = this.getName();
        return String.format("/%s/%s", accountName, queueName);
    }

    private final StorageUri getTransformedAddress(OperationContext opContext) throws URISyntaxException, StorageException {
        if (this.queueServiceClient.getCredentials().doCredentialsNeedTransformUri()) {
            if (this.getStorageUri().isAbsolute()) {
                return this.queueServiceClient.getCredentials().transformUri(this.getStorageUri(), opContext);
            }
            StorageException ex = Utility.generateNewUnexpectedStorageException(null);
            ex.getExtendedErrorInformation().setErrorMessage("Queue Object relative URIs not supported.");
            throw ex;
        }
        return this.getStorageUri();
    }

    private void parseQueryAndVerify(StorageUri completeUri, CloudQueueClient existingClient, boolean usePathStyleUris) throws URISyntaxException, StorageException {
        Utility.assertNotNull("completeUri", completeUri);
        if (!completeUri.isAbsolute()) {
            String errorMessage = String.format("Address %s is a relative address. Only absolute addresses are permitted.", completeUri.toString());
            throw new IllegalArgumentException(errorMessage);
        }
        this.storageUri = PathUtility.stripURIQueryAndFragment(completeUri);
        HashMap<String, String[]> queryParameters = PathUtility.parseQueryString(completeUri.getQuery());
        StorageCredentialsSharedAccessSignature sasCreds = SharedAccessSignatureHelper.parseQuery(queryParameters);
        if (sasCreds == null) {
            return;
        }
        Boolean sameCredentials = existingClient == null ? false : Utility.areCredentialsEqual(sasCreds, existingClient.getCredentials());
        if (existingClient == null || !sameCredentials.booleanValue()) {
            this.queueServiceClient = new CloudQueueClient(PathUtility.getServiceClientBaseAddress(this.getStorageUri(), usePathStyleUris), (StorageCredentials)sasCreds);
        }
        if (existingClient != null && !sameCredentials.booleanValue()) {
            this.queueServiceClient.setRetryPolicyFactory(existingClient.getRetryPolicyFactory());
            this.queueServiceClient.setTimeoutInMs(existingClient.getTimeoutInMs());
            this.queueServiceClient.setLocationMode(existingClient.getLocationMode());
        }
    }
}

