/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.queue;

import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.StorageUri;
import com.microsoft.windowsazure.storage.core.DeserializationHelper;
import com.microsoft.windowsazure.storage.core.PathUtility;
import com.microsoft.windowsazure.storage.core.Utility;
import com.microsoft.windowsazure.storage.queue.CloudQueue;
import com.microsoft.windowsazure.storage.queue.CloudQueueClient;
import com.microsoft.windowsazure.storage.queue.CloudQueueMessage;
import com.microsoft.windowsazure.storage.queue.QueueMessageType;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class QueueDeserializationHelper {
    private static CloudQueueMessage readMessage(XMLStreamReader xmlr, boolean shouldEncodeMessage) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        xmlr.require(1, null, "QueueMessage");
        CloudQueueMessage message = new CloudQueueMessage();
        message.setMessageType(shouldEncodeMessage ? QueueMessageType.BASE_64_ENCODED : QueueMessageType.RAW_STRING);
        int eventType = xmlr.getEventType();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            String name = xmlr.getName().toString();
            if (eventType == 1) {
                if (name.equals("MessageId")) {
                    message.setMessageId(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"MessageId"));
                    continue;
                }
                if (name.equals("InsertionTime")) {
                    message.setInsertionTime(Utility.parseRFC1123DateFromStringInGMT(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"InsertionTime")));
                    continue;
                }
                if (name.equals("ExpirationTime")) {
                    message.setExpirationTime(Utility.parseRFC1123DateFromStringInGMT(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"ExpirationTime")));
                    continue;
                }
                if (name.equals("PopReceipt")) {
                    message.setPopReceipt(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"PopReceipt"));
                    continue;
                }
                if (name.equals("TimeNextVisible")) {
                    message.setNextVisibleTime(Utility.parseRFC1123DateFromStringInGMT(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"TimeNextVisible")));
                    continue;
                }
                if (name.equals("DequeueCount")) {
                    message.setDequeueCount(Integer.parseInt(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"DequeueCount")));
                    continue;
                }
                if (!name.equals("MessageText")) continue;
                message.messageContent = Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"MessageText");
                continue;
            }
            if (eventType != 2 || !name.equals("QueueMessage")) continue;
            break;
        }
        xmlr.require(2, null, "QueueMessage");
        return message;
    }

    protected static ArrayList<CloudQueueMessage> readMessages(InputStream stream, boolean shouldEncodeMessage) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        XMLStreamReader xmlr = Utility.createXMLStreamReaderFromStream((InputStream)stream);
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        eventType = xmlr.next();
        xmlr.require(1, null, "QueueMessagesList");
        ArrayList<CloudQueueMessage> messages = new ArrayList<CloudQueueMessage>();
        eventType = xmlr.next();
        while (eventType == 1 && xmlr.hasName() && "QueueMessage".equals(xmlr.getName().toString())) {
            messages.add(QueueDeserializationHelper.readMessage(xmlr, shouldEncodeMessage));
            eventType = xmlr.next();
        }
        xmlr.require(2, null, "QueueMessagesList");
        return messages;
    }

    private static CloudQueue readQueue(XMLStreamReader xmlr, CloudQueueClient serviceClient) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        xmlr.require(1, null, "Queue");
        String queueName = null;
        HashMap<String, String> queueMetadata = null;
        int eventType = xmlr.getEventType();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            String name = xmlr.getName().toString();
            if (eventType == 1) {
                if (name.equals("Name")) {
                    queueName = Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"Name");
                    continue;
                }
                if (!name.equals("Metadata")) continue;
                queueMetadata = DeserializationHelper.parseMetadateFromXML(xmlr);
                xmlr.require(2, null, "Metadata");
                continue;
            }
            if (eventType != 2 || !name.equals("Queue")) continue;
            break;
        }
        StorageUri queueUri = serviceClient.getStorageUri();
        queueUri = PathUtility.appendPathToUri(queueUri, queueName);
        CloudQueue queue = new CloudQueue(queueUri, serviceClient);
        queue.setMetadata(queueMetadata);
        queue.setName(queueName);
        xmlr.require(2, null, "Queue");
        return queue;
    }

    protected static ArrayList<CloudQueue> readQueues(XMLStreamReader xmlr, CloudQueueClient serviceClient) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        int eventType = xmlr.getEventType();
        xmlr.require(1, null, "Queues");
        ArrayList<CloudQueue> queues = new ArrayList<CloudQueue>();
        eventType = xmlr.next();
        while (eventType == 1 && xmlr.hasName() && "Queue".equals(xmlr.getName().toString())) {
            queues.add(QueueDeserializationHelper.readQueue(xmlr, serviceClient));
            eventType = xmlr.next();
        }
        xmlr.require(2, null, "Queues");
        return queues;
    }

    private QueueDeserializationHelper() {
    }
}

