/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.table;

import com.microsoft.windowsazure.storage.DoesServiceRequest;
import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.ResultContinuation;
import com.microsoft.windowsazure.storage.ResultContinuationType;
import com.microsoft.windowsazure.storage.ResultSegment;
import com.microsoft.windowsazure.storage.ServiceClient;
import com.microsoft.windowsazure.storage.ServiceProperties;
import com.microsoft.windowsazure.storage.ServiceStats;
import com.microsoft.windowsazure.storage.StorageCredentials;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.StorageUri;
import com.microsoft.windowsazure.storage.core.ExecutionEngine;
import com.microsoft.windowsazure.storage.core.LazySegmentedIterable;
import com.microsoft.windowsazure.storage.core.SegmentedStorageRequest;
import com.microsoft.windowsazure.storage.core.StorageRequest;
import com.microsoft.windowsazure.storage.core.Utility;
import com.microsoft.windowsazure.storage.table.CloudTable;
import com.microsoft.windowsazure.storage.table.EntityProperty;
import com.microsoft.windowsazure.storage.table.EntityResolver;
import com.microsoft.windowsazure.storage.table.ODataPayload;
import com.microsoft.windowsazure.storage.table.TableBatchOperation;
import com.microsoft.windowsazure.storage.table.TableDeserializer;
import com.microsoft.windowsazure.storage.table.TableEntity;
import com.microsoft.windowsazure.storage.table.TableOperation;
import com.microsoft.windowsazure.storage.table.TablePayloadFormat;
import com.microsoft.windowsazure.storage.table.TableQuery;
import com.microsoft.windowsazure.storage.table.TableRequest;
import com.microsoft.windowsazure.storage.table.TableRequestOptions;
import com.microsoft.windowsazure.storage.table.TableResponse;
import com.microsoft.windowsazure.storage.table.TableResult;
import com.microsoft.windowsazure.storage.table.TableServiceEntity;
import com.microsoft.windowsazure.storage.table.TableServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public final class CloudTableClient
extends ServiceClient {
    private TablePayloadFormat payloadFormat = TablePayloadFormat.Json;
    private final EntityResolver<String> tableNameResolver = new EntityResolver<String>(){

        @Override
        public String resolve(String partitionKey, String rowKey, Date timeStamp, HashMap<String, EntityProperty> properties, String etag) {
            return properties.get("TableName").getValueAsString();
        }
    };

    public CloudTableClient(URI baseUri) {
        this(new StorageUri(baseUri));
    }

    public CloudTableClient(StorageUri baseUri) {
        this(baseUri, null);
        this.setTimeoutInMs(60000);
    }

    public CloudTableClient(URI baseUri, StorageCredentials credentials) {
        this(new StorageUri(baseUri), credentials);
    }

    public CloudTableClient(StorageUri baseUri, StorageCredentials credentials) {
        super(baseUri, credentials);
        this.setTimeoutInMs(60000);
    }

    public CloudTable getTableReference(String tableName) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("tableName", tableName);
        return new CloudTable(tableName, this);
    }

    @DoesServiceRequest
    @Deprecated
    public ArrayList<TableResult> execute(String tableName, TableBatchOperation batch) throws StorageException {
        return this.execute(tableName, batch, null, null);
    }

    @Deprecated
    @DoesServiceRequest
    public ArrayList<TableResult> execute(String tableName, TableBatchOperation batch, TableRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("batch", batch);
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = TableRequestOptions.applyDefaults(options, this);
        return batch.execute(this, tableName, options, opContext);
    }

    @Deprecated
    @DoesServiceRequest
    public TableResult execute(String tableName, TableOperation operation) throws StorageException {
        return this.execute(tableName, operation, null, null);
    }

    @Deprecated
    @DoesServiceRequest
    public TableResult execute(String tableName, TableOperation operation, TableRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("operation", operation);
        return operation.execute(this, tableName, options, opContext);
    }

    @Deprecated
    @DoesServiceRequest
    public <R> Iterable<R> execute(TableQuery<?> query, EntityResolver<R> resolver) throws StorageException {
        return this.execute(query, resolver, null, null);
    }

    @Deprecated
    @DoesServiceRequest
    public <R> Iterable<R> execute(TableQuery<?> query, EntityResolver<R> resolver, TableRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("query", query);
        Utility.assertNotNull("Query requires a valid class type or resolver.", resolver);
        return this.generateIteratorForQuery(query, resolver, options, opContext);
    }

    @Deprecated
    @DoesServiceRequest
    public <T extends TableEntity> Iterable<T> execute(TableQuery<T> query) throws StorageException {
        return this.execute(query, null, null);
    }

    @Deprecated
    @DoesServiceRequest
    public <T extends TableEntity> Iterable<T> execute(TableQuery<T> query, TableRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("query", query);
        return this.generateIteratorForQuery(query, null, options, opContext);
    }

    @Deprecated
    @DoesServiceRequest
    public <R> ResultSegment<R> executeSegmented(TableQuery<?> query, EntityResolver<R> resolver, ResultContinuation continuationToken) throws IOException, URISyntaxException, StorageException {
        return this.executeSegmented(query, resolver, continuationToken, null, null);
    }

    @Deprecated
    @DoesServiceRequest
    public <R> ResultSegment<R> executeSegmented(TableQuery<?> query, EntityResolver<R> resolver, ResultContinuation continuationToken, TableRequestOptions options, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        Utility.assertNotNull("Query requires a valid class type or resolver.", resolver);
        return this.executeQuerySegmentedImpl(query, resolver, continuationToken, options, opContext);
    }

    @Deprecated
    @DoesServiceRequest
    public <T extends TableEntity> ResultSegment<T> executeSegmented(TableQuery<T> query, ResultContinuation continuationToken) throws IOException, URISyntaxException, StorageException {
        return this.executeSegmented(query, continuationToken, null, null);
    }

    @Deprecated
    @DoesServiceRequest
    public <T extends TableEntity> ResultSegment<T> executeSegmented(TableQuery<T> query, ResultContinuation continuationToken, TableRequestOptions options, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        Utility.assertNotNull("query", query);
        return this.executeQuerySegmentedImpl(query, null, continuationToken, options, opContext);
    }

    @DoesServiceRequest
    public Iterable<String> listTables() throws StorageException {
        return this.listTables(null);
    }

    @DoesServiceRequest
    public Iterable<String> listTables(String prefix) throws StorageException {
        return this.listTables(prefix, null, null);
    }

    @DoesServiceRequest
    public Iterable<String> listTables(String prefix, TableRequestOptions options, OperationContext opContext) throws StorageException {
        return this.execute(this.generateListTablesQuery(prefix), this.tableNameResolver, options, opContext);
    }

    @DoesServiceRequest
    public ResultSegment<String> listTablesSegmented() throws IOException, URISyntaxException, StorageException {
        return this.listTablesSegmented(null);
    }

    @DoesServiceRequest
    public ResultSegment<String> listTablesSegmented(String prefix) throws IOException, URISyntaxException, StorageException {
        return this.listTablesSegmented(prefix, null, null, null, null);
    }

    @DoesServiceRequest
    public ResultSegment<String> listTablesSegmented(String prefix, Integer maxResults, ResultContinuation continuationToken, TableRequestOptions options, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        return this.executeSegmented(this.generateListTablesQuery(prefix).take(maxResults), this.tableNameResolver, continuationToken, options, opContext);
    }

    private TableQuery<TableServiceEntity> generateListTablesQuery(String prefix) {
        TableQuery<TableServiceEntity> listQuery = TableQuery.from("Tables", TableServiceEntity.class);
        if (!Utility.isNullOrEmpty(prefix)) {
            String prefixFilter = String.format("(%s ge '%s') and (%s lt '%s{')", "TableName", prefix, "TableName", prefix);
            listQuery = listQuery.where(prefixFilter);
        }
        return listQuery;
    }

    protected <T extends TableEntity, R> ResultSegment<?> executeQuerySegmentedImpl(TableQuery<T> queryToExecute, EntityResolver<R> resolver, ResultContinuation continuationToken, TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = TableRequestOptions.applyDefaults(options, this);
        Utility.assertContinuationType(continuationToken, ResultContinuationType.TABLE);
        SegmentedStorageRequest segmentedRequest = new SegmentedStorageRequest();
        segmentedRequest.setToken(continuationToken);
        return ExecutionEngine.executeWithRetry(this, queryToExecute, this.executeQuerySegmentedWithResolverCoreImpl(queryToExecute, resolver, options, segmentedRequest), options.getRetryPolicyFactory(), opContext);
    }

    private <T extends TableEntity, R> StorageRequest<CloudTableClient, TableQuery<T>, ResultSegment<T>> executeQuerySegmentedCoreImpl(final TableQuery<T> queryToExecute, EntityResolver<R> resolver, final TableRequestOptions options, final SegmentedStorageRequest segmentedRequest) throws StorageException {
        if (resolver == null) {
            Utility.assertNotNull("Query requires a valid class type or resolver.", queryToExecute.getClazzType());
        }
        StorageRequest getRequest = new StorageRequest<CloudTableClient, TableQuery<T>, ResultSegment<T>>(options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(Utility.getListingLocationMode(segmentedRequest.getToken()));
            }

            @Override
            public HttpURLConnection buildRequest(CloudTableClient client, TableQuery<T> queryRef, OperationContext context) throws Exception {
                return TableRequest.query(client.getTransformedEndPoint(context).getUri(this.getCurrentLocation()), queryToExecute.getSourceTableName(), null, options.getTimeoutIntervalInMs(), queryToExecute.generateQueryBuilder(), segmentedRequest.getToken(), options, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudTableClient client, OperationContext context) throws Exception {
                StorageRequest.signTableRequest(connection, client, -1L, context);
            }

            @Override
            public ResultSegment<T> preProcessResponse(TableQuery<T> queryRef, CloudTableClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    throw TableServiceException.generateTableServiceException(true, this.getResult(), null, this.getConnection().getErrorStream(), options.getTablePayloadFormat());
                }
                return null;
            }

            @Override
            public ResultSegment<T> postProcessResponse(HttpURLConnection connection, TableQuery<T> queryRef, CloudTableClient client, OperationContext context, ResultSegment<T> storageObject) throws Exception {
                ODataPayload<?> clazzResponse = null;
                InputStream inStream = connection.getInputStream();
                clazzResponse = TableDeserializer.parseQueryResponse(inStream, options, queryToExecute.getClazzType(), null, context);
                ResultContinuation nextToken = TableResponse.getTableContinuationFromResponse(connection);
                if (nextToken != null) {
                    nextToken.setTargetLocation(this.getResult().getTargetLocation());
                }
                segmentedRequest.setToken(nextToken);
                return new ResultSegment(clazzResponse.results, queryToExecute.getTakeCount() == null ? clazzResponse.results.size() : queryToExecute.getTakeCount().intValue(), nextToken);
            }
        };
        return getRequest;
    }

    private <T extends TableEntity, R> StorageRequest<CloudTableClient, TableQuery<T>, ResultSegment<R>> executeQuerySegmentedWithResolverCoreImpl(final TableQuery<T> queryToExecute, final EntityResolver<R> resolver, final TableRequestOptions options, final SegmentedStorageRequest segmentedRequest) throws StorageException {
        if (resolver == null) {
            Utility.assertNotNull("Query requires a valid class type or resolver.", queryToExecute.getClazzType());
        }
        StorageRequest getRequest = new StorageRequest<CloudTableClient, TableQuery<T>, ResultSegment<R>>(options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(Utility.getListingLocationMode(segmentedRequest.getToken()));
            }

            @Override
            public HttpURLConnection buildRequest(CloudTableClient client, TableQuery<T> queryRef, OperationContext context) throws Exception {
                return TableRequest.query(client.getTransformedEndPoint(context).getUri(this.getCurrentLocation()), queryToExecute.getSourceTableName(), null, options.getTimeoutIntervalInMs(), queryToExecute.generateQueryBuilder(), segmentedRequest.getToken(), options, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudTableClient client, OperationContext context) throws Exception {
                StorageRequest.signTableRequest(connection, client, -1L, context);
            }

            @Override
            public ResultSegment<R> preProcessResponse(TableQuery<T> queryRef, CloudTableClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    throw TableServiceException.generateTableServiceException(true, this.getResult(), null, this.getConnection().getErrorStream(), options.getTablePayloadFormat());
                }
                return null;
            }

            @Override
            public ResultSegment<R> postProcessResponse(HttpURLConnection connection, TableQuery<T> queryRef, CloudTableClient client, OperationContext context, ResultSegment<R> storageObject) throws Exception {
                ODataPayload<?> resolvedResponse = null;
                InputStream inStream = connection.getInputStream();
                resolvedResponse = TableDeserializer.parseQueryResponse(inStream, options, queryToExecute.getClazzType(), resolver, context);
                ResultContinuation nextToken = TableResponse.getTableContinuationFromResponse(connection);
                if (nextToken != null) {
                    nextToken.setTargetLocation(this.getResult().getTargetLocation());
                }
                segmentedRequest.setToken(nextToken);
                return new ResultSegment(resolvedResponse.results, queryToExecute.getTakeCount() == null ? resolvedResponse.results.size() : queryToExecute.getTakeCount().intValue(), nextToken);
            }
        };
        return getRequest;
    }

    protected final StorageUri getTransformedEndPoint(OperationContext opContext) throws URISyntaxException, StorageException {
        if (this.getCredentials().doCredentialsNeedTransformUri()) {
            if (this.getEndpoint().isAbsolute()) {
                return this.getCredentials().transformUri(this.getStorageUri(), opContext);
            }
            StorageException ex = Utility.generateNewUnexpectedStorageException(null);
            ex.getExtendedErrorInformation().setErrorMessage("Table Object relative URIs not supported.");
            throw ex;
        }
        return this.getStorageUri();
    }

    protected <T extends TableEntity, R> Iterable<?> generateIteratorForQuery(TableQuery<T> queryRef, EntityResolver<R> resolver, TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = TableRequestOptions.applyDefaults(options, this);
        SegmentedStorageRequest segmentedRequest = new SegmentedStorageRequest();
        if (resolver == null) {
            return new LazySegmentedIterable<CloudTableClient, TableQuery<T>, T>(this.executeQuerySegmentedCoreImpl(queryRef, resolver, options, segmentedRequest), this, queryRef, options.getRetryPolicyFactory(), opContext);
        }
        return new LazySegmentedIterable<CloudTableClient, TableQuery<T>, R>(this.executeQuerySegmentedWithResolverCoreImpl(queryRef, resolver, options, segmentedRequest), this, queryRef, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public ServiceStats getServiceStats() throws StorageException {
        return this.getServiceStats(null, null);
    }

    @DoesServiceRequest
    public ServiceStats getServiceStats(TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = TableRequestOptions.applyDefaults(options, this);
        return ExecutionEngine.executeWithRetry(this, null, this.getServiceStatsImpl(options, true), this.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final ServiceProperties downloadServiceProperties() throws StorageException {
        return this.downloadServiceProperties(null, null);
    }

    @DoesServiceRequest
    public final ServiceProperties downloadServiceProperties(TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = TableRequestOptions.applyDefaults(options, this);
        return ExecutionEngine.executeWithRetry(this, null, this.downloadServicePropertiesImpl(options, true), options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public void uploadServiceProperties(ServiceProperties properties) throws StorageException {
        this.uploadServiceProperties(properties, null, null);
    }

    @DoesServiceRequest
    public void uploadServiceProperties(ServiceProperties properties, TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (!Utility.isNullOrEmpty(properties.getDefaultServiceVersion())) {
            throw new IllegalArgumentException("DefaultServiceVersion can only be set for the Blob service.");
        }
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = TableRequestOptions.applyDefaults(options, this);
        Utility.assertNotNull("properties", properties);
        ExecutionEngine.executeWithRetry(this, null, this.uploadServicePropertiesImpl(properties, options, opContext, true), options.getRetryPolicyFactory(), opContext);
    }

    public TablePayloadFormat getTablePayloadFormat() {
        return this.payloadFormat;
    }

    public void setTablePayloadFormat(TablePayloadFormat payloadFormat) {
        this.payloadFormat = payloadFormat;
    }
}

