/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.table;

import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.ResultContinuation;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.core.BaseRequest;
import com.microsoft.windowsazure.storage.core.PathUtility;
import com.microsoft.windowsazure.storage.core.UriQueryBuilder;
import com.microsoft.windowsazure.storage.core.Utility;
import com.microsoft.windowsazure.storage.table.TablePayloadFormat;
import com.microsoft.windowsazure.storage.table.TableRequestOptions;
import com.microsoft.windowsazure.storage.table.TableUpdateType;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;

final class TableRequest {
    private static void applyContinuationToQueryBuilder(UriQueryBuilder builder, ResultContinuation continuationToken) throws StorageException {
        if (continuationToken != null) {
            if (continuationToken.getNextPartitionKey() != null) {
                builder.add("NextPartitionKey", continuationToken.getNextPartitionKey());
            }
            if (continuationToken.getNextRowKey() != null) {
                builder.add("NextRowKey", continuationToken.getNextRowKey());
            }
            if (continuationToken.getNextTableName() != null) {
                builder.add("NextTableName", continuationToken.getNextTableName());
            }
        }
    }

    public static HttpURLConnection batch(URI rootUri, int timeoutInMs, String batchID, UriQueryBuilder queryBuilder, TableRequestOptions tableOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        URI queryUri = PathUtility.appendPathToSingleUri(rootUri, "$batch");
        HttpURLConnection retConnection = BaseRequest.createURLConnection(queryUri, timeoutInMs, queryBuilder, opContext);
        TableRequest.setAcceptHeaderForHttpWebRequest(retConnection, tableOptions.getTablePayloadFormat());
        retConnection.setRequestProperty("Content-Type", String.format("multipart/mixed; boundary=%s", batchID));
        retConnection.setRequestProperty("MaxDataServiceVersion", "3.0");
        retConnection.setRequestMethod("POST");
        retConnection.setDoOutput(true);
        return retConnection;
    }

    private static HttpURLConnection coreCreate(URI rootUri, String tableName, String eTag, String identity, int timeoutInMs, UriQueryBuilder queryBuilder, String requestMethod, TableRequestOptions tableOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        URI queryUri = null;
        queryUri = !Utility.isNullOrEmpty(identity) ? PathUtility.appendPathToSingleUri(rootUri, tableName.concat(String.format("(%s)", identity))) : PathUtility.appendPathToSingleUri(rootUri, tableName);
        HttpURLConnection retConnection = BaseRequest.createURLConnection(queryUri, timeoutInMs, queryBuilder, opContext);
        TableRequest.setAcceptHeaderForHttpWebRequest(retConnection, tableOptions.getTablePayloadFormat());
        TableRequest.setContentTypeForHttpWebRequest(retConnection, tableOptions.getTablePayloadFormat());
        retConnection.setRequestProperty("MaxDataServiceVersion", "3.0");
        if (!Utility.isNullOrEmpty(eTag)) {
            retConnection.setRequestProperty("If-Match", eTag);
        }
        retConnection.setRequestMethod(requestMethod);
        return retConnection;
    }

    public static HttpURLConnection delete(URI rootUri, String tableName, String identity, String eTag, int timeoutInMs, UriQueryBuilder queryBuilder, TableRequestOptions tableOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        return TableRequest.coreCreate(rootUri, tableName, eTag, identity, timeoutInMs, queryBuilder, "DELETE", tableOptions, opContext);
    }

    public static HttpURLConnection insert(URI rootUri, String tableName, String identity, String eTag, boolean echoContent, TableUpdateType updateType, int timeoutInMs, UriQueryBuilder queryBuilder, TableRequestOptions tableOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        URLConnection retConnection = null;
        if (updateType == null) {
            retConnection = TableRequest.coreCreate(rootUri, tableName, eTag, null, timeoutInMs, queryBuilder, "POST", tableOptions, opContext);
            retConnection.setRequestProperty("Prefer", echoContent ? "return-content" : "return-no-content");
        } else if (updateType == TableUpdateType.MERGE) {
            retConnection = TableRequest.coreCreate(rootUri, tableName, null, identity, timeoutInMs, queryBuilder, "POST", tableOptions, opContext);
            retConnection.setRequestProperty("X-HTTP-Method", "MERGE");
        } else if (updateType == TableUpdateType.REPLACE) {
            retConnection = TableRequest.coreCreate(rootUri, tableName, null, identity, timeoutInMs, queryBuilder, "PUT", tableOptions, opContext);
        }
        retConnection.setDoOutput(true);
        return retConnection;
    }

    public static HttpURLConnection merge(URI rootUri, String tableName, String identity, String eTag, int timeoutInMs, UriQueryBuilder queryBuilder, TableRequestOptions tableOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        HttpURLConnection retConnection = TableRequest.coreCreate(rootUri, tableName, eTag, identity, timeoutInMs, queryBuilder, "POST", tableOptions, opContext);
        retConnection.setRequestProperty("X-HTTP-Method", "MERGE");
        retConnection.setDoOutput(true);
        return retConnection;
    }

    public static HttpURLConnection query(URI rootUri, String tableName, String identity, int timeoutInMs, UriQueryBuilder queryBuilder, ResultContinuation continuationToken, TableRequestOptions tableOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (queryBuilder == null) {
            queryBuilder = new UriQueryBuilder();
        }
        TableRequest.applyContinuationToQueryBuilder(queryBuilder, continuationToken);
        HttpURLConnection retConnection = TableRequest.coreCreate(rootUri, tableName, null, identity, timeoutInMs, queryBuilder, "GET", tableOptions, opContext);
        return retConnection;
    }

    public static HttpURLConnection update(URI rootUri, String tableName, String identity, String eTag, int timeoutInMs, UriQueryBuilder queryBuilder, TableRequestOptions tableOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        HttpURLConnection retConnection = TableRequest.coreCreate(rootUri, tableName, eTag, identity, timeoutInMs, queryBuilder, "PUT", tableOptions, opContext);
        retConnection.setDoOutput(true);
        return retConnection;
    }

    public static HttpURLConnection setAcl(URI rootUri, TableRequestOptions options, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder queryBuilder = new UriQueryBuilder();
        queryBuilder.add("comp", "acl");
        HttpURLConnection retConnection = BaseRequest.createURLConnection(rootUri, options.getTimeoutIntervalInMs(), queryBuilder, opContext);
        retConnection.setRequestMethod("PUT");
        retConnection.setDoOutput(true);
        return retConnection;
    }

    public static HttpURLConnection getAcl(URI rootUri, TableRequestOptions options, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder queryBuilder = new UriQueryBuilder();
        queryBuilder.add("comp", "acl");
        HttpURLConnection retConnection = BaseRequest.createURLConnection(rootUri, options.getTimeoutIntervalInMs(), queryBuilder, opContext);
        retConnection.setRequestMethod("GET");
        return retConnection;
    }

    private static void setAcceptHeaderForHttpWebRequest(HttpURLConnection retConnection, TablePayloadFormat payloadFormat) {
        if (payloadFormat == TablePayloadFormat.AtomPub) {
            retConnection.setRequestProperty("Accept", "application/atom+xml,application/atomsvc+xml,application/xml");
        } else if (payloadFormat == TablePayloadFormat.JsonFullMetadata) {
            retConnection.setRequestProperty("Accept", "application/json;odata=fullmetadata");
        } else if (payloadFormat == TablePayloadFormat.Json) {
            retConnection.setRequestProperty("Accept", "application/json;odata=minimalmetadata");
        } else if (payloadFormat == TablePayloadFormat.JsonNoMetadata) {
            retConnection.setRequestProperty("Accept", "application/json;odata=nometadata");
        }
    }

    private static void setContentTypeForHttpWebRequest(HttpURLConnection retConnection, TablePayloadFormat payloadFormat) {
        if (payloadFormat == TablePayloadFormat.AtomPub) {
            retConnection.setRequestProperty("Content-Type", "application/atom+xml");
        } else {
            retConnection.setRequestProperty("Content-Type", "application/json");
        }
    }

    private TableRequest() {
    }
}

