/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.table;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.microsoft.windowsazure.storage.StorageExtendedErrorInformation;
import com.microsoft.windowsazure.storage.core.DeserializationHelper;
import com.microsoft.windowsazure.storage.table.ODataUtilities;
import com.microsoft.windowsazure.storage.table.TablePayloadFormat;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class TableStorageErrorDeserializer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StorageExtendedErrorInformation getExtendedErrorInformation(Reader reader, TablePayloadFormat format) throws JsonParseException, IOException, XMLStreamException {
        if (format == TablePayloadFormat.AtomPub) {
            XMLStreamReader xmlr = DeserializationHelper.createXMLStreamReaderFromReader(reader);
            try {
                StorageExtendedErrorInformation storageExtendedErrorInformation = TableStorageErrorDeserializer.parseAtomResponse(xmlr);
                return storageExtendedErrorInformation;
            }
            finally {
                xmlr.close();
            }
        }
        JsonFactory jsonFactory = new JsonFactory();
        JsonParser parser = jsonFactory.createParser(reader);
        try {
            StorageExtendedErrorInformation storageExtendedErrorInformation = TableStorageErrorDeserializer.parseJsonResponse(parser);
            return storageExtendedErrorInformation;
        }
        finally {
            parser.close();
        }
    }

    private static HashMap<String, String[]> parseJsonErrorException(JsonParser parser) throws JsonParseException, IOException {
        HashMap<String, String[]> additionalDetails = new HashMap<String, String[]>();
        parser.nextToken();
        ODataUtilities.assertIsStartObjectJsonToken(parser);
        parser.nextToken();
        ODataUtilities.assertIsFieldNameJsonToken(parser);
        while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            if (parser.getCurrentName().equals("message")) {
                parser.nextToken();
                additionalDetails.put("message", new String[]{parser.getValueAsString()});
            } else if (parser.getCurrentName().equals("type")) {
                parser.nextToken();
                additionalDetails.put("type", new String[]{parser.getValueAsString()});
            } else if (parser.getCurrentName().equals("stacktrace")) {
                parser.nextToken();
                additionalDetails.put("StackTrace", new String[]{parser.getValueAsString()});
            }
            parser.nextToken();
        }
        return additionalDetails;
    }

    private static StorageExtendedErrorInformation parseJsonResponse(JsonParser parser) throws JsonParseException, IOException {
        StorageExtendedErrorInformation errorInfo = new StorageExtendedErrorInformation();
        if (!parser.hasCurrentToken()) {
            parser.nextToken();
        }
        ODataUtilities.assertIsStartObjectJsonToken(parser);
        parser.nextToken();
        ODataUtilities.assertIsFieldNameJsonToken(parser);
        ODataUtilities.assertIsExpectedFieldName(parser, "odata.error");
        parser.nextToken();
        ODataUtilities.assertIsStartObjectJsonToken(parser);
        parser.nextValue();
        ODataUtilities.assertIsExpectedFieldName(parser, "code");
        errorInfo.setErrorCode(parser.getValueAsString());
        parser.nextToken();
        ODataUtilities.assertIsFieldNameJsonToken(parser);
        ODataUtilities.assertIsExpectedFieldName(parser, "message");
        parser.nextToken();
        ODataUtilities.assertIsStartObjectJsonToken(parser);
        parser.nextValue();
        ODataUtilities.assertIsExpectedFieldName(parser, "lang");
        parser.nextValue();
        ODataUtilities.assertIsExpectedFieldName(parser, "value");
        errorInfo.setErrorMessage(parser.getValueAsString());
        parser.nextToken();
        ODataUtilities.assertIsEndObjectJsonToken(parser);
        parser.nextToken();
        if (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
            ODataUtilities.assertIsExpectedFieldName(parser, "innererror");
            errorInfo.getAdditionalDetails().putAll(TableStorageErrorDeserializer.parseJsonErrorException(parser));
            parser.nextToken();
        }
        ODataUtilities.assertIsEndObjectJsonToken(parser);
        parser.nextToken();
        ODataUtilities.assertIsEndObjectJsonToken(parser);
        return errorInfo;
    }

    private static HashMap<String, String[]> parseAtomErrorException(XMLStreamReader xmlr) throws XMLStreamException {
        int eventType = xmlr.getEventType();
        xmlr.require(1, null, "innererror");
        HashMap<String, String[]> additionalDetails = new HashMap<String, String[]>();
        while (xmlr.hasNext()) {
            String errorExceptionStack;
            eventType = xmlr.next();
            if (eventType == 4) continue;
            String name = xmlr.getName().getLocalPart().toString();
            if (eventType == 1 && name.equals("message")) {
                String errorExceptionMessage = DeserializationHelper.readElementFromXMLReader(xmlr, name);
                additionalDetails.put("ExceptionMessage", new String[]{errorExceptionMessage});
                continue;
            }
            if (eventType == 1 && name.equals("stacktrace")) {
                errorExceptionStack = DeserializationHelper.readElementFromXMLReader(xmlr, name);
                additionalDetails.put("StackTrace", new String[]{errorExceptionStack});
                continue;
            }
            if (eventType == 1 && name.equals("type")) {
                errorExceptionStack = DeserializationHelper.readElementFromXMLReader(xmlr, name);
                additionalDetails.put("type", new String[]{errorExceptionStack});
                continue;
            }
            if (eventType != 2) continue;
            break;
        }
        xmlr.require(2, null, null);
        return additionalDetails;
    }

    private static StorageExtendedErrorInformation parseAtomResponse(XMLStreamReader xmlr) throws XMLStreamException {
        StorageExtendedErrorInformation errorInfo = new StorageExtendedErrorInformation();
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        eventType = xmlr.next();
        xmlr.require(1, null, null);
        if (!xmlr.getName().getLocalPart().toString().equals("error")) {
            throw new XMLStreamException("Expected START_ELEMENT to equal error.");
        }
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 4) continue;
            if (eventType == 2) break;
            String name = xmlr.getName().getLocalPart().toString();
            if (eventType != 1) continue;
            if (name.equals("code")) {
                errorInfo.setErrorCode(DeserializationHelper.readElementFromXMLReader(xmlr, name));
                continue;
            }
            if (name.equals("message")) {
                errorInfo.setErrorMessage(DeserializationHelper.readElementFromXMLReader(xmlr, name));
                continue;
            }
            if (name.equals("innererror")) {
                errorInfo.getAdditionalDetails().putAll(TableStorageErrorDeserializer.parseAtomErrorException(xmlr));
                continue;
            }
            String tempParseString = DeserializationHelper.readElementFromXMLReader(xmlr, name);
            errorInfo.getAdditionalDetails().put(name, new String[]{tempParseString});
            xmlr.require(2, null, null);
        }
        return errorInfo;
    }
}

