/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.table;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.microsoft.windowsazure.storage.StorageExtendedErrorInformation;
import com.microsoft.windowsazure.storage.core.Utility;
import com.microsoft.windowsazure.storage.table.ODataUtilities;
import com.microsoft.windowsazure.storage.table.TablePayloadFormat;
import java.io.IOException;
import java.io.Reader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class TableStorageErrorResponse {
    private final StorageExtendedErrorInformation errorInfo = new StorageExtendedErrorInformation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableStorageErrorResponse(Reader reader, TablePayloadFormat format) throws XMLStreamException, JsonParseException, IOException {
        if (format == TablePayloadFormat.AtomPub) {
            XMLStreamReader xmlr = Utility.createXMLStreamReaderFromReader((Reader)reader);
            try {
                this.parseAtomResponse(xmlr);
            }
            finally {
                xmlr.close();
            }
        }
        JsonFactory jsonFactory = new JsonFactory();
        JsonParser parser = jsonFactory.createParser(reader);
        try {
            this.parseJsonResponse(parser);
        }
        finally {
            parser.close();
        }
    }

    public StorageExtendedErrorInformation getExtendedErrorInformation() {
        return this.errorInfo;
    }

    private void parseJsonErrorException(JsonParser parser) throws JsonParseException, IOException {
        parser.nextToken();
        ODataUtilities.assertIsStartObjectJsonToken(parser);
        parser.nextToken();
        ODataUtilities.assertIsFieldNameJsonToken(parser);
        while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            if (parser.getCurrentName().equals("message")) {
                parser.nextToken();
                this.errorInfo.getAdditionalDetails().put("message", new String[]{parser.getValueAsString()});
            } else if (parser.getCurrentName().equals("type")) {
                parser.nextToken();
                this.errorInfo.getAdditionalDetails().put("type", new String[]{parser.getValueAsString()});
            } else if (parser.getCurrentName().equals("stacktrace")) {
                parser.nextToken();
                this.errorInfo.getAdditionalDetails().put("StackTrace", new String[]{parser.getValueAsString()});
            }
            parser.nextToken();
        }
    }

    private void parseJsonResponse(JsonParser parser) throws JsonParseException, IOException {
        if (!parser.hasCurrentToken()) {
            parser.nextToken();
        }
        ODataUtilities.assertIsStartObjectJsonToken(parser);
        parser.nextToken();
        ODataUtilities.assertIsFieldNameJsonToken(parser);
        ODataUtilities.assertIsExpectedFieldName(parser, "odata.error");
        parser.nextToken();
        ODataUtilities.assertIsStartObjectJsonToken(parser);
        parser.nextValue();
        ODataUtilities.assertIsExpectedFieldName(parser, "code");
        this.errorInfo.setErrorCode(parser.getValueAsString());
        parser.nextToken();
        ODataUtilities.assertIsFieldNameJsonToken(parser);
        ODataUtilities.assertIsExpectedFieldName(parser, "message");
        parser.nextToken();
        ODataUtilities.assertIsStartObjectJsonToken(parser);
        parser.nextValue();
        ODataUtilities.assertIsExpectedFieldName(parser, "lang");
        parser.nextValue();
        ODataUtilities.assertIsExpectedFieldName(parser, "value");
        this.errorInfo.setErrorMessage(parser.getValueAsString());
        parser.nextToken();
        ODataUtilities.assertIsEndObjectJsonToken(parser);
        parser.nextToken();
        if (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
            ODataUtilities.assertIsExpectedFieldName(parser, "innererror");
            this.parseJsonErrorException(parser);
            parser.nextToken();
        }
        ODataUtilities.assertIsEndObjectJsonToken(parser);
        parser.nextToken();
        ODataUtilities.assertIsEndObjectJsonToken(parser);
    }

    private void parseAtomErrorException(XMLStreamReader xmlr) throws XMLStreamException {
        int eventType = xmlr.getEventType();
        xmlr.require(1, null, "innererror");
        while (xmlr.hasNext()) {
            String errorExceptionStack;
            eventType = xmlr.next();
            if (eventType == 4) continue;
            String name = xmlr.getName().getLocalPart().toString();
            if (eventType == 1 && name.equals("message")) {
                String errorExceptionMessage = Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)name);
                this.errorInfo.getAdditionalDetails().put("ExceptionMessage", new String[]{errorExceptionMessage});
                continue;
            }
            if (eventType == 1 && name.equals("stacktrace")) {
                errorExceptionStack = Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)name);
                this.errorInfo.getAdditionalDetails().put("StackTrace", new String[]{errorExceptionStack});
                continue;
            }
            if (eventType == 1 && name.equals("type")) {
                errorExceptionStack = Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)name);
                this.errorInfo.getAdditionalDetails().put("type", new String[]{errorExceptionStack});
                continue;
            }
            if (eventType != 2) continue;
            break;
        }
        xmlr.require(2, null, null);
    }

    private void parseAtomResponse(XMLStreamReader xmlr) throws XMLStreamException {
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        eventType = xmlr.next();
        xmlr.require(1, null, null);
        if (!xmlr.getName().getLocalPart().toString().equals("error")) {
            throw new XMLStreamException("Expected START_ELEMENT to equal error.");
        }
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 4) continue;
            if (eventType == 2) break;
            String name = xmlr.getName().getLocalPart().toString();
            if (eventType != 1) continue;
            if (name.equals("code")) {
                this.errorInfo.setErrorCode(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)name));
                continue;
            }
            if (name.equals("message")) {
                this.errorInfo.setErrorMessage(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)name));
                continue;
            }
            if (name.equals("innererror")) {
                this.parseAtomErrorException(xmlr);
                continue;
            }
            String tempParseString = Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)name);
            this.errorInfo.getAdditionalDetails().put(name, new String[]{tempParseString});
            xmlr.require(2, null, null);
        }
    }
}

