/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.bridge;

import com.google.common.util.concurrent.SettableFuture;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.Locale;
import java.util.concurrent.Future;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.pentaho.capabilities.api.ICapability;
import org.pentaho.osgi.bridge.KarafCapabilityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafCapability
implements ICapability,
Comparable<ICapability> {
    private FeaturesService featuresService;
    private Feature feature;
    private KarafCapabilityProvider manager;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public KarafCapability(FeaturesService featuresService, Feature feature, KarafCapabilityProvider manager) {
        this.featuresService = featuresService;
        this.feature = feature;
        this.manager = manager;
    }

    public String getId() {
        return this.feature.getName();
    }

    public String getDescription(Locale locale) {
        return this.feature.getDescription();
    }

    public boolean isInstalled() {
        return this.featuresService.isInstalled(this.feature);
    }

    public Future<Boolean> install() {
        SettableFuture installFuture = SettableFuture.create();
        try {
            this.manager.watchForInstall(this.feature, (SettableFuture<Boolean>)installFuture);
            this.featuresService.installFeature(this.feature, EnumSet.noneOf(FeaturesService.Option.class));
        }
        catch (Exception e) {
            this.logger.error("Unknown error installing feature", (Throwable)e);
            installFuture.set((Object)false);
            installFuture.setException((Throwable)e);
        }
        return installFuture;
    }

    public Future<Boolean> uninstall() {
        SettableFuture uninstallFuture = SettableFuture.create();
        try {
            this.manager.watchForUnInstall(this.feature, (SettableFuture<Boolean>)uninstallFuture);
            this.featuresService.uninstallFeature(this.feature.getName());
        }
        catch (Exception e) {
            this.logger.error("Unknown error uninstalling feature", (Throwable)e);
            uninstallFuture.set((Object)false);
            uninstallFuture.setException((Throwable)e);
        }
        return uninstallFuture;
    }

    public URI getSourceUri() {
        try {
            return new URI("karaf", this.feature.getDetails(), null);
        }
        catch (URISyntaxException e) {
            this.logger.error("Error creating URI", (Throwable)e);
            return null;
        }
    }

    @Override
    public int compareTo(ICapability o) {
        return this.getId().compareTo(o.getId());
    }
}

