/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.modules.openide.util.AWTBridge;
import org.netbeans.modules.openide.util.ActionsBridge;
import org.openide.ErrorManager;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public abstract class CallbackSystemAction
extends CallableSystemAction
implements ContextAwareAction {
    private static final String PROP_ACTION_PERFORMER = "actionPerformer";
    private static final WeakSet notSurviving = new WeakSet(37);
    private static final WeakSet surviving = new WeakSet(37);
    private static final Object LISTENER = new Object();
    static final long serialVersionUID = -6305817805474624653L;
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.openide.util.actions.CallbackSystemAction");
    private static final boolean errLog = err.isLoggable(1);
    static /* synthetic */ Class class$javax$swing$ActionMap;
    static /* synthetic */ Class class$org$openide$util$LookupListener;
    static /* synthetic */ Class class$org$openide$util$actions$CallableSystemAction;

    protected void initialize() {
        super.initialize();
        this.updateEnabled();
        this.setSurviveFocusChange(false);
    }

    public ActionPerformer getActionPerformer() {
        return (ActionPerformer)this.getProperty(PROP_ACTION_PERFORMER);
    }

    public void setActionPerformer(ActionPerformer actionPerformer) {
        this.putProperty(PROP_ACTION_PERFORMER, actionPerformer);
        this.updateEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEnabled() {
        Action action = GlobalManager.getDefault().findGlobalAction(this.getActionMapKey(), this.getSurviveFocusChange());
        if (action != null) {
            this.setEnabled(action.isEnabled());
            Object object = LISTENER;
            synchronized (object) {
                ActionDelegateListener actionDelegateListener = (ActionDelegateListener)this.getProperty(LISTENER);
                if (actionDelegateListener == null || actionDelegateListener.get() != this) {
                    actionDelegateListener = new ActionDelegateListener(this, action);
                    this.putProperty(LISTENER, actionDelegateListener);
                } else {
                    actionDelegateListener.attach(action);
                }
            }
        } else {
            if (this.getActionPerformer() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            this.clearListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearListener() {
        Object object = LISTENER;
        synchronized (object) {
            ActionDelegateListener actionDelegateListener = (ActionDelegateListener)this.getProperty(LISTENER);
            if (actionDelegateListener != null) {
                actionDelegateListener.clear();
                this.putProperty(LISTENER, null);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Action action = GlobalManager.getDefault().findGlobalAction(this.getActionMapKey(), this.getSurviveFocusChange());
        if (action != null) {
            if (action.isEnabled()) {
                action.actionPerformed(actionEvent);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
            return;
        }
        final ActionPerformer actionPerformer = this.getActionPerformer();
        if (actionPerformer != null) {
            ActionsBridge.doPerformAction(this, new ActionsBridge.ActionRunnable(actionEvent, this, this.asynchronous()){

                public void run() {
                    actionPerformer.performAction(CallbackSystemAction.this);
                }
            });
            return;
        }
        Toolkit.getDefaultToolkit().beep();
    }

    public void performAction() {
        ActionPerformer actionPerformer = this.getActionPerformer();
        if (actionPerformer != null) {
            actionPerformer.performAction(this);
        }
    }

    public Object getActionMapKey() {
        return this.getClass().getName();
    }

    public boolean getSurviveFocusChange() {
        this.getProperty(null);
        return !notSurviving.contains(this.getClass());
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new DelegateAction(this, lookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSurviveFocusChange(boolean bl) {
        WeakSet weakSet = notSurviving;
        synchronized (weakSet) {
            if (bl) {
                notSurviving.remove(this.getClass());
                surviving.add(this.getClass());
            } else {
                notSurviving.add(this.getClass());
                surviving.remove(this.getClass());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList toInstances(Set set) {
        ArrayList<SharedClassObject> arrayList;
        WeakSet weakSet = notSurviving;
        synchronized (weakSet) {
            arrayList = new ArrayList<SharedClassObject>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Class clazz = (Class)iterator.next();
                SharedClassObject sharedClassObject = SystemAction.findObject(clazz, false);
                if (sharedClassObject == null) continue;
                arrayList.add(sharedClassObject);
            }
        }
        return arrayList;
    }

    private static void clearActionPerformers() {
        CallbackSystemAction callbackSystemAction;
        ArrayList arrayList = CallbackSystemAction.toInstances(notSurviving);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            callbackSystemAction = (CallbackSystemAction)iterator.next();
            callbackSystemAction.setActionPerformer(null);
        }
        arrayList = CallbackSystemAction.toInstances(surviving);
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            callbackSystemAction = (CallbackSystemAction)iterator.next();
            if (errLog) {
                err.log("updateEnabled: " + callbackSystemAction);
            }
            callbackSystemAction.updateEnabled();
        }
    }

    private static final class DelegateAction
    implements Action,
    LookupListener,
    Presenter.Menu,
    Presenter.Popup,
    Presenter.Toolbar,
    PropertyChangeListener {
        private CallbackSystemAction delegate;
        private Lookup.Result result;
        private boolean enabled;
        private PropertyChangeSupport support = new PropertyChangeSupport(this);
        private PropertyChangeListener weakL;
        private WeakReference lastRef;

        public DelegateAction(CallbackSystemAction callbackSystemAction, Lookup lookup) {
            this.delegate = callbackSystemAction;
            this.weakL = WeakListeners.propertyChange(this, null);
            this.enabled = callbackSystemAction.getActionPerformer() != null;
            this.result = lookup.lookup(new Lookup.Template(class$javax$swing$ActionMap == null ? (class$javax$swing$ActionMap = CallbackSystemAction.class$("javax.swing.ActionMap")) : class$javax$swing$ActionMap));
            this.result.addLookupListener((LookupListener)WeakListeners.create(class$org$openide$util$LookupListener == null ? (class$org$openide$util$LookupListener = CallbackSystemAction.class$("org.openide.util.LookupListener")) : class$org$openide$util$LookupListener, this, this.result));
            this.resultChanged(null);
        }

        public String toString() {
            return super.toString() + "[delegate=" + this.delegate + "]";
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Action action = this.findAction();
            if (action != null) {
                ActionsBridge.ActionRunnable actionRunnable = new ActionsBridge.ActionRunnable(this, actionEvent, this.delegate, this.delegate.asynchronous(), action, actionEvent){
                    private final /* synthetic */ Action val$a;
                    private final /* synthetic */ ActionEvent val$e;
                    private final /* synthetic */ DelegateAction this$0;
                    {
                        this.this$0 = delegateAction;
                        this.val$a = action;
                        this.val$e = actionEvent2;
                        super(actionEvent, systemAction, bl);
                    }

                    public void run() {
                        this.val$a.actionPerformed(this.val$e);
                    }
                };
                ActionsBridge.doPerformAction(this.delegate, actionRunnable);
            } else {
                Object object;
                Object object2 = actionEvent.getSource();
                if (object2 instanceof Component && SwingUtilities.getWindowAncestor((Component)object2) instanceof Dialog && !Boolean.TRUE.equals(object = this.delegate.getValue("OpenIDE-Transmodal-Action"))) {
                    return;
                }
                this.delegate.actionPerformed(actionEvent);
            }
        }

        public boolean isEnabled() {
            Action action;
            Action action2 = this.findAction();
            if (action2 == null) {
                action2 = this.delegate;
            }
            Action action3 = action = this.lastRef == null ? null : (Action)this.lastRef.get();
            if (action2 != action) {
                if (action != null) {
                    action.removePropertyChangeListener(this.weakL);
                }
                this.lastRef = new WeakReference<Action>(action2);
                action2.addPropertyChangeListener(this.weakL);
            }
            return action2.isEnabled();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.removePropertyChangeListener(propertyChangeListener);
        }

        public void putValue(String string, Object object) {
        }

        public Object getValue(String string) {
            return this.delegate.getValue(string);
        }

        public void setEnabled(boolean bl) {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            boolean bl = this.isEnabled();
            if (bl != this.enabled) {
                this.support.firePropertyChange("enabled", this.enabled, bl);
                this.enabled = bl;
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.resultChanged(null);
        }

        private Action findAction() {
            List list;
            Collection collection = list = this.result != null ? this.result.allInstances() : Collections.EMPTY_LIST;
            if (!list.isEmpty()) {
                Object object = this.delegate.getActionMapKey();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ActionMap actionMap = (ActionMap)iterator.next();
                    Action action = actionMap.get(object);
                    if (action == null) continue;
                    return action;
                }
            }
            return null;
        }

        public JMenuItem getMenuPresenter() {
            if (this.isMethodOverriden(this.delegate, "getMenuPresenter")) {
                return this.delegate.getMenuPresenter();
            }
            return AWTBridge.getDefault().createMenuPresenter(this);
        }

        public JMenuItem getPopupPresenter() {
            if (this.isMethodOverriden(this.delegate, "getPopupPresenter")) {
                return this.delegate.getPopupPresenter();
            }
            return AWTBridge.getDefault().createPopupPresenter(this);
        }

        public Component getToolbarPresenter() {
            if (this.isMethodOverriden(this.delegate, "getToolbarPresenter")) {
                return this.delegate.getToolbarPresenter();
            }
            return AWTBridge.getDefault().createToolbarPresenter(this);
        }

        private boolean isMethodOverriden(CallableSystemAction callableSystemAction, String string) {
            try {
                Method method = callableSystemAction.getClass().getMethod(string, new Class[0]);
                return method.getDeclaringClass() != (class$org$openide$util$actions$CallableSystemAction == null ? (class$org$openide$util$actions$CallableSystemAction = CallbackSystemAction.class$("org.openide.util.actions.CallableSystemAction")) : class$org$openide$util$actions$CallableSystemAction);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
                throw new IllegalStateException("Error searching for method " + string + " in " + callableSystemAction);
            }
        }

        protected void finalize() {
            Action action;
            Action action2 = action = this.lastRef == null ? null : (Action)this.lastRef.get();
            if (action != null) {
                action.removePropertyChangeListener(this.weakL);
            }
        }
    }

    private static final class ActionDelegateListener
    extends WeakReference
    implements PropertyChangeListener {
        private WeakReference delegate;

        public ActionDelegateListener(CallbackSystemAction callbackSystemAction, Action action) {
            super(callbackSystemAction);
            this.delegate = new WeakReference<Action>(action);
            action.addPropertyChangeListener(this);
        }

        public void clear() {
            Action action;
            WeakReference weakReference = this.delegate;
            Action action2 = action = weakReference == null ? null : (Action)weakReference.get();
            if (action == null) {
                return;
            }
            this.delegate = null;
            action.removePropertyChangeListener(this);
        }

        public void attach(Action action) {
            WeakReference weakReference = this.delegate;
            if (weakReference != null && weakReference.get() == action) {
                return;
            }
            Action action2 = (Action)weakReference.get();
            if (action2 != null) {
                action2.removePropertyChangeListener(this);
            }
            this.delegate = new WeakReference<Action>(action);
            action.addPropertyChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = LISTENER;
            synchronized (object) {
                WeakReference weakReference = this.delegate;
                if (weakReference == null || weakReference.get() == null) {
                    return;
                }
            }
            object = (CallbackSystemAction)this.get();
            if (object != null) {
                ((CallbackSystemAction)object).updateEnabled();
            }
        }
    }

    private static final class WeakAction
    extends WeakReference
    implements Action {
        public WeakAction(Action action) {
            super(action);
        }

        public Action getDelegate() {
            return (Action)super.get();
        }

        public Object getValue(String string) {
            throw new UnsupportedOperationException();
        }

        public void putValue(String string, Object object) {
            throw new UnsupportedOperationException();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            throw new UnsupportedOperationException();
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            throw new UnsupportedOperationException();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            throw new UnsupportedOperationException();
        }

        public void setEnabled(boolean bl) {
            throw new UnsupportedOperationException();
        }

        public boolean isEnabled() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class GlobalManager
    implements LookupListener {
        private static GlobalManager instance;
        private Lookup.Result result;
        private Reference actionMap = new WeakReference<Object>(null);
        private final ActionMap survive = new ActionMap();

        private GlobalManager() {
            this.result = Utilities.actionsGlobalContext().lookup(new Lookup.Template(class$javax$swing$ActionMap == null ? (class$javax$swing$ActionMap = CallbackSystemAction.class$("javax.swing.ActionMap")) : class$javax$swing$ActionMap));
            this.result.addLookupListener(this);
            this.resultChanged(null);
        }

        public static synchronized GlobalManager getDefault() {
            if (instance != null) {
                return instance;
            }
            instance = new GlobalManager();
            return instance;
        }

        public Action findGlobalAction(Object object, boolean bl) {
            Action action;
            ActionMap actionMap = (ActionMap)this.actionMap.get();
            Action action2 = action = actionMap == null ? null : actionMap.get(object);
            if (bl) {
                if (action == null) {
                    action = this.survive.get(object);
                    if (action != null) {
                        action = ((WeakAction)action).getDelegate();
                    }
                    if (errLog) {
                        err.log("No action for key: " + object + " using delegate: " + action);
                    }
                } else {
                    if (errLog) {
                        err.log("New action for key: " + object + " put: " + action);
                    }
                    this.survive.put(object, new WeakAction(action));
                }
            }
            if (errLog) {
                err.log("Action for key: " + object + " is: " + action);
            }
            return action;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            ActionMap actionMap = (ActionMap)Utilities.actionsGlobalContext().lookup(class$javax$swing$ActionMap == null ? (class$javax$swing$ActionMap = CallbackSystemAction.class$("javax.swing.ActionMap")) : class$javax$swing$ActionMap);
            if (errLog) {
                err.log("changed map : " + actionMap);
                err.log("previous map: " + this.actionMap.get());
            }
            if (actionMap == this.actionMap.get()) {
                return;
            }
            this.actionMap = new WeakReference<ActionMap>(actionMap);
            if (errLog) {
                err.log("clearActionPerformers");
            }
            CallbackSystemAction.clearActionPerformers();
        }
    }
}

