/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.openerp;

import com.debortoliwines.openerp.reporting.di.OpenERPConfiguration;
import com.debortoliwines.openerp.reporting.di.OpenERPFieldInfo;
import com.debortoliwines.openerp.reporting.ui.OpenERPPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataFactoryEditorSupport;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.engine.classic.extensions.datasources.openerp.OpenERPDataFactory;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.background.CancelEvent;
import org.pentaho.reporting.libraries.designtime.swing.background.DataPreviewDialog;
import org.pentaho.reporting.libraries.designtime.swing.background.PreviewWorker;

public class OpenERPDataSourceEditor
extends CommonDialog {
    private static final long serialVersionUID = 6685784298385723490L;
    private DesignTimeContext context;
    private OpenERPPanel mainPanel;
    private JTextField txtQueryName;

    public OpenERPDataSourceEditor(DesignTimeContext context) {
        this.init(context);
    }

    public OpenERPDataSourceEditor(DesignTimeContext context, Frame owner) throws HeadlessException {
        super(owner);
        this.init(context);
    }

    public OpenERPDataSourceEditor(DesignTimeContext context, Dialog owner) throws HeadlessException {
        super(owner);
        this.init(context);
    }

    private void init(DesignTimeContext context) {
        this.context = context;
        super.init();
    }

    protected String getDialogId() {
        return "OpenERPDataSourceEditor";
    }

    protected Component createContentPane() {
        this.mainPanel = new OpenERPPanel();
        URL location = OpenERPDataSourceEditor.class.getResource("/org/pentaho/reporting/ui/datasources/openerp/resources/Add.png");
        if (location != null) {
            this.mainPanel.setFilterAddButtonIcon((Icon)new ImageIcon(location));
        }
        if ((location = OpenERPDataSourceEditor.class.getResource("/org/pentaho/reporting/ui/datasources/openerp/resources/Remove.png")) != null) {
            this.mainPanel.setFilterRemoveButtonIcon((Icon)new ImageIcon(location));
        }
        this.txtQueryName = new JTextField(20);
        this.txtQueryName.setText("Query1");
        JPanel queryPanel = new JPanel(new FlowLayout(0));
        queryPanel.add(new JLabel("Query Name:"));
        queryPanel.add(this.txtQueryName);
        JPanel cpanel = new JPanel();
        cpanel.setLayout(new BorderLayout());
        cpanel.add((Component)queryPanel, "North");
        cpanel.add((Component)this.mainPanel, "Center");
        cpanel.add((Component)new JButton(new PreviewAction()), "South");
        return cpanel;
    }

    protected boolean validateInputs(boolean onConfirm) {
        if (this.txtQueryName.getText().length() == 0) {
            ExceptionDialog.showExceptionDialog((Component)((Object)this), (String)"Error", (String)"Query Name is mandatory", null);
            return false;
        }
        ArrayList selectedFields = this.mainPanel.getConfiguration().getSelectedFields();
        if (selectedFields != null) {
            ArrayList<String> fieldNames = new ArrayList<String>();
            for (OpenERPFieldInfo fld : selectedFields) {
                if (fieldNames.indexOf(fld.getRenamedFieldName()) >= 0) {
                    ExceptionDialog.showExceptionDialog((Component)((Object)this), (String)"Error", (String)("Selected field name '" + fld.getRenamedFieldName() + "' is not unique."), null);
                    return false;
                }
                fieldNames.add(fld.getRenamedFieldName());
            }
        }
        return true;
    }

    public DataFactory performConfiguration(OpenERPDataFactory input) {
        if (input != null) {
            this.txtQueryName.setText(input.getQueryName());
            this.mainPanel.setConfiguration(input.getConfig());
        }
        if (!this.performEdit()) {
            return null;
        }
        return this.produceDataFactory();
    }

    private OpenERPDataFactory produceDataFactory() {
        OpenERPDataFactory dataFactory = new OpenERPDataFactory();
        OpenERPConfiguration config = this.mainPanel.getConfiguration();
        dataFactory.setQueryName(this.txtQueryName.getText());
        dataFactory.setConfig(config);
        return dataFactory;
    }

    private static class OpenERPPreviewWorker
    implements PreviewWorker {
        private OpenERPDataFactory dataFactory;
        private TableModel resultTableModel;
        private ReportDataFactoryException exception;
        private String query;

        private OpenERPPreviewWorker(OpenERPDataFactory dataFactory, String query) {
            if (dataFactory == null) {
                throw new NullPointerException();
            }
            this.query = query;
            this.dataFactory = dataFactory;
        }

        public ReportDataFactoryException getException() {
            return this.exception;
        }

        public TableModel getResultTableModel() {
            return this.resultTableModel;
        }

        public void close() {
        }

        public void cancelProcessing(CancelEvent event) {
            this.dataFactory.cancelRunningQuery();
        }

        public void run() {
            try {
                this.resultTableModel = this.dataFactory.queryData(this.query, (DataRow)new ReportParameterValues());
                this.dataFactory.close();
            }
            catch (ReportDataFactoryException e) {
                this.exception = e;
            }
        }
    }

    private class PreviewAction
    extends AbstractAction {
        private static final long serialVersionUID = 4093248389910254252L;

        private PreviewAction() {
            this.putValue("Name", "Preview");
        }

        @Override
        public void actionPerformed(ActionEvent aEvt) {
            try {
                OpenERPDataFactory dataFactory = OpenERPDataSourceEditor.this.produceDataFactory();
                DataFactoryEditorSupport.configureDataFactoryForPreview((DataFactory)dataFactory, (DesignTimeContext)OpenERPDataSourceEditor.this.context);
                DataPreviewDialog previewDialog = new DataPreviewDialog((Dialog)((Object)OpenERPDataSourceEditor.this));
                OpenERPPreviewWorker worker = new OpenERPPreviewWorker(dataFactory, OpenERPDataSourceEditor.this.txtQueryName.getText());
                previewDialog.showData((PreviewWorker)worker);
                ReportDataFactoryException factoryException = worker.getException();
                if (factoryException != null) {
                    ExceptionDialog.showExceptionDialog((Component)((Object)OpenERPDataSourceEditor.this), (String)"Error", (String)"An Error Occured during preview", (Exception)((Object)factoryException));
                }
            }
            catch (Exception e) {
                ExceptionDialog.showExceptionDialog((Component)((Object)OpenERPDataSourceEditor.this), (String)"Error", (String)"An Error Occured during preview", (Exception)e);
            }
        }
    }
}

