/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.http;

import com.cloudera.com.amazonaws.AmazonServiceException;
import com.cloudera.com.amazonaws.http.HttpResponse;
import com.cloudera.com.amazonaws.http.HttpResponseHandler;
import com.cloudera.com.amazonaws.internal.http.JsonErrorCodeParser;
import com.cloudera.com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.cloudera.com.amazonaws.util.IOUtils;
import com.cloudera.com.fasterxml.jackson.core.JsonParser;
import com.cloudera.com.fasterxml.jackson.databind.JsonNode;
import com.cloudera.com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonErrorResponseHandlerV2
implements HttpResponseHandler<AmazonServiceException> {
    private static final Log LOG = LogFactory.getLog(JsonErrorResponseHandlerV2.class);
    private final List<JsonErrorUnmarshallerV2> unmarshallers;
    private final JsonErrorCodeParser errorCodeParser;

    public JsonErrorResponseHandlerV2(List<JsonErrorUnmarshallerV2> errorUnmarshallers) {
        this(errorUnmarshallers, JsonErrorCodeParser.DEFAULT_ERROR_CODE_PARSER);
    }

    public JsonErrorResponseHandlerV2(List<JsonErrorUnmarshallerV2> errorUnmarshallers, JsonErrorCodeParser errorCodeParser) {
        this.unmarshallers = errorUnmarshallers;
        this.errorCodeParser = errorCodeParser;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    @Override
    public AmazonServiceException handle(HttpResponse response) throws Exception {
        JsonContent jsonContent = JsonContent.createJsonContent(response);
        String errorCode = this.errorCodeParser.parseErrorCode(response.getHeaders(), jsonContent.jsonNode);
        AmazonServiceException ase = this.createException(errorCode, jsonContent);
        ase.setErrorCode(errorCode);
        ase.setServiceName(response.getRequest().getServiceName());
        ase.setStatusCode(response.getStatusCode());
        ase.setErrorType(this.getErrorTypeFromStatusCode(response.getStatusCode()));
        ase.setRawResponseContent(jsonContent.rawJsonContent);
        String requestId = this.getRequestIdFromHeaders(response.getHeaders());
        if (requestId != null) {
            ase.setRequestId(requestId);
        }
        return ase;
    }

    private AmazonServiceException createException(String errorCode, JsonContent jsonContent) {
        if (!jsonContent.isJsonValid()) {
            return new AmazonServiceException("Unable to parse HTTP response content");
        }
        AmazonServiceException ase = this.unmarshallException(errorCode, jsonContent);
        if (ase == null) {
            ase = new AmazonServiceException("Unable to unmarshall exception response with the unmarshallers provided");
        }
        return ase;
    }

    private AmazonServiceException unmarshallException(String errorCode, JsonContent jsonContent) {
        for (JsonErrorUnmarshallerV2 unmarshaller : this.unmarshallers) {
            if (!unmarshaller.matchErrorCode(errorCode)) continue;
            try {
                return unmarshaller.unmarshall(jsonContent.jsonNode);
            }
            catch (Exception e) {
                LOG.error((Object)"Unable to unmarshall exception content", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private AmazonServiceException.ErrorType getErrorTypeFromStatusCode(int statusCode) {
        return statusCode < 500 ? AmazonServiceException.ErrorType.Client : AmazonServiceException.ErrorType.Service;
    }

    private String getRequestIdFromHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
            if (!headerEntry.getKey().equalsIgnoreCase("x-amzn-RequestId")) continue;
            return headerEntry.getValue();
        }
        return null;
    }

    private static class JsonContent {
        private static final ObjectMapper MAPPER = new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        public final String rawJsonContent;
        public final JsonNode jsonNode;

        public static JsonContent createJsonContent(HttpResponse httpResponse) {
            String rawJsonContent = null;
            try {
                rawJsonContent = IOUtils.toString(httpResponse.getContent());
            }
            catch (Exception e) {
                LOG.error((Object)"Unable to read HTTP response content", (Throwable)e);
            }
            return new JsonContent(rawJsonContent);
        }

        private JsonContent(String rawJsonContent) {
            this.rawJsonContent = rawJsonContent;
            this.jsonNode = this.parseJsonContent();
        }

        private JsonNode parseJsonContent() {
            try {
                return MAPPER.readTree(this.rawJsonContent);
            }
            catch (Exception e) {
                LOG.error((Object)"Unable to parse HTTP response content", (Throwable)e);
                return null;
            }
        }

        public boolean isJsonValid() {
            return this.jsonNode != null;
        }
    }
}

