/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.http.protocol;

import com.cloudera.com.amazonaws.util.AWSRequestMetrics;
import com.cloudera.org.apache.http.HttpClientConnection;
import com.cloudera.org.apache.http.HttpException;
import com.cloudera.org.apache.http.HttpRequest;
import com.cloudera.org.apache.http.HttpResponse;
import com.cloudera.org.apache.http.protocol.HttpContext;
import com.cloudera.org.apache.http.protocol.HttpRequestExecutor;
import java.io.IOException;

public class SdkHttpRequestExecutor
extends HttpRequestExecutor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpResponse doSendRequest(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        AWSRequestMetrics awsRequestMetrics = (AWSRequestMetrics)context.getAttribute(AWSRequestMetrics.class.getSimpleName());
        if (awsRequestMetrics == null) {
            return super.doSendRequest(request, conn, context);
        }
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.HttpClientSendRequestTime);
        try {
            HttpResponse httpResponse = super.doSendRequest(request, conn, context);
            return httpResponse;
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.HttpClientSendRequestTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpResponse doReceiveResponse(HttpRequest request, HttpClientConnection conn, HttpContext context) throws HttpException, IOException {
        AWSRequestMetrics awsRequestMetrics = (AWSRequestMetrics)context.getAttribute(AWSRequestMetrics.class.getSimpleName());
        if (awsRequestMetrics == null) {
            return super.doReceiveResponse(request, conn, context);
        }
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.HttpClientReceiveResponseTime);
        try {
            HttpResponse httpResponse = super.doReceiveResponse(request, conn, context);
            return httpResponse;
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.HttpClientReceiveResponseTime);
        }
    }
}

