/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.regions;

import com.cloudera.com.amazonaws.AmazonWebServiceClient;
import com.cloudera.com.amazonaws.ClientConfiguration;
import com.cloudera.com.amazonaws.auth.AWSCredentialsProvider;
import com.cloudera.com.amazonaws.regions.RegionUtils;
import com.cloudera.com.amazonaws.regions.Regions;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public final class Region {
    private static final String DEFAULT_DOMAIN = "amazonaws.com";
    private final String name;
    private final String domain;
    private final Map<String, String> serviceEndpoints = new HashMap<String, String>();
    private final Map<String, Boolean> httpSupport = new HashMap<String, Boolean>();
    private final Map<String, Boolean> httpsSupport = new HashMap<String, Boolean>();

    Region(String name, String domain) {
        this.name = name;
        this.domain = domain == null ? DEFAULT_DOMAIN : domain;
    }

    public static Region getRegion(Regions region) {
        return RegionUtils.getRegion(region.getName());
    }

    public String getName() {
        return this.name;
    }

    public String getDomain() {
        return this.domain;
    }

    Map<String, String> getServiceEndpoints() {
        return this.serviceEndpoints;
    }

    Map<String, Boolean> getHttpSupport() {
        return this.httpSupport;
    }

    Map<String, Boolean> getHttpsSupport() {
        return this.httpsSupport;
    }

    public String getServiceEndpoint(String serviceName) {
        return this.serviceEndpoints.get(serviceName);
    }

    public boolean isServiceSupported(String serviceName) {
        return this.serviceEndpoints.containsKey(serviceName);
    }

    public boolean hasHttpsEndpoint(String serviceName) {
        return this.httpsSupport.containsKey(serviceName) && this.httpsSupport.get(serviceName) != false;
    }

    public boolean hasHttpEndpoint(String serviceName) {
        return this.httpSupport.containsKey(serviceName) && this.httpSupport.get(serviceName) != false;
    }

    public <T extends AmazonWebServiceClient> T createClient(Class<T> serviceClass, AWSCredentialsProvider credentials, ClientConfiguration config) {
        try {
            AmazonWebServiceClient client;
            if (credentials == null && config == null) {
                Constructor<T> constructor = serviceClass.getConstructor(new Class[0]);
                client = (AmazonWebServiceClient)constructor.newInstance(new Object[0]);
            } else if (credentials == null) {
                Constructor<T> constructor = serviceClass.getConstructor(ClientConfiguration.class);
                client = (AmazonWebServiceClient)constructor.newInstance(config);
            } else if (config == null) {
                Constructor<T> constructor = serviceClass.getConstructor(AWSCredentialsProvider.class);
                client = (AmazonWebServiceClient)constructor.newInstance(credentials);
            } else {
                Constructor<T> constructor = serviceClass.getConstructor(AWSCredentialsProvider.class, ClientConfiguration.class);
                client = (AmazonWebServiceClient)constructor.newInstance(credentials, config);
            }
            client.setRegion(this);
            return (T)client;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't instantiate instance of " + serviceClass, e);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Region)) {
            return false;
        }
        Region region = (Region)obj;
        return this.getName().equals(region.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

