/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.fasterxml.jackson.databind.node;

import com.cloudera.com.fasterxml.jackson.core.JsonGenerator;
import com.cloudera.com.fasterxml.jackson.core.JsonProcessingException;
import com.cloudera.com.fasterxml.jackson.core.JsonToken;
import com.cloudera.com.fasterxml.jackson.databind.JsonNode;
import com.cloudera.com.fasterxml.jackson.databind.SerializerProvider;
import com.cloudera.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.cloudera.com.fasterxml.jackson.databind.node.ArrayNode;
import com.cloudera.com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.cloudera.com.fasterxml.jackson.databind.node.ContainerNode;
import com.cloudera.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.cloudera.com.fasterxml.jackson.databind.node.JsonNodeType;
import com.cloudera.com.fasterxml.jackson.databind.node.MissingNode;
import com.cloudera.com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ObjectNode
extends ContainerNode<ObjectNode> {
    private final Map<String, JsonNode> _children = new LinkedHashMap<String, JsonNode>();

    public ObjectNode(JsonNodeFactory jsonNodeFactory) {
        super(jsonNodeFactory);
    }

    public ObjectNode deepCopy() {
        ObjectNode objectNode = new ObjectNode(this._nodeFactory);
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            objectNode._children.put(entry.getKey(), (JsonNode)entry.getValue().deepCopy());
        }
        return objectNode;
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.OBJECT;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_OBJECT;
    }

    @Override
    public int size() {
        return this._children.size();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children.values().iterator();
    }

    @Override
    public JsonNode get(int n) {
        return null;
    }

    @Override
    public JsonNode get(String string) {
        return this._children.get(string);
    }

    @Override
    public Iterator<String> fieldNames() {
        return this._children.keySet().iterator();
    }

    @Override
    public JsonNode path(int n) {
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode path(String string) {
        JsonNode jsonNode = this._children.get(string);
        if (jsonNode != null) {
            return jsonNode;
        }
        return MissingNode.getInstance();
    }

    @Override
    public Iterator<Map.Entry<String, JsonNode>> fields() {
        return this._children.entrySet().iterator();
    }

    @Override
    public ObjectNode with(String string) {
        JsonNode jsonNode = this._children.get(string);
        if (jsonNode != null) {
            if (jsonNode instanceof ObjectNode) {
                return (ObjectNode)jsonNode;
            }
            throw new UnsupportedOperationException("Property '" + string + "' has value that is not of type ObjectNode (but " + jsonNode.getClass().getName() + ")");
        }
        ObjectNode objectNode = this.objectNode();
        this._children.put(string, objectNode);
        return objectNode;
    }

    @Override
    public ArrayNode withArray(String string) {
        JsonNode jsonNode = this._children.get(string);
        if (jsonNode != null) {
            if (jsonNode instanceof ArrayNode) {
                return (ArrayNode)jsonNode;
            }
            throw new UnsupportedOperationException("Property '" + string + "' has value that is not of type ArrayNode (but " + jsonNode.getClass().getName() + ")");
        }
        ArrayNode arrayNode = this.arrayNode();
        this._children.put(string, arrayNode);
        return arrayNode;
    }

    @Override
    public JsonNode findValue(String string) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                return entry.getValue();
            }
            JsonNode jsonNode = entry.getValue().findValue(string);
            if (jsonNode == null) continue;
            return jsonNode;
        }
        return null;
    }

    @Override
    public List<JsonNode> findValues(String string, List<JsonNode> list) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                if (list == null) {
                    list = new ArrayList<JsonNode>();
                }
                list.add(entry.getValue());
                continue;
            }
            list = entry.getValue().findValues(string, list);
        }
        return list;
    }

    @Override
    public List<String> findValuesAsText(String string, List<String> list) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(entry.getValue().asText());
                continue;
            }
            list = entry.getValue().findValuesAsText(string, list);
        }
        return list;
    }

    @Override
    public ObjectNode findParent(String string) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                return this;
            }
            JsonNode jsonNode = entry.getValue().findParent(string);
            if (jsonNode == null) continue;
            return (ObjectNode)jsonNode;
        }
        return null;
    }

    @Override
    public List<JsonNode> findParents(String string, List<JsonNode> list) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                if (list == null) {
                    list = new ArrayList<JsonNode>();
                }
                list.add(this);
                continue;
            }
            list = entry.getValue().findParents(string, list);
        }
        return list;
    }

    @Override
    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        jsonGenerator.writeStartObject();
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            jsonGenerator.writeFieldName(entry.getKey());
            ((BaseJsonNode)entry.getValue()).serialize(jsonGenerator, serializerProvider);
        }
        jsonGenerator.writeEndObject();
    }

    @Override
    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
        typeSerializer.writeTypePrefixForObject(this, jsonGenerator);
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            jsonGenerator.writeFieldName(entry.getKey());
            ((BaseJsonNode)entry.getValue()).serialize(jsonGenerator, serializerProvider);
        }
        typeSerializer.writeTypeSuffixForObject(this, jsonGenerator);
    }

    public JsonNode set(String string, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        this._children.put(string, jsonNode);
        return this;
    }

    public JsonNode setAll(Map<String, JsonNode> map) {
        for (Map.Entry<String, JsonNode> entry : map.entrySet()) {
            JsonNode jsonNode = entry.getValue();
            if (jsonNode == null) {
                jsonNode = this.nullNode();
            }
            this._children.put(entry.getKey(), jsonNode);
        }
        return this;
    }

    public JsonNode setAll(ObjectNode objectNode) {
        this._children.putAll(objectNode._children);
        return this;
    }

    public JsonNode replace(String string, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        return this._children.put(string, jsonNode);
    }

    public JsonNode without(String string) {
        this._children.remove(string);
        return this;
    }

    public ObjectNode without(Collection<String> collection) {
        this._children.keySet().removeAll(collection);
        return this;
    }

    public JsonNode put(String string, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        return this._children.put(string, jsonNode);
    }

    public JsonNode remove(String string) {
        return this._children.remove(string);
    }

    public ObjectNode remove(Collection<String> collection) {
        this._children.keySet().removeAll(collection);
        return this;
    }

    @Override
    public ObjectNode removeAll() {
        this._children.clear();
        return this;
    }

    public JsonNode putAll(Map<String, JsonNode> map) {
        return this.setAll(map);
    }

    public JsonNode putAll(ObjectNode objectNode) {
        return this.setAll(objectNode);
    }

    public ObjectNode retain(Collection<String> collection) {
        this._children.keySet().retainAll(collection);
        return this;
    }

    public ObjectNode retain(String ... stringArray) {
        return this.retain(Arrays.asList(stringArray));
    }

    public ArrayNode putArray(String string) {
        ArrayNode arrayNode = this.arrayNode();
        this._children.put(string, arrayNode);
        return arrayNode;
    }

    public ObjectNode putObject(String string) {
        ObjectNode objectNode = this.objectNode();
        this._children.put(string, objectNode);
        return objectNode;
    }

    public ObjectNode putPOJO(String string, Object object) {
        this._children.put(string, this.pojoNode(object));
        return this;
    }

    public ObjectNode putNull(String string) {
        this._children.put(string, this.nullNode());
        return this;
    }

    public ObjectNode put(String string, short s) {
        this._children.put(string, this.numberNode(s));
        return this;
    }

    public ObjectNode put(String string, Short s) {
        if (s == null) {
            this._children.put(string, this.nullNode());
        } else {
            this._children.put(string, this.numberNode((short)s));
        }
        return this;
    }

    public ObjectNode put(String string, int n) {
        this._children.put(string, this.numberNode(n));
        return this;
    }

    public ObjectNode put(String string, Integer n) {
        if (n == null) {
            this._children.put(string, this.nullNode());
        } else {
            this._children.put(string, this.numberNode((int)n));
        }
        return this;
    }

    public ObjectNode put(String string, long l) {
        this._children.put(string, this.numberNode(l));
        return this;
    }

    public ObjectNode put(String string, Long l) {
        if (l == null) {
            this._children.put(string, this.nullNode());
        } else {
            this._children.put(string, this.numberNode((long)l));
        }
        return this;
    }

    public ObjectNode put(String string, float f) {
        this._children.put(string, this.numberNode(f));
        return this;
    }

    public ObjectNode put(String string, Float f) {
        if (f == null) {
            this._children.put(string, this.nullNode());
        } else {
            this._children.put(string, this.numberNode(f.floatValue()));
        }
        return this;
    }

    public ObjectNode put(String string, double d) {
        this._children.put(string, this.numberNode(d));
        return this;
    }

    public ObjectNode put(String string, Double d) {
        if (d == null) {
            this._children.put(string, this.nullNode());
        } else {
            this._children.put(string, this.numberNode((double)d));
        }
        return this;
    }

    public ObjectNode put(String string, BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            this.putNull(string);
        } else {
            this._children.put(string, this.numberNode(bigDecimal));
        }
        return this;
    }

    public ObjectNode put(String string, String string2) {
        if (string2 == null) {
            this.putNull(string);
        } else {
            this._children.put(string, this.textNode(string2));
        }
        return this;
    }

    public ObjectNode put(String string, boolean bl) {
        this._children.put(string, this.booleanNode(bl));
        return this;
    }

    public ObjectNode put(String string, Boolean bl) {
        if (bl == null) {
            this._children.put(string, this.nullNode());
        } else {
            this._children.put(string, this.booleanNode(bl));
        }
        return this;
    }

    public ObjectNode put(String string, byte[] byArray) {
        if (byArray == null) {
            this._children.put(string, this.nullNode());
        } else {
            this._children.put(string, this.binaryNode(byArray));
        }
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this._children.equals(((ObjectNode)object)._children);
    }

    public int hashCode() {
        return this._children.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32 + (this.size() << 4));
        stringBuilder.append("{");
        int n = 0;
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (n > 0) {
                stringBuilder.append(",");
            }
            ++n;
            TextNode.appendQuoted(stringBuilder, entry.getKey());
            stringBuilder.append(':');
            stringBuilder.append(entry.getValue().toString());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

