/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.fasterxml.jackson.databind.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUMap<K, V>
extends LinkedHashMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final int _maxEntries;
    protected transient int _jdkSerializeMaxEntries;

    public LRUMap(int n, int n2) {
        super(n, 0.8f, true);
        this._maxEntries = n2;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
        return this.size() > this._maxEntries;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this._jdkSerializeMaxEntries = objectInputStream.readInt();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this._jdkSerializeMaxEntries);
    }

    protected Object readResolve() {
        return new LRUMap<K, V>(this._jdkSerializeMaxEntries, this._jdkSerializeMaxEntries);
    }
}

