/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.AmazonServiceException;
import com.cloudera.com.amazonaws.event.ProgressEvent;
import com.cloudera.com.amazonaws.event.ProgressListener;
import com.cloudera.com.amazonaws.services.s3.AmazonS3;
import com.cloudera.com.amazonaws.services.s3.model.AmazonS3Exception;
import com.cloudera.com.amazonaws.services.s3.model.CannedAccessControlList;
import com.cloudera.com.amazonaws.services.s3.model.CopyObjectRequest;
import com.cloudera.com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.cloudera.com.amazonaws.services.s3.model.ListObjectsRequest;
import com.cloudera.com.amazonaws.services.s3.model.ObjectListing;
import com.cloudera.com.amazonaws.services.s3.model.ObjectMetadata;
import com.cloudera.com.amazonaws.services.s3.model.PutObjectRequest;
import com.cloudera.com.amazonaws.services.s3.model.S3ObjectSummary;
import com.cloudera.com.amazonaws.services.s3.model.UploadPartRequest;
import com.cloudera.com.amazonaws.services.s3.model.UploadPartResult;
import com.cloudera.com.amazonaws.services.s3.transfer.Copy;
import com.cloudera.com.amazonaws.services.s3.transfer.TransferManager;
import com.cloudera.com.amazonaws.services.s3.transfer.TransferManagerConfiguration;
import com.cloudera.com.amazonaws.services.s3.transfer.Upload;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.GlobalStorageStatistics;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.StorageStatistics;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.s3a.BlockingThreadPoolExecutorService;
import org.apache.hadoop.fs.s3a.Constants;
import org.apache.hadoop.fs.s3a.Listing;
import org.apache.hadoop.fs.s3a.ProgressableProgressListener;
import org.apache.hadoop.fs.s3a.S3AFastOutputStream;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.S3AInputPolicy;
import org.apache.hadoop.fs.s3a.S3AInputStream;
import org.apache.hadoop.fs.s3a.S3AInstrumentation;
import org.apache.hadoop.fs.s3a.S3AOutputStream;
import org.apache.hadoop.fs.s3a.S3AStorageStatistics;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.S3ClientFactory;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3native.S3xLoginHelper;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class S3AFileSystem
extends FileSystem {
    public static final int DEFAULT_BLOCKSIZE = 0x2000000;
    private URI uri;
    private Path workingDir;
    private AmazonS3 s3;
    private String bucket;
    private int maxKeys;
    private Listing listing;
    private long partSize;
    private boolean enableMultiObjectsDelete;
    private TransferManager transfers;
    private ExecutorService threadPoolExecutor;
    private long multiPartThreshold;
    public static final Logger LOG = LoggerFactory.getLogger(S3AFileSystem.class);
    private CannedAccessControlList cannedACL;
    private String serverSideEncryptionAlgorithm;
    private S3AInstrumentation instrumentation;
    private S3AStorageStatistics storageStatistics;
    private long readAhead;
    private S3AInputPolicy inputPolicy;
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private static final AtomicBoolean warnedOfCoreThreadDeprecation = new AtomicBoolean(false);
    private static final int MAX_ENTRIES_TO_DELETE = 1000;
    static final String DEPRECATED_ACCESS_KEY = "fs.s3a.awsAccessKeyId";
    static final String DEPRECATED_SECRET_KEY = "fs.s3a.awsSecretAccessKey";

    public static ThreadFactory getNamedThreadFactory(final String prefix) {
        SecurityManager s = System.getSecurityManager();
        final ThreadGroup threadGroup = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        return new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);
            private final int poolNum = S3AFileSystem.access$000().getAndIncrement();
            private final ThreadGroup group = threadGroup;

            @Override
            public Thread newThread(Runnable r) {
                String name = String.format("%s-pool%03d-t%04d", prefix, this.poolNum, this.threadNumber.getAndIncrement());
                return new Thread(this.group, r, name);
            }
        };
    }

    private static ThreadFactory newDaemonThreadFactory(String prefix) {
        final ThreadFactory namedFactory = S3AFileSystem.getNamedThreadFactory(prefix);
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = namedFactory.newThread(r);
                if (!t.isDaemon()) {
                    t.setDaemon(true);
                }
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                return t;
            }
        };
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        this.setConf(conf);
        try {
            this.instrumentation = new S3AInstrumentation(name);
            this.uri = S3xLoginHelper.buildFSURI(name);
            this.workingDir = new Path("/user", System.getProperty("user.name")).makeQualified(this.uri, this.getWorkingDirectory());
            this.bucket = name.getHost();
            Class s3ClientFactoryClass = conf.getClass("fs.s3a.s3.client.factory.impl", Constants.DEFAULT_S3_CLIENT_FACTORY_IMPL, S3ClientFactory.class);
            this.s3 = ((S3ClientFactory)ReflectionUtils.newInstance((Class)s3ClientFactoryClass, (Configuration)conf)).createS3Client(name, this.uri);
            this.maxKeys = S3AUtils.intOption(conf, "fs.s3a.paging.maximum", 5000, 1);
            this.listing = new Listing(this);
            this.partSize = conf.getLong("fs.s3a.multipart.size", 0x4000000L);
            if (this.partSize < 0x500000L) {
                LOG.error("fs.s3a.multipart.size must be at least 5 MB");
                this.partSize = 0x500000L;
            }
            this.multiPartThreshold = conf.getLong("fs.s3a.multipart.threshold", 0x8000000L);
            if (this.multiPartThreshold < 0x500000L) {
                LOG.error("fs.s3a.multipart.threshold must be at least 5 MB");
                this.multiPartThreshold = 0x500000L;
            }
            S3AUtils.longOption(conf, "fs.s3a.block.size", 0x2000000L, 1L);
            this.enableMultiObjectsDelete = conf.getBoolean("fs.s3a.multiobjectdelete.enable", true);
            this.readAhead = S3AUtils.longOption(conf, "fs.s3a.readahead.range", 65536L, 0L);
            this.storageStatistics = (S3AStorageStatistics)GlobalStorageStatistics.INSTANCE.put("S3AStorageStatistics", new GlobalStorageStatistics.StorageStatisticsProvider(){

                public StorageStatistics provide() {
                    return new S3AStorageStatistics();
                }
            });
            if (conf.getBoolean("cdh.fs.s3a.blocking.executor.enabled", false)) {
                int totalTasks;
                int maxThreads;
                if (conf.get("fs.s3a.threads.core") != null && warnedOfCoreThreadDeprecation.compareAndSet(false, true)) {
                    LoggerFactory.getLogger((String)"org.apache.hadoop.conf.Configuration.deprecation").warn("Unsupported option \"fs.s3a.threads.core\" will be ignored {}", (Object)conf.get("fs.s3a.threads.core"));
                }
                if ((maxThreads = conf.getInt("fs.s3a.threads.max", 256)) < 2) {
                    LOG.warn("fs.s3a.threads.max must be at least 2: forcing to 2.");
                    maxThreads = 2;
                }
                if ((totalTasks = conf.getInt("fs.s3a.max.total.tasks", 5)) < 1) {
                    LOG.warn("fs.s3a.max.total.tasksmust be at least 1: forcing to 1.");
                    totalTasks = 1;
                }
                long keepAliveTime = conf.getLong("fs.s3a.threads.keepalivetime", 60L);
                this.threadPoolExecutor = new BlockingThreadPoolExecutorService(maxThreads, maxThreads + totalTasks, keepAliveTime, TimeUnit.SECONDS, "s3a-transfer-shared");
            } else {
                int maxThreads = S3AUtils.intOption(conf, "fs.s3a.threads.max", 256, 0);
                int coreThreads = S3AUtils.intOption(conf, "fs.s3a.threads.core", 15, 0);
                if (maxThreads == 0) {
                    maxThreads = Runtime.getRuntime().availableProcessors() * 8;
                }
                if (coreThreads == 0) {
                    coreThreads = Runtime.getRuntime().availableProcessors() * 8;
                }
                long keepAliveTime = S3AUtils.longOption(conf, "fs.s3a.threads.keepalivetime", 60L, 0L);
                LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(maxThreads * S3AUtils.intOption(conf, "fs.s3a.max.total.tasks", 5, 1));
                this.threadPoolExecutor = new ThreadPoolExecutor(coreThreads, maxThreads, keepAliveTime, TimeUnit.SECONDS, workQueue, S3AFileSystem.newDaemonThreadFactory("s3a-transfer-shared-"));
                ((ThreadPoolExecutor)this.threadPoolExecutor).allowCoreThreadTimeOut(true);
            }
            this.initTransferManager();
            this.initCannedAcls(conf);
            this.verifyBucketExists();
            this.initMultipartUploads(conf);
            this.serverSideEncryptionAlgorithm = conf.getTrimmed("fs.s3a.server-side-encryption-algorithm");
            this.inputPolicy = S3AInputPolicy.getPolicy(conf.getTrimmed("fs.s3a.experimental.input.fadvise", "normal"));
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("initializing ", new Path(name), e);
        }
    }

    protected void verifyBucketExists() throws FileNotFoundException, IOException {
        try {
            if (!this.s3.doesBucketExist(this.bucket)) {
                throw new FileNotFoundException("Bucket " + this.bucket + " does not exist");
            }
        }
        catch (AmazonS3Exception e) {
            LOG.warn(S3AUtils.stringify(e), (Throwable)e);
            throw S3AUtils.translateException("doesBucketExist", this.bucket, (AmazonClientException)e);
        }
        catch (AmazonServiceException e) {
            LOG.warn(S3AUtils.stringify(e), (Throwable)e);
            throw S3AUtils.translateException("doesBucketExist", this.bucket, (AmazonClientException)e);
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("doesBucketExist", this.bucket, e);
        }
    }

    public S3AInstrumentation getInstrumentation() {
        return this.instrumentation;
    }

    private void initTransferManager() {
        TransferManagerConfiguration transferConfiguration = new TransferManagerConfiguration();
        transferConfiguration.setMinimumUploadPartSize(this.partSize);
        transferConfiguration.setMultipartUploadThreshold(this.multiPartThreshold);
        transferConfiguration.setMultipartCopyPartSize(this.partSize);
        transferConfiguration.setMultipartCopyThreshold(this.multiPartThreshold);
        this.transfers = new TransferManager(this.s3, this.threadPoolExecutor);
        this.transfers.setConfiguration(transferConfiguration);
    }

    private void initCannedAcls(Configuration conf) {
        String cannedACLName = conf.get("fs.s3a.acl.default", "");
        this.cannedACL = !cannedACLName.isEmpty() ? CannedAccessControlList.valueOf(cannedACLName) : null;
    }

    private void initMultipartUploads(Configuration conf) throws IOException {
        boolean purgeExistingMultipart = conf.getBoolean("fs.s3a.multipart.purge", false);
        long purgeExistingMultipartAge = S3AUtils.longOption(conf, "fs.s3a.multipart.purge.age", 14400L, 0L);
        if (purgeExistingMultipart) {
            Date purgeBefore = new Date(new Date().getTime() - purgeExistingMultipartAge * 1000L);
            try {
                this.transfers.abortMultipartUploads(this.bucket, purgeBefore);
            }
            catch (AmazonServiceException e) {
                if (e.getStatusCode() == 403) {
                    this.instrumentation.errorIgnored();
                    LOG.debug("Failed to purging multipart uploads against {}, FS may be read only", (Object)this.bucket, (Object)e);
                }
                throw S3AUtils.translateException("purging multipart uploads", this.bucket, (AmazonClientException)e);
            }
        }
    }

    public String getScheme() {
        return "s3a";
    }

    public URI getUri() {
        return this.uri;
    }

    public int getDefaultPort() {
        return -1;
    }

    @VisibleForTesting
    AmazonS3 getAmazonS3Client() {
        return this.s3;
    }

    @InterfaceStability.Unstable
    public S3AInputPolicy getInputPolicy() {
        return this.inputPolicy;
    }

    @InterfaceStability.Unstable
    public void setInputPolicy(S3AInputPolicy inputPolicy) {
        Objects.requireNonNull(inputPolicy, "Null inputStrategy");
        LOG.debug("Setting input strategy: {}", (Object)inputPolicy);
        this.inputPolicy = inputPolicy;
    }

    private String pathToKey(Path path) {
        if (!path.isAbsolute()) {
            path = new Path(this.workingDir, path);
        }
        if (path.toUri().getScheme() != null && path.toUri().getPath().isEmpty()) {
            return "";
        }
        return path.toUri().getPath().substring(1);
    }

    private String maybeAddTrailingSlash(String key) {
        if (!key.isEmpty() && !key.endsWith("/")) {
            return key + '/';
        }
        return key;
    }

    private Path keyToPath(String key) {
        return new Path("/" + key);
    }

    Path keyToQualifiedPath(String key) {
        return this.qualify(this.keyToPath(key));
    }

    Path qualify(Path path) {
        return path.makeQualified(this.uri, this.workingDir);
    }

    public void checkPath(Path path) {
        S3xLoginHelper.checkPath(this.getConf(), this.getUri(), path, this.getDefaultPort());
    }

    protected URI canonicalizeUri(URI rawUri) {
        return S3xLoginHelper.canonicalizeUri(rawUri, this.getDefaultPort());
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        LOG.debug("Opening '{}' for reading.", (Object)f);
        S3AFileStatus fileStatus = this.getFileStatus(f);
        if (fileStatus.isDirectory()) {
            throw new FileNotFoundException("Can't open " + f + " because it is a directory");
        }
        return new FSDataInputStream((InputStream)((Object)new S3AInputStream(this.bucket, this.pathToKey(f), fileStatus.getLen(), this.s3, this.statistics, this.instrumentation, this.readAhead, this.inputPolicy)));
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        String key = this.pathToKey(f);
        S3AFileStatus status = null;
        try {
            status = this.getFileStatus(f);
            if (status.isDirectory()) {
                throw new FileAlreadyExistsException(f + " is a directory");
            }
            if (!overwrite) {
                throw new FileAlreadyExistsException(f + " already exists");
            }
            LOG.debug("Overwriting file {}", (Object)f);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        this.instrumentation.fileCreated();
        if (this.getConf().getBoolean("fs.s3a.fast.upload", false)) {
            return new FSDataOutputStream((OutputStream)new S3AFastOutputStream(this.s3, this, this.bucket, key, progress, this.cannedACL, this.partSize, this.multiPartThreshold, this.threadPoolExecutor), this.statistics);
        }
        return new FSDataOutputStream((OutputStream)new S3AOutputStream(this.getConf(), this, key, progress), null);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        try {
            return this.innerRename(src, dst);
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("rename(" + src + ", " + dst + ")", src, e);
        }
    }

    private boolean innerRename(Path src, Path dst) throws IOException, AmazonClientException {
        S3AFileStatus dstStatus;
        S3AFileStatus srcStatus;
        String dstKey;
        String srcKey;
        block24: {
            LOG.debug("Rename path {} to {}", (Object)src, (Object)dst);
            this.incrementStatistic(Statistic.INVOCATION_RENAME);
            srcKey = this.pathToKey(src);
            dstKey = this.pathToKey(dst);
            if (srcKey.isEmpty() || dstKey.isEmpty()) {
                LOG.debug("rename: source {} or dest {}, is empty", (Object)srcKey, (Object)dstKey);
                return false;
            }
            try {
                srcStatus = this.getFileStatus(src);
            }
            catch (FileNotFoundException e) {
                LOG.error("rename: src not found {}", (Object)src);
                return false;
            }
            if (srcKey.equals(dstKey)) {
                LOG.debug("rename: src and dst refer to the same file or directory: {}", (Object)dst);
                return srcStatus.isFile();
            }
            dstStatus = null;
            try {
                dstStatus = this.getFileStatus(dst);
                if (srcStatus.isDirectory() && dstStatus.isFile()) {
                    LOG.debug("rename: src {} is a directory and dst {} is a file", (Object)src, (Object)dst);
                    return false;
                }
                if (dstStatus.isDirectory() && !dstStatus.isEmptyDirectory()) {
                    return false;
                }
            }
            catch (FileNotFoundException e) {
                LOG.debug("rename: destination path {} not found", (Object)dst);
                Path parent = dst.getParent();
                if (this.pathToKey(parent).isEmpty()) break block24;
                try {
                    S3AFileStatus dstParentStatus = this.getFileStatus(dst.getParent());
                    if (!dstParentStatus.isDirectory()) {
                        return false;
                    }
                }
                catch (FileNotFoundException e2) {
                    LOG.debug("rename: destination path {} has no parent {}", (Object)dst, (Object)parent);
                    return false;
                }
            }
        }
        if (srcStatus.isFile()) {
            LOG.debug("rename: renaming file {} to {}", (Object)src, (Object)dst);
            if (dstStatus != null && dstStatus.isDirectory()) {
                String newDstKey = dstKey;
                if (!newDstKey.endsWith("/")) {
                    newDstKey = newDstKey + "/";
                }
                String filename = srcKey.substring(this.pathToKey(src.getParent()).length() + 1);
                newDstKey = newDstKey + filename;
                this.copyFile(srcKey, newDstKey, srcStatus.getLen());
            } else {
                this.copyFile(srcKey, dstKey, srcStatus.getLen());
            }
            this.innerDelete(srcStatus, false);
        } else {
            LOG.debug("rename: renaming directory {} to {}", (Object)src, (Object)dst);
            if (!dstKey.endsWith("/")) {
                dstKey = dstKey + "/";
            }
            if (!srcKey.endsWith("/")) {
                srcKey = srcKey + "/";
            }
            if (dstKey.startsWith(srcKey)) {
                LOG.debug("cannot rename a directory {} to a subdirectory of self: {}", (Object)srcKey, (Object)dstKey);
                return false;
            }
            ArrayList<DeleteObjectsRequest.KeyVersion> keysToDelete = new ArrayList<DeleteObjectsRequest.KeyVersion>();
            if (dstStatus != null && dstStatus.isEmptyDirectory()) {
                keysToDelete.add(new DeleteObjectsRequest.KeyVersion(dstKey));
            }
            ListObjectsRequest request = new ListObjectsRequest();
            request.setBucketName(this.bucket);
            request.setPrefix(srcKey);
            request.setMaxKeys(this.maxKeys);
            ObjectListing objects = this.listObjects(request);
            while (true) {
                for (S3ObjectSummary summary : objects.getObjectSummaries()) {
                    keysToDelete.add(new DeleteObjectsRequest.KeyVersion(summary.getKey()));
                    String newDstKey = dstKey + summary.getKey().substring(srcKey.length());
                    this.copyFile(summary.getKey(), newDstKey, summary.getSize());
                    if (keysToDelete.size() != 1000) continue;
                    this.removeKeys(keysToDelete, true);
                }
                if (!objects.isTruncated()) break;
                objects = this.continueListObjects(objects);
            }
            if (!keysToDelete.isEmpty()) {
                this.removeKeys(keysToDelete, false);
            }
        }
        if (src.getParent() != dst.getParent()) {
            this.deleteUnnecessaryFakeDirectories(dst.getParent());
            this.createFakeDirectoryIfNecessary(src.getParent());
        }
        return true;
    }

    @VisibleForTesting
    public ObjectMetadata getObjectMetadata(Path path) throws IOException {
        return this.getObjectMetadata(this.pathToKey(path));
    }

    protected void incrementStatistic(Statistic statistic) {
        this.incrementStatistic(statistic, 1L);
    }

    protected void incrementStatistic(Statistic statistic, long count) {
        this.instrumentation.incrementCounter(statistic, count);
        this.storageStatistics.incrementCounter(statistic, count);
    }

    protected ObjectMetadata getObjectMetadata(String key) {
        this.incrementStatistic(Statistic.OBJECT_METADATA_REQUESTS);
        ObjectMetadata meta = this.s3.getObjectMetadata(this.bucket, key);
        this.incrementReadOperations();
        return meta;
    }

    protected ObjectListing listObjects(ListObjectsRequest request) {
        this.incrementStatistic(Statistic.OBJECT_LIST_REQUESTS);
        this.incrementReadOperations();
        return this.s3.listObjects(request);
    }

    protected ObjectListing continueListObjects(ObjectListing objects) {
        this.incrementStatistic(Statistic.OBJECT_CONTINUE_LIST_REQUESTS);
        this.incrementReadOperations();
        return this.s3.listNextBatchOfObjects(objects);
    }

    public void incrementReadOperations() {
        this.statistics.incrementReadOps(1);
    }

    public void incrementWriteOperations() {
        this.statistics.incrementWriteOps(1);
    }

    private void deleteObject(String key) {
        this.incrementWriteOperations();
        this.incrementStatistic(Statistic.OBJECT_DELETE_REQUESTS);
        this.s3.deleteObject(this.bucket, key);
    }

    private void deleteObjects(DeleteObjectsRequest deleteRequest) {
        this.incrementWriteOperations();
        this.incrementStatistic(Statistic.OBJECT_DELETE_REQUESTS, 1L);
        this.s3.deleteObjects(deleteRequest);
    }

    public PutObjectRequest newPutObjectRequest(String key, ObjectMetadata metadata, File srcfile) {
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, key, srcfile);
        putObjectRequest.setCannedAcl(this.cannedACL);
        putObjectRequest.setMetadata(metadata);
        return putObjectRequest;
    }

    PutObjectRequest newPutObjectRequest(String key, ObjectMetadata metadata, InputStream inputStream) {
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, key, inputStream, metadata);
        putObjectRequest.setCannedAcl(this.cannedACL);
        return putObjectRequest;
    }

    public ObjectMetadata newObjectMetadata() {
        ObjectMetadata om = new ObjectMetadata();
        if (StringUtils.isNotBlank((String)this.serverSideEncryptionAlgorithm)) {
            om.setSSEAlgorithm(this.serverSideEncryptionAlgorithm);
        }
        return om;
    }

    public ObjectMetadata newObjectMetadata(long length) {
        ObjectMetadata om = this.newObjectMetadata();
        om.setContentLength(length);
        return om;
    }

    public Upload putObject(PutObjectRequest putObjectRequest) {
        long len = putObjectRequest.getFile() != null ? putObjectRequest.getFile().length() : putObjectRequest.getMetadata().getContentLength();
        this.incrementPutStartStatistics(len);
        return this.transfers.upload(putObjectRequest);
    }

    public UploadPartResult uploadPart(UploadPartRequest request) {
        this.incrementPutStartStatistics(request.getPartSize());
        return this.s3.uploadPart(request);
    }

    public void incrementPutStartStatistics(long bytes) {
        LOG.debug("PUT start {} bytes", (Object)bytes);
        this.incrementWriteOperations();
        this.incrementStatistic(Statistic.OBJECT_PUT_REQUESTS);
        if (bytes > 0L) {
            this.incrementStatistic(Statistic.OBJECT_PUT_BYTES, bytes);
        }
    }

    public void incrementPutProgressStatistics(String key, long bytes) {
        LOG.debug("PUT {}: {} bytes", (Object)key, (Object)bytes);
        this.incrementWriteOperations();
        if (bytes > 0L) {
            this.statistics.incrementBytesWritten(bytes);
        }
    }

    private void removeKeys(List<DeleteObjectsRequest.KeyVersion> keysToDelete, boolean clearKeys) throws AmazonClientException {
        if (this.enableMultiObjectsDelete) {
            this.deleteObjects(new DeleteObjectsRequest(this.bucket).withKeys(keysToDelete));
            this.instrumentation.fileDeleted(keysToDelete.size());
        } else {
            for (DeleteObjectsRequest.KeyVersion keyVersion : keysToDelete) {
                this.deleteObject(keyVersion.getKey());
            }
            this.instrumentation.fileDeleted(keysToDelete.size());
        }
        if (clearKeys) {
            keysToDelete.clear();
        }
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        try {
            return this.innerDelete(this.getFileStatus(f), recursive);
        }
        catch (FileNotFoundException e) {
            LOG.debug("Couldn't delete {} - does not exist", (Object)f);
            this.instrumentation.errorIgnored();
            return false;
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("delete", f, e);
        }
    }

    private boolean innerDelete(S3AFileStatus status, boolean recursive) throws IOException, AmazonClientException {
        Path f = status.getPath();
        LOG.debug("Delete path {} - recursive {}", (Object)f, (Object)recursive);
        String key = this.pathToKey(f);
        if (status.isDirectory()) {
            LOG.debug("delete: Path is a directory: {}", (Object)f);
            if (!recursive && !status.isEmptyDirectory()) {
                throw new IOException("Path is a folder: " + f + " and it is not an empty directory");
            }
            if (!key.endsWith("/")) {
                key = key + "/";
            }
            if (key.equals("/")) {
                LOG.info("s3a cannot delete the root directory");
                return false;
            }
            if (status.isEmptyDirectory()) {
                LOG.debug("Deleting fake empty directory {}", (Object)key);
                this.deleteObject(key);
                this.instrumentation.directoryDeleted();
            } else {
                LOG.debug("Getting objects for directory prefix {} to delete", (Object)key);
                ListObjectsRequest request = this.createListObjectsRequest(key, null);
                ObjectListing objects = this.listObjects(request);
                ArrayList<DeleteObjectsRequest.KeyVersion> keys = new ArrayList<DeleteObjectsRequest.KeyVersion>(objects.getObjectSummaries().size());
                while (true) {
                    for (S3ObjectSummary summary : objects.getObjectSummaries()) {
                        keys.add(new DeleteObjectsRequest.KeyVersion(summary.getKey()));
                        LOG.debug("Got object to delete {}", (Object)summary.getKey());
                        if (keys.size() != 1000) continue;
                        this.removeKeys(keys, true);
                    }
                    if (!objects.isTruncated()) break;
                    objects = this.continueListObjects(objects);
                }
                if (!keys.isEmpty()) {
                    this.removeKeys(keys, false);
                }
            }
        } else {
            LOG.debug("delete: Path is a file");
            this.instrumentation.fileDeleted(1);
            this.deleteObject(key);
        }
        this.createFakeDirectoryIfNecessary(f.getParent());
        return true;
    }

    private void createFakeDirectoryIfNecessary(Path f) throws IOException, AmazonClientException {
        String key = this.pathToKey(f);
        if (!key.isEmpty() && !this.exists(f)) {
            LOG.debug("Creating new fake directory at {}", (Object)f);
            this.createFakeDirectory(key);
        }
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        try {
            return this.innerListStatus(f);
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("listStatus", f, e);
        }
    }

    public FileStatus[] innerListStatus(Path f) throws FileNotFoundException, IOException, AmazonClientException {
        Path path = this.qualify(f);
        String key = this.pathToKey(path);
        LOG.debug("List status for path: {}", (Object)path);
        this.incrementStatistic(Statistic.INVOCATION_LIST_STATUS);
        S3AFileStatus fileStatus = this.getFileStatus(path);
        if (fileStatus.isDirectory()) {
            if (!key.isEmpty()) {
                key = key + '/';
            }
            ListObjectsRequest request = this.createListObjectsRequest(key, "/");
            LOG.debug("listStatus: doing listObjects for directory {}", (Object)key);
            Listing.FileStatusListingIterator files = this.listing.createFileStatusListingIterator(path, request, Listing.ACCEPT_ALL, new Listing.AcceptAllButSelfAndS3nDirs(path));
            ArrayList<FileStatus> result = new ArrayList<FileStatus>(files.getBatchSize());
            while (files.hasNext()) {
                result.add(files.next());
            }
            return result.toArray(new FileStatus[result.size()]);
        }
        LOG.debug("Adding: rd (not a dir): {}", (Object)path);
        FileStatus[] stats = new FileStatus[]{fileStatus};
        return stats;
    }

    private ListObjectsRequest createListObjectsRequest(String key, String delimiter) {
        ListObjectsRequest request = new ListObjectsRequest();
        request.setBucketName(this.bucket);
        request.setMaxKeys(this.maxKeys);
        request.setPrefix(key);
        if (delimiter != null) {
            request.setDelimiter(delimiter);
        }
        return request;
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDir = newDir;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public boolean mkdirs(Path path, FsPermission permission) throws IOException, FileAlreadyExistsException {
        try {
            return this.innerMkdirs(path, permission);
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("innerMkdirs", path, e);
        }
    }

    private boolean innerMkdirs(Path f, FsPermission permission) throws IOException, FileAlreadyExistsException, AmazonClientException {
        LOG.debug("Making directory: {}", (Object)f);
        this.incrementStatistic(Statistic.INVOCATION_MKDIRS);
        try {
            S3AFileStatus fileStatus = this.getFileStatus(f);
            if (fileStatus.isDirectory()) {
                return true;
            }
            throw new FileAlreadyExistsException("Path is a file: " + f);
        }
        catch (FileNotFoundException e) {
            Path fPart = f.getParent();
            do {
                try {
                    S3AFileStatus fileStatus = this.getFileStatus(fPart);
                    if (fileStatus.isDirectory()) break;
                    if (!fileStatus.isFile()) continue;
                    throw new FileAlreadyExistsException(String.format("Can't make directory for path '%s' since it is a file.", fPart));
                }
                catch (FileNotFoundException fnfe) {
                    this.instrumentation.errorIgnored();
                }
            } while ((fPart = fPart.getParent()) != null);
            String key = this.pathToKey(f);
            this.createFakeDirectory(key);
            return true;
        }
    }

    public S3AFileStatus getFileStatus(Path f) throws IOException {
        this.incrementStatistic(Statistic.INVOCATION_GET_FILE_STATUS);
        Path path = this.qualify(f);
        String key = this.pathToKey(path);
        LOG.debug("Getting path status for {}  ({})", (Object)path, (Object)key);
        if (!key.isEmpty()) {
            try {
                ObjectMetadata meta = this.getObjectMetadata(key);
                if (S3AUtils.objectRepresentsDirectory(key, meta.getContentLength())) {
                    LOG.debug("Found exact file: fake directory");
                    return new S3AFileStatus(true, true, path);
                }
                LOG.debug("Found exact file: normal file");
                return new S3AFileStatus(meta.getContentLength(), S3AUtils.dateToLong(meta.getLastModified()), path, this.getDefaultBlockSize(path));
            }
            catch (AmazonServiceException e) {
                if (e.getStatusCode() != 404) {
                    throw S3AUtils.translateException("getFileStatus", path, (AmazonClientException)e);
                }
            }
            catch (AmazonClientException e) {
                throw S3AUtils.translateException("getFileStatus", path, e);
            }
            if (!key.endsWith("/")) {
                String newKey = key + "/";
                try {
                    ObjectMetadata meta = this.getObjectMetadata(newKey);
                    if (S3AUtils.objectRepresentsDirectory(newKey, meta.getContentLength())) {
                        LOG.debug("Found file (with /): fake directory");
                        return new S3AFileStatus(true, true, path);
                    }
                    LOG.warn("Found file (with /): real file? should not happen: {}", (Object)key);
                    return new S3AFileStatus(meta.getContentLength(), S3AUtils.dateToLong(meta.getLastModified()), path, this.getDefaultBlockSize(path));
                }
                catch (AmazonServiceException e) {
                    if (e.getStatusCode() != 404) {
                        throw S3AUtils.translateException("getFileStatus", newKey, (AmazonClientException)e);
                    }
                }
                catch (AmazonClientException e) {
                    throw S3AUtils.translateException("getFileStatus", newKey, e);
                }
            }
        }
        try {
            key = this.maybeAddTrailingSlash(key);
            ListObjectsRequest request = new ListObjectsRequest();
            request.setBucketName(this.bucket);
            request.setPrefix(key);
            request.setDelimiter("/");
            request.setMaxKeys(1);
            ObjectListing objects = this.listObjects(request);
            if (!objects.getCommonPrefixes().isEmpty() || !objects.getObjectSummaries().isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found path as directory (with /): {}/{}", (Object)objects.getCommonPrefixes().size(), (Object)objects.getObjectSummaries().size());
                    for (S3ObjectSummary summary : objects.getObjectSummaries()) {
                        LOG.debug("Summary: {} {}", (Object)summary.getKey(), (Object)summary.getSize());
                    }
                    for (String prefix : objects.getCommonPrefixes()) {
                        LOG.debug("Prefix: {}", (Object)prefix);
                    }
                }
                return new S3AFileStatus(true, false, path);
            }
            if (key.isEmpty()) {
                LOG.debug("Found root directory");
                return new S3AFileStatus(true, true, path);
            }
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() != 404) {
                throw S3AUtils.translateException("getFileStatus", key, (AmazonClientException)e);
            }
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("getFileStatus", key, e);
        }
        LOG.debug("Not Found: {}", (Object)path);
        throw new FileNotFoundException("No such file or directory: " + path);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        try {
            this.innerCopyFromLocalFile(delSrc, overwrite, src, dst);
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("copyFromLocalFile(" + src + ", " + dst + ")", src, e);
        }
    }

    private void innerCopyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException, FileAlreadyExistsException, AmazonClientException {
        this.incrementStatistic(Statistic.INVOCATION_COPY_FROM_LOCAL_FILE);
        String key = this.pathToKey(dst);
        if (!overwrite && this.exists(dst)) {
            throw new FileAlreadyExistsException(dst + " already exists");
        }
        LOG.debug("Copying local file from {} to {}", (Object)src, (Object)dst);
        LocalFileSystem local = S3AFileSystem.getLocal((Configuration)this.getConf());
        File srcfile = local.pathToFile(src);
        ObjectMetadata om = this.newObjectMetadata();
        PutObjectRequest putObjectRequest = this.newPutObjectRequest(key, om, srcfile);
        Upload up = this.putObject(putObjectRequest);
        ProgressableProgressListener listener = new ProgressableProgressListener(this, key, up, null);
        up.addProgressListener(listener);
        try {
            up.waitForUploadResult();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted copying " + src + " to " + dst + ", cancelling");
        }
        listener.uploadCompleted();
        this.finishedWrite(key);
        if (delSrc) {
            local.delete(src, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.transfers != null) {
                this.transfers.shutdownNow(true);
                this.transfers = null;
            }
        }
    }

    public String getCanonicalServiceName() {
        return null;
    }

    private void copyFile(String srcKey, String dstKey, long size) throws IOException, InterruptedIOException, AmazonClientException {
        LOG.debug("copyFile {} -> {} ", (Object)srcKey, (Object)dstKey);
        try {
            ObjectMetadata srcom = this.getObjectMetadata(srcKey);
            ObjectMetadata dstom = this.cloneObjectMetadata(srcom);
            if (StringUtils.isNotBlank((String)this.serverSideEncryptionAlgorithm)) {
                dstom.setSSEAlgorithm(this.serverSideEncryptionAlgorithm);
            }
            CopyObjectRequest copyObjectRequest = new CopyObjectRequest(this.bucket, srcKey, this.bucket, dstKey);
            copyObjectRequest.setCannedAccessControlList(this.cannedACL);
            copyObjectRequest.setNewObjectMetadata(dstom);
            ProgressListener progressListener = new ProgressListener(){

                @Override
                public void progressChanged(ProgressEvent progressEvent) {
                    switch (progressEvent.getEventType()) {
                        case TRANSFER_PART_COMPLETED_EVENT: {
                            S3AFileSystem.this.incrementWriteOperations();
                            break;
                        }
                    }
                }
            };
            Copy copy = this.transfers.copy(copyObjectRequest);
            copy.addProgressListener(progressListener);
            try {
                copy.waitForCopyResult();
                this.incrementWriteOperations();
                this.instrumentation.filesCopied(1, size);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("Interrupted copying " + srcKey + " to " + dstKey + ", cancelling");
            }
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("copyFile(" + srcKey + ", " + dstKey + ")", srcKey, e);
        }
    }

    public void finishedWrite(String key) {
        LOG.debug("Finished write to {}", (Object)key);
        this.deleteUnnecessaryFakeDirectories(this.keyToPath(key).getParent());
    }

    private void deleteUnnecessaryFakeDirectories(Path f) {
        while (true) {
            String key = "";
            try {
                key = this.pathToKey(f);
                if (key.isEmpty()) break;
                S3AFileStatus status = this.getFileStatus(f);
                if (status.isDirectory() && status.isEmptyDirectory()) {
                    LOG.debug("Deleting fake directory {}/", (Object)key);
                    this.deleteObject(key + "/");
                }
            }
            catch (AmazonClientException | IOException e) {
                LOG.debug("While deleting key {} ", (Object)key, (Object)e);
                this.instrumentation.errorIgnored();
            }
            if (f.isRoot()) break;
            f = f.getParent();
        }
    }

    private void createFakeDirectory(String objectName) throws AmazonClientException, AmazonServiceException, InterruptedIOException {
        if (!objectName.endsWith("/")) {
            this.createEmptyObject(objectName + "/");
        } else {
            this.createEmptyObject(objectName);
        }
    }

    private void createEmptyObject(String objectName) throws AmazonClientException, AmazonServiceException, InterruptedIOException {
        InputStream im = new InputStream(){

            @Override
            public int read() throws IOException {
                return -1;
            }
        };
        PutObjectRequest putObjectRequest = this.newPutObjectRequest(objectName, this.newObjectMetadata(0L), im);
        Upload upload = this.putObject(putObjectRequest);
        try {
            upload.waitForUploadResult();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted creating " + objectName);
        }
        this.incrementPutProgressStatistics(objectName, 0L);
        this.instrumentation.directoryCreated();
    }

    private ObjectMetadata cloneObjectMetadata(ObjectMetadata source) {
        ObjectMetadata ret = this.newObjectMetadata(source.getContentLength());
        if (source.getCacheControl() != null) {
            ret.setCacheControl(source.getCacheControl());
        }
        if (source.getContentDisposition() != null) {
            ret.setContentDisposition(source.getContentDisposition());
        }
        if (source.getContentEncoding() != null) {
            ret.setContentEncoding(source.getContentEncoding());
        }
        if (source.getContentMD5() != null) {
            ret.setContentMD5(source.getContentMD5());
        }
        if (source.getContentType() != null) {
            ret.setContentType(source.getContentType());
        }
        if (source.getExpirationTime() != null) {
            ret.setExpirationTime(source.getExpirationTime());
        }
        if (source.getExpirationTimeRuleId() != null) {
            ret.setExpirationTimeRuleId(source.getExpirationTimeRuleId());
        }
        if (source.getHttpExpiresDate() != null) {
            ret.setHttpExpiresDate(source.getHttpExpiresDate());
        }
        if (source.getLastModified() != null) {
            ret.setLastModified(source.getLastModified());
        }
        if (source.getOngoingRestore() != null) {
            ret.setOngoingRestore(source.getOngoingRestore());
        }
        if (source.getRestoreExpirationTime() != null) {
            ret.setRestoreExpirationTime(source.getRestoreExpirationTime());
        }
        if (source.getSSEAlgorithm() != null) {
            ret.setSSEAlgorithm(source.getSSEAlgorithm());
        }
        if (source.getSSECustomerAlgorithm() != null) {
            ret.setSSECustomerAlgorithm(source.getSSECustomerAlgorithm());
        }
        if (source.getSSECustomerKeyMd5() != null) {
            ret.setSSECustomerKeyMd5(source.getSSECustomerKeyMd5());
        }
        for (Map.Entry<String, String> e : source.getUserMetadata().entrySet()) {
            ret.addUserMetadata(e.getKey(), e.getValue());
        }
        return ret;
    }

    @Deprecated
    public long getDefaultBlockSize() {
        return this.getConf().getLong("fs.s3a.block.size", 0x2000000L);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("S3AFileSystem{");
        sb.append("uri=").append(this.uri);
        sb.append(", workingDir=").append(this.workingDir);
        sb.append(", inputPolicy=").append((Object)this.inputPolicy);
        sb.append(", partSize=").append(this.partSize);
        sb.append(", enableMultiObjectsDelete=").append(this.enableMultiObjectsDelete);
        sb.append(", maxKeys=").append(this.maxKeys);
        if (this.cannedACL != null) {
            sb.append(", cannedACL=").append(this.cannedACL.toString());
        }
        sb.append(", readAhead=").append(this.readAhead);
        sb.append(", blockSize=").append(this.getDefaultBlockSize());
        sb.append(", multiPartThreshold=").append(this.multiPartThreshold);
        if (this.serverSideEncryptionAlgorithm != null) {
            sb.append(", serverSideEncryptionAlgorithm='").append(this.serverSideEncryptionAlgorithm).append('\'');
        }
        sb.append(", statistics {").append(this.statistics).append("}");
        sb.append(", metrics {").append(this.instrumentation.dump("{", "=", "} ", true)).append("}");
        sb.append('}');
        return sb.toString();
    }

    public long getPartitionSize() {
        return this.partSize;
    }

    public long getMultiPartThreshold() {
        return this.multiPartThreshold;
    }

    int getMaxKeys() {
        return this.maxKeys;
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        this.incrementStatistic(Statistic.INVOCATION_GLOB_STATUS);
        return super.globStatus(pathPattern);
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        this.incrementStatistic(Statistic.INVOCATION_GLOB_STATUS);
        return super.globStatus(pathPattern, filter);
    }

    public boolean exists(Path f) throws IOException {
        this.incrementStatistic(Statistic.INVOCATION_EXISTS);
        return super.exists(f);
    }

    public boolean isDirectory(Path f) throws IOException {
        this.incrementStatistic(Statistic.INVOCATION_IS_DIRECTORY);
        return super.isDirectory(f);
    }

    public boolean isFile(Path f) throws IOException {
        this.incrementStatistic(Statistic.INVOCATION_IS_FILE);
        return super.isFile(f);
    }

    public RemoteIterator<LocatedFileStatus> listFiles(Path f, boolean recursive) throws FileNotFoundException, IOException {
        this.incrementStatistic(Statistic.INVOCATION_LIST_FILES);
        Path path = this.qualify(f);
        LOG.debug("listFiles({}, {})", (Object)path, (Object)recursive);
        try {
            S3AFileStatus fileStatus = this.getFileStatus(path);
            if (fileStatus.isFile()) {
                LOG.debug("Path is a file");
                return new Listing.SingleStatusRemoteIterator(this.toLocatedFileStatus(fileStatus));
            }
            String key = this.maybeAddTrailingSlash(this.pathToKey(path));
            String delimiter = recursive ? null : "/";
            LOG.debug("Requesting all entries under {} with delimiter '{}'", (Object)key, (Object)delimiter);
            return this.listing.createLocatedFileStatusIterator(this.listing.createFileStatusListingIterator(path, this.createListObjectsRequest(key, delimiter), Listing.ACCEPT_ALL, new Listing.AcceptFilesOnly(path)));
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("listFiles", path, e);
        }
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws FileNotFoundException, IOException {
        return this.listLocatedStatus(f, Listing.ACCEPT_ALL);
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f, PathFilter filter) throws FileNotFoundException, IOException {
        this.incrementStatistic(Statistic.INVOCATION_LIST_LOCATED_STATUS);
        Path path = this.qualify(f);
        LOG.debug("listLocatedStatus({}, {}", (Object)path, (Object)filter);
        try {
            S3AFileStatus fileStatus = this.getFileStatus(path);
            if (fileStatus.isFile()) {
                LOG.debug("Path is a file");
                return new Listing.SingleStatusRemoteIterator(filter.accept(path) ? this.toLocatedFileStatus(fileStatus) : null);
            }
            String key = this.maybeAddTrailingSlash(this.pathToKey(path));
            return this.listing.createLocatedFileStatusIterator(this.listing.createFileStatusListingIterator(path, this.createListObjectsRequest(key, "/"), filter, new Listing.AcceptAllButSelfAndS3nDirs(path)));
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("listLocatedStatus", path, e);
        }
    }

    LocatedFileStatus toLocatedFileStatus(FileStatus status) throws IOException {
        return new LocatedFileStatus(status, status.isFile() ? this.getFileBlockLocations(status, 0L, status.getLen()) : null);
    }

    static /* synthetic */ AtomicInteger access$000() {
        return poolNumber;
    }
}

