/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pensol;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileDto;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileTreeDto;
import org.pentaho.reporting.libraries.pensol.JCRSolutionFileModel;

public class RepositoryFileTreeDtoProxy
extends RepositoryFileTreeDto {
    private static final String URL_TEMPLATE = "/api/repo/files/:REPLACEMENT:/tree?depth=1&filter=*&showHidden=true";
    private final RepositoryFileTreeDto dto;
    private final Client client;
    private final String baseUrl;

    public RepositoryFileTreeDtoProxy(RepositoryFileTreeDto dto, Client client, String baseUrl) {
        this.dto = dto;
        this.baseUrl = baseUrl;
        this.client = client;
        if (this.dto.getFile().isFolder()) {
            this.dto.setChildren(null);
        } else {
            this.dto.setChildren(Collections.emptyList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RepositoryFileTreeDto> getChildren() {
        List<RepositoryFileTreeDto> children = this.dto.getChildren();
        if (children == null) {
            RepositoryFileTreeDtoProxy repositoryFileTreeDtoProxy = this;
            synchronized (repositoryFileTreeDtoProxy) {
                children = this.dto.getChildren();
                if (children == null) {
                    children = this.loadChildren(this.dto.getFile().getPath());
                    this.dto.setChildren(children);
                }
            }
        }
        return children;
    }

    private List<RepositoryFileTreeDto> loadChildren(String path) {
        List<RepositoryFileTreeDto> tree;
        String encodedPath = JCRSolutionFileModel.encodePathForRequest(path);
        String childrenUrl = URL_TEMPLATE.replace(":REPLACEMENT:", encodedPath);
        WebResource resource = this.client.resource(this.baseUrl + childrenUrl);
        RepositoryFileTreeDto element = (RepositoryFileTreeDto)resource.path("").accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(RepositoryFileTreeDto.class);
        if (element == null || element.getChildren() == null) {
            tree = Collections.emptyList();
        } else {
            List children = element.getChildren();
            tree = new ArrayList<RepositoryFileTreeDto>(children.size());
            for (RepositoryFileTreeDto child : children) {
                RepositoryFileTreeDtoProxy dto = new RepositoryFileTreeDtoProxy(child, this.client, this.baseUrl);
                tree.add(dto);
            }
        }
        return tree;
    }

    public RepositoryFileDto getFile() {
        return this.dto.getFile();
    }

    public void setFile(RepositoryFileDto file) {
        this.dto.setFile(file);
    }

    public void setChildren(List<RepositoryFileTreeDto> children) {
        this.dto.setChildren(children);
    }

    public RepositoryFileTreeDto getRealObject() {
        return this.dto;
    }
}

