/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPListParseEngine;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sqoop.mapreduce.db.DBConfiguration;
import org.apache.sqoop.mapreduce.mainframe.MainframeDatasetPath;

public final class MainframeFTPClientUtils {
    private static final Log LOG = LogFactory.getLog((String)MainframeFTPClientUtils.class.getName());
    private static FTPClient mockFTPClient = null;

    private MainframeFTPClientUtils() {
    }

    public static List<String> listSequentialDatasets(String pdsName, Configuration conf) throws IOException {
        ArrayList<String> datasets = new ArrayList<String>();
        String dsName = pdsName;
        String fileName = "";
        MainframeDatasetPath p = null;
        try {
            p = new MainframeDatasetPath(dsName, conf);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
            LOG.error((Object)"MainframeDatasetPath helper class incorrectly initialised");
            e.printStackTrace();
        }
        String dsType = conf.get("mapreduce.mainframe.input.dataset.type");
        boolean isTape = Boolean.parseBoolean(conf.get("mainframe.input.dataset.tape"));
        boolean isSequentialDs = false;
        boolean isGDG = false;
        if (dsType != null && p != null) {
            isSequentialDs = p.getMainframeDatasetType().toString().equals("s");
            isGDG = p.getMainframeDatasetType().toString().equals("g");
            pdsName = p.getMainframeDatasetFolder();
            fileName = p.getMainframeDatasetFileName();
        }
        FTPClient ftp = null;
        try {
            ftp = MainframeFTPClientUtils.getFTPConnection(conf);
            if (ftp != null) {
                ftp.changeWorkingDirectory("'" + pdsName + "'");
                FTPFile[] ftpFiles = null;
                if (isTape) {
                    FTPListParseEngine parser = ftp.initiateListParsing("org.apache.sqoop.mapreduce.mainframe.MainframeFTPFileEntryParser", "");
                    ArrayList<FTPFile> listing = new ArrayList<FTPFile>();
                    while (parser.hasNext()) {
                        FTPFile[] files;
                        for (FTPFile file : files = parser.getNext(25)) {
                            if (file == null) continue;
                            listing.add(file);
                            LOG.info((Object)String.format("Name: %s Type: %s", file.getName(), file.getType()));
                        }
                        ftpFiles = new FTPFile[listing.size()];
                        for (int i = 0; i < listing.size(); ++i) {
                            ftpFiles[i] = (FTPFile)listing.get(i);
                        }
                        LOG.info((Object)"Files returned from mainframe parser:-");
                        for (FTPFile f : ftpFiles) {
                            LOG.info((Object)String.format("Name: %s, Type: %s", f.getName(), f.getType()));
                        }
                    }
                } else {
                    ftpFiles = ftp.listFiles();
                }
                if (!isGDG) {
                    for (FTPFile f : ftpFiles) {
                        LOG.info((Object)String.format("Name: %s Type: %s", f.getName(), f.getType()));
                        if (f.getType() != 0 || isSequentialDs && (!isSequentialDs || !f.getName().equals(fileName) || fileName.equals(""))) continue;
                        datasets.add(f.getName());
                    }
                } else {
                    LOG.info((Object)"GDG branch. File list:-");
                    for (FTPFile f : ftpFiles) {
                        LOG.info((Object)String.format("Name: %s Type: %s", f.getName(), f.getType()));
                    }
                    if (ftpFiles.length > 0 && ftpFiles[ftpFiles.length - 1].getType() == 0) {
                        datasets.add(ftpFiles[ftpFiles.length - 1].getName());
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new IOException("Could not list datasets from " + pdsName + ":" + ioe.toString());
        }
        finally {
            if (ftp != null) {
                MainframeFTPClientUtils.closeFTPConnection(ftp);
            }
        }
        return datasets;
    }

    public static FTPClient getFTPConnection(Configuration conf) throws IOException {
        FTPClient ftp = null;
        try {
            String connectString;
            String password;
            String username = conf.get("mapreduce.jdbc.username");
            if (username == null) {
                username = "anonymous";
                password = "";
            } else {
                password = DBConfiguration.getPassword((JobConf)conf);
            }
            String server = connectString = conf.get("mapreduce.jdbc.url");
            int port = 0;
            String[] parts = connectString.split(":");
            if (parts.length == 2) {
                server = parts[0];
                try {
                    port = Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)("Invalid port number: " + e.toString()));
                }
            }
            ftp = null != mockFTPClient ? mockFTPClient : new FTPClient();
            FTPClientConfig config = new FTPClientConfig("MVS");
            ftp.configure(config);
            if (conf.getBoolean("sqoop.verbose", false)) {
                ftp.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out), true));
            }
            try {
                if (port > 0) {
                    ftp.connect(server, port);
                } else {
                    ftp.connect(server);
                }
            }
            catch (IOException ioexp) {
                throw new IOException("Could not connect to server " + server, ioexp);
            }
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                throw new IOException("FTP server " + server + " refused connection:" + ftp.getReplyString());
            }
            LOG.info((Object)("Connected to " + server + " on " + (port > 0 ? port : ftp.getDefaultPort())));
            if (!ftp.login(username, password)) {
                ftp.logout();
                throw new IOException("Could not login to server " + server + ":" + ftp.getReplyString());
            }
            ftp.setFileType(0);
            ftp.enterLocalPassiveMode();
            LOG.info((Object)("System type detected: " + ftp.getSystemType()));
        }
        catch (IOException ioe) {
            if (ftp != null && ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ftp = null;
            throw ioe;
        }
        return ftp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean closeFTPConnection(FTPClient ftp) {
        boolean success = true;
        try {
            ftp.noop();
            ftp.logout();
        }
        catch (FTPConnectionClosedException e) {
            success = false;
            LOG.warn((Object)("Server closed connection: " + e.toString()));
        }
        catch (IOException e) {
            success = false;
            LOG.warn((Object)("Server closed connection: " + e.toString()));
        }
        finally {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException f) {
                    success = false;
                }
            }
        }
        return success;
    }

    public static void setMockFTPClient(FTPClient FTPClient2) {
        mockFTPClient = FTPClient2;
    }
}

