/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.util.password;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sqoop.util.password.FilePasswordLoader;

public class CryptoFileLoader
extends FilePasswordLoader {
    private static String PROPERTY_CRYPTO_ALG = "org.apache.sqoop.credentials.loader.crypto.alg";
    private static String PROPERTY_CRYPTO_SALT = "org.apache.sqoop.credentials.loader.crypto.salt";
    private static String PROPERTY_CRYPTO_ITERATIONS = "org.apache.sqoop.credentials.loader.crypto.iterations";
    private static String PROPERTY_CRYPTO_KEY_LEN = "org.apache.sqoop.credentials.loader.crypto.salt.key.len";
    private static String PROPERTY_CRYPTO_PASSPHRASE = "org.apache.sqoop.credentials.loader.crypto.passphrase";
    private static String DEFAULT_ALG = "AES/ECB/PKCS5Padding";
    private static String DEFAULT_SALT = "SALT";
    private static int DEFAULT_ITERATIONS = 10000;
    private static int DEFAULT_KEY_LEN = 128;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String loadPassword(String p, Configuration configuration) throws IOException {
        byte[] decryptedBytes;
        byte[] encrypted;
        LOG.debug((Object)("Fetching password from specified path: " + p));
        Path path = new Path(p);
        try (FileSystem fs = path.getFileSystem(configuration);){
            this.verifyPath(fs, path);
            encrypted = this.readBytes(fs, path);
        }
        String passPhrase = configuration.get(PROPERTY_CRYPTO_PASSPHRASE);
        if (passPhrase == null) {
            throw new IOException("Passphrase is missing in property " + PROPERTY_CRYPTO_PASSPHRASE);
        }
        String alg = configuration.get(PROPERTY_CRYPTO_ALG, DEFAULT_ALG);
        String algOnly = alg.split("/")[0];
        String salt = configuration.get(PROPERTY_CRYPTO_SALT, DEFAULT_SALT);
        int iterations = configuration.getInt(PROPERTY_CRYPTO_ITERATIONS, DEFAULT_ITERATIONS);
        int keyLen = configuration.getInt(PROPERTY_CRYPTO_KEY_LEN, DEFAULT_KEY_LEN);
        SecretKeyFactory factory = null;
        try {
            factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Can't load SecretKeyFactory", e);
        }
        SecretKeySpec key = null;
        try {
            key = new SecretKeySpec(factory.generateSecret(new PBEKeySpec(passPhrase.toCharArray(), salt.getBytes(), iterations, keyLen)).getEncoded(), algOnly);
        }
        catch (Exception e) {
            throw new IOException("Can't generate secret key", e);
        }
        Cipher crypto = null;
        try {
            crypto = Cipher.getInstance(alg);
        }
        catch (Exception e) {
            throw new IOException("Can't initialize the decryptor", e);
        }
        try {
            crypto.init(2, key);
            decryptedBytes = crypto.doFinal(encrypted);
        }
        catch (Exception e) {
            throw new IOException("Can't decrypt the password", e);
        }
        return new String(decryptedBytes);
    }

    @Override
    public void cleanUpConfiguration(Configuration configuration) {
        configuration.set(PROPERTY_CRYPTO_PASSPHRASE, "REMOVED");
        configuration.set(PROPERTY_CRYPTO_SALT, DEFAULT_SALT);
        configuration.setInt(PROPERTY_CRYPTO_KEY_LEN, DEFAULT_KEY_LEN);
        configuration.setInt(PROPERTY_CRYPTO_ITERATIONS, DEFAULT_ITERATIONS);
    }
}

