/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.fileinstall.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.apache.felix.fileinstall.ArtifactListener;
import org.apache.felix.fileinstall.ArtifactTransformer;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;
import org.apache.felix.fileinstall.internal.BundleTransformer;
import org.apache.felix.fileinstall.internal.ConfigInstaller;
import org.apache.felix.fileinstall.internal.DirectoryWatcher;
import org.apache.felix.fileinstall.internal.JarDirUrlHandler;
import org.apache.felix.fileinstall.internal.Util;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInstall
implements BundleActivator,
ServiceTrackerCustomizer {
    Runnable cmSupport;
    final Map<ServiceReference, ArtifactListener> listeners = new TreeMap<ServiceReference, ArtifactListener>();
    final BundleTransformer bundleTransformer = new BundleTransformer();
    BundleContext context;
    final Map<String, DirectoryWatcher> watchers = new HashMap<String, DirectoryWatcher>();
    ServiceTracker listenersTracker;
    final ReadWriteLock lock = new ReentrantReadWriteLock();
    ServiceRegistration urlHandlerRegistration;
    volatile boolean stopped;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.lock.writeLock().lock();
        try {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("url.handler.protocol", "jardir");
            this.urlHandlerRegistration = context.registerService(URLStreamHandlerService.class.getName(), (Object)new JarDirUrlHandler(), props);
            String flt = "(|(objectClass=" + ArtifactInstaller.class.getName() + ")" + "(" + "objectClass" + "=" + ArtifactTransformer.class.getName() + ")" + "(" + "objectClass" + "=" + ArtifactUrlTransformer.class.getName() + "))";
            this.listenersTracker = new ServiceTracker(context, FrameworkUtil.createFilter((String)flt), (ServiceTrackerCustomizer)this);
            this.listenersTracker.open();
            try {
                this.cmSupport = new ConfigAdminSupport(context, this);
            }
            catch (NoClassDefFoundError e) {
                Util.log(context, 4, "ConfigAdmin is not available, some features will be disabled", e);
            }
            Hashtable<String, String> ht = new Hashtable<String, String>();
            this.set(ht, "felix.fileinstall.poll");
            this.set(ht, "felix.fileinstall.dir");
            this.set(ht, "felix.fileinstall.log.level");
            this.set(ht, "felix.fileinstall.filter");
            this.set(ht, "felix.fileinstall.tmpdir");
            this.set(ht, "felix.fileinstall.bundles.new.start");
            this.set(ht, "felix.fileinstall.bundles.startTransient");
            this.set(ht, "felix.fileinstall.noInitialDelay");
            this.set(ht, "felix.fileinstall.start.level");
            String dirs = ht.get("felix.fileinstall.dir");
            if (dirs != null && dirs.indexOf(44) != -1) {
                StringTokenizer st = new StringTokenizer(dirs, ",");
                int index = 0;
                while (st.hasMoreTokens()) {
                    String dir = st.nextToken().trim();
                    ht.put("felix.fileinstall.dir", dir);
                    String name = "initial";
                    if (index > 0) {
                        name = name + index;
                    }
                    this.updated(name, new Hashtable<String, String>(ht));
                    ++index;
                }
            } else {
                this.updated("initial", ht);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Object addingService(ServiceReference serviceReference) {
        ArtifactListener listener = (ArtifactListener)this.context.getService(serviceReference);
        this.addListener(serviceReference, listener);
        return listener;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.removeListener(reference, (ArtifactListener)service);
        this.addListener(reference, (ArtifactListener)service);
    }

    public void removedService(ServiceReference serviceReference, Object service) {
        this.removeListener(serviceReference, (ArtifactListener)service);
    }

    private void set(Hashtable<String, String> ht, String key) {
        String o = this.context.getProperty(key);
        if (o == null && (o = System.getProperty(key.toUpperCase().replace('.', '_'))) == null) {
            return;
        }
        ht.put(key, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        this.lock.writeLock().lock();
        try {
            this.urlHandlerRegistration.unregister();
            ArrayList<DirectoryWatcher> toClose = new ArrayList<DirectoryWatcher>();
            Map<String, DirectoryWatcher> map = this.watchers;
            synchronized (map) {
                toClose.addAll(this.watchers.values());
                this.watchers.clear();
            }
            for (DirectoryWatcher aToClose : toClose) {
                try {
                    aToClose.close();
                }
                catch (Exception e) {}
            }
            if (this.listenersTracker != null) {
                this.listenersTracker.close();
            }
            if (this.cmSupport != null) {
                this.cmSupport.run();
            }
        }
        finally {
            this.stopped = true;
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleted(String pid) {
        DirectoryWatcher watcher;
        Map<String, DirectoryWatcher> map = this.watchers;
        synchronized (map) {
            watcher = this.watchers.remove(pid);
        }
        if (watcher != null) {
            watcher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(String pid, Map<String, String> properties) {
        DirectoryWatcher watcher;
        InterpolationHelper.performSubstitution(properties, this.context);
        Map<String, DirectoryWatcher> map = this.watchers;
        synchronized (map) {
            watcher = this.watchers.get(pid);
            if (watcher != null && watcher.getProperties().equals(properties)) {
                return;
            }
        }
        if (watcher != null) {
            watcher.close();
        }
        watcher = new DirectoryWatcher(this, properties, this.context);
        watcher.setDaemon(true);
        map = this.watchers;
        synchronized (map) {
            this.watchers.put(pid, watcher);
        }
        watcher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateChecksum(File file) {
        ArrayList<DirectoryWatcher> toUpdate = new ArrayList<DirectoryWatcher>();
        Map<String, DirectoryWatcher> map = this.watchers;
        synchronized (map) {
            toUpdate.addAll(this.watchers.values());
        }
        for (DirectoryWatcher watcher : toUpdate) {
            watcher.scanner.updateChecksum(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListener(ServiceReference reference, ArtifactListener listener) {
        Map<ServiceReference, ArtifactListener> map = this.listeners;
        synchronized (map) {
            this.listeners.put(reference, listener);
        }
        long currentStamp = reference.getBundle().getLastModified();
        ArrayList<DirectoryWatcher> toNotify = new ArrayList<DirectoryWatcher>();
        Map<String, DirectoryWatcher> map2 = this.watchers;
        synchronized (map2) {
            toNotify.addAll(this.watchers.values());
        }
        for (DirectoryWatcher dir : toNotify) {
            dir.addListener(listener, currentStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListener(ServiceReference reference, ArtifactListener listener) {
        Map<ServiceReference, ArtifactListener> map = this.listeners;
        synchronized (map) {
            this.listeners.remove(reference);
        }
        ArrayList<DirectoryWatcher> toNotify = new ArrayList<DirectoryWatcher>();
        Map<String, DirectoryWatcher> map2 = this.watchers;
        synchronized (map2) {
            toNotify.addAll(this.watchers.values());
        }
        for (DirectoryWatcher dir : toNotify) {
            dir.removeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ArtifactListener> getListeners() {
        Map<ServiceReference, ArtifactListener> map = this.listeners;
        synchronized (map) {
            ArrayList<ArtifactListener> l = new ArrayList<ArtifactListener>(this.listeners.values());
            Collections.reverse(l);
            l.add(this.bundleTransformer);
            return l;
        }
    }

    static void refresh(BundleContext context, Collection<Bundle> bundles) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        FrameworkWiring wiring = (FrameworkWiring)context.getBundle(0L).adapt(FrameworkWiring.class);
        wiring.refreshBundles(bundles, new FrameworkListener[]{new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                latch.countDown();
            }
        }});
        latch.await();
    }

    private class ConfigAdminSupport
    implements Runnable {
        private Tracker tracker;
        private ServiceRegistration registration;

        private ConfigAdminSupport(BundleContext context, FileInstall fileInstall2) {
            this.tracker = new Tracker(context, fileInstall2);
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("service.pid", this.tracker.getName());
            this.registration = context.registerService(ManagedServiceFactory.class.getName(), (Object)this.tracker, props);
            this.tracker.open();
        }

        public void run() {
            this.tracker.close();
            this.registration.unregister();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class Tracker
        extends ServiceTracker<ConfigurationAdmin, ConfigurationAdmin>
        implements ManagedServiceFactory {
            private final FileInstall fileInstall;
            private final Set<String> configs;
            private final Map<Long, ConfigInstaller> configInstallers;

            private Tracker(BundleContext bundleContext, FileInstall fileInstall) {
                super(bundleContext, ConfigurationAdmin.class.getName(), null);
                this.configs = Collections.synchronizedSet(new HashSet());
                this.configInstallers = new HashMap<Long, ConfigInstaller>();
                this.fileInstall = fileInstall;
            }

            public String getName() {
                return "org.apache.felix.fileinstall";
            }

            public void updated(String s, Dictionary<String, ?> dictionary) throws ConfigurationException {
                this.configs.add(s);
                HashMap<String, String> props = new HashMap<String, String>();
                Enumeration<String> e = dictionary.keys();
                while (e.hasMoreElements()) {
                    String k = e.nextElement();
                    props.put(k, dictionary.get(k).toString());
                }
                this.fileInstall.updated(s, props);
            }

            public void deleted(String s) {
                this.configs.remove(s);
                this.fileInstall.deleted(s);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ConfigurationAdmin addingService(ServiceReference<ConfigurationAdmin> serviceReference) {
                FileInstall.this.lock.writeLock().lock();
                try {
                    if (FileInstall.this.stopped) {
                        ConfigurationAdmin configurationAdmin = null;
                        return configurationAdmin;
                    }
                    ConfigurationAdmin cm = (ConfigurationAdmin)super.addingService(serviceReference);
                    long id = (Long)serviceReference.getProperty("service.id");
                    ConfigInstaller configInstaller = new ConfigInstaller(this.context, cm, this.fileInstall);
                    configInstaller.init();
                    this.configInstallers.put(id, configInstaller);
                    ConfigurationAdmin configurationAdmin = cm;
                    return configurationAdmin;
                }
                finally {
                    FileInstall.this.lock.writeLock().unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removedService(ServiceReference<ConfigurationAdmin> serviceReference, ConfigurationAdmin o) {
                FileInstall.this.lock.writeLock().lock();
                try {
                    if (FileInstall.this.stopped) {
                        return;
                    }
                    Iterator<String> iterator = this.configs.iterator();
                    while (iterator.hasNext()) {
                        String s = iterator.next();
                        this.fileInstall.deleted(s);
                        iterator.remove();
                    }
                    long id = (Long)serviceReference.getProperty("service.id");
                    ConfigInstaller configInstaller = this.configInstallers.remove(id);
                    if (configInstaller != null) {
                        configInstaller.destroy();
                    }
                    super.removedService(serviceReference, (Object)o);
                }
                finally {
                    FileInstall.this.lock.writeLock().unlock();
                }
            }
        }
    }
}

