/*
 * Decompiled with CFR 0.152.
 */
package org.ftp4che.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.ftp4che.exception.ProxyConnectionException;
import org.ftp4che.proxy.Proxy;

public class Socks4
implements Proxy {
    static final int PROTOCOL_VERSION = 4;
    static final int DEFAULT_PORT = 1080;
    static final int DEFAULT_TIMEOUT = 20000;
    static final int CONNECT = 1;
    static final int BIND = 2;
    static final int REQUEST_OK = 90;
    static final int REQUEST_REJECTED_OR_FAILED = 91;
    static final int IDENTD_CONNECT_FAILED = 92;
    static final int DIFFERENT_UIDS_GIVEN = 93;
    public static final Logger log = Logger.getLogger((String)Socks4.class.getName());
    private String host;
    private String user;
    private int port = 1080;
    private int primaryConnectionPort;
    private int timeout = 20000;
    private Socket socket = null;
    private InetSocketAddress bindAddress;

    public Socks4(String proxyHost, String proxyUser) {
        this(proxyHost, -1, -1, proxyUser);
    }

    public Socks4(String proxyHost, int proxyPort, String proxyUser) {
        this(proxyHost, proxyPort, -1, proxyUser);
    }

    public Socks4(String proxyHost, int proxyPort, int timeout, String proxyUser) {
        this.setHost(proxyHost);
        this.setPort(proxyPort);
        this.setUser(proxyUser);
        this.setTimeout(timeout);
    }

    private void connectToProxy() throws IOException {
        this.socket = new Socket();
        this.socket.setSoTimeout(this.getTimeout());
        this.socket.connect(new InetSocketAddress(InetAddress.getByName(this.getHost()), this.getPort()), this.getTimeout());
    }

    public Socket connect(String host, int port) throws ProxyConnectionException {
        this.setPrimaryConnectionPort(port);
        InetSocketAddress isa = null;
        try {
            isa = new InetSocketAddress(InetAddress.getByName(host), port);
        }
        catch (IOException ioe) {
            throw new ProxyConnectionException(-2, "SOCK4 - IOException: " + ioe.getMessage());
        }
        InetAddress addr = isa.getAddress();
        byte[] hostbytes = addr.getAddress();
        byte[] requestPacket = new byte[300];
        requestPacket[0] = 4;
        requestPacket[1] = 1;
        requestPacket[2] = new Integer((port & 0xFF00) >> 8).byteValue();
        requestPacket[3] = new Integer(port & 0xFF).byteValue();
        System.arraycopy(hostbytes, 0, requestPacket, 4, 4);
        System.arraycopy(this.getUser().getBytes(), 0, requestPacket, 8, this.getUser().getBytes().length);
        requestPacket[9 + this.getUser().length()] = 0;
        byte[] response = new byte[8];
        OutputStream out = null;
        InputStream in = null;
        try {
            this.connectToProxy();
            out = this.socket.getOutputStream();
            in = this.socket.getInputStream();
            out.write(requestPacket, 0, 9 + this.getUser().getBytes().length);
            in.read(response, 0, 8);
        }
        catch (IOException ioe) {
            throw new ProxyConnectionException(-2, "SOCK4 - IOException: " + ioe.getMessage());
        }
        if (response[0] != 0 && response[0] != 4) {
            throw new ProxyConnectionException(-3, "SOCKS4 wrong protocol version reply");
        }
        ProxyConnectionException pce = null;
        switch (response[1]) {
            case 90: {
                break;
            }
            case 91: {
                pce = new ProxyConnectionException(91, "SOCKS4 request rejected or failed");
                break;
            }
            case 92: {
                pce = new ProxyConnectionException(92, "SOCKS4 request rejected becasue SOCKS server cannot connect to identd on the client");
                break;
            }
            case 93: {
                pce = new ProxyConnectionException(93, "SOCKS4 request rejected because the client program and identd report different user-ids.");
                break;
            }
            default: {
                pce = new ProxyConnectionException(-1, "SOCKS4 unknown proxy response");
            }
        }
        if (pce != null) {
            try {
                out.close();
                in.close();
                this.socket.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw pce;
        }
        return this.socket;
    }

    public Socket bind(InetSocketAddress isa) throws IOException {
        InetAddress addr = isa.getAddress();
        byte[] hostbytes = addr.getAddress();
        byte[] requestPacket = new byte[300];
        requestPacket[0] = 4;
        requestPacket[1] = 2;
        requestPacket[2] = (byte)(this.getPrimaryConnectionPort() >> 8);
        requestPacket[3] = (byte)(this.getPrimaryConnectionPort() & 0xFF);
        System.arraycopy(hostbytes, 0, requestPacket, 4, 4);
        System.arraycopy(this.getUser().getBytes(), 0, requestPacket, 8, this.getUser().getBytes().length);
        requestPacket[9 + this.getUser().getBytes().length] = 0;
        byte[] response = new byte[8];
        OutputStream out = null;
        InputStream in = null;
        try {
            this.connectToProxy();
            out = this.socket.getOutputStream();
            in = this.socket.getInputStream();
            out.write(requestPacket, 0, 9 + this.getUser().getBytes().length);
            in.read(response, 0, 8);
        }
        catch (IOException ioe) {
            throw new ProxyConnectionException(-2, "SOCK4 - IOException: " + ioe.getMessage());
        }
        if (response[0] != 0 && response[0] != 4) {
            throw new ProxyConnectionException(-3, "SOCKS4 wrong protocol version reply");
        }
        ProxyConnectionException pce = null;
        switch (response[1]) {
            case 90: {
                break;
            }
            case 91: {
                pce = new ProxyConnectionException(91, "SOCKS4 request rejected or failed");
                break;
            }
            case 92: {
                pce = new ProxyConnectionException(92, "SOCKS4 request rejected becasue SOCKS server cannot connect to identd on the client");
                break;
            }
            case 93: {
                pce = new ProxyConnectionException(93, "SOCKS4 request rejected because the client program and identd report different user-ids.");
                break;
            }
            default: {
                pce = new ProxyConnectionException(-1, "SOCKS4 unknown proxy response");
            }
        }
        if (pce != null) {
            try {
                out.close();
                in.close();
                this.socket.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw pce;
        }
        int aPort = response[2];
        int bPort = response[3];
        aPort = aPort < 0 ? aPort + 256 : aPort;
        bPort = bPort < 0 ? bPort + 256 : bPort;
        int bindPort = (aPort << 8) + bPort;
        byte[] bindAddr = new byte[]{response[4], response[5], response[6], response[7]};
        this.bindAddress = new InetSocketAddress(InetAddress.getByAddress(bindAddr), bindPort);
        return this.socket;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port > 0 ? port : 1080;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public int getPrimaryConnectionPort() {
        return this.primaryConnectionPort;
    }

    public void setPrimaryConnectionPort(int primaryConnectionPort) {
        this.primaryConnectionPort = primaryConnectionPort;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout > 0 ? timeout : 20000;
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public InetSocketAddress getProxyAddress() {
        return new InetSocketAddress(this.getHost(), this.getPort());
    }
}

