/*
 * Decompiled with CFR 0.152.
 */
package org.ftp4che.reply;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.ftp4che.exception.FtpFileNotFoundException;
import org.ftp4che.exception.FtpIOException;
import org.ftp4che.exception.FtpWorkflowException;
import org.ftp4che.exception.NotConnectedException;
import org.ftp4che.reply.ReplyCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reply {
    List<String> lines = new ArrayList<String>();
    Logger log = Logger.getLogger((String)Reply.class.getName());

    public Reply() {
    }

    public Reply(List<String> lines) {
        this.setLines(lines);
    }

    public List<String> getLines() {
        return this.lines;
    }

    public void setLines(List<String> lines) {
        this.lines = new ArrayList<String>(lines);
    }

    public void dumpReply() {
        for (String line : this.lines) {
            this.log.info((Object)line.substring(0, line.length() - 1));
        }
    }

    public String getReplyCode() {
        return this.getLines().get(this.getLines().size() - 1).substring(0, 3);
    }

    public String getReplyMessage() {
        return this.getLines().get(this.getLines().size() - 1).substring(4);
    }

    public void validate() throws FtpWorkflowException, FtpIOException {
        if (this.getLines().size() <= 0) {
            throw new FtpIOException("000", "Did not receive any reply!");
        }
        if (ReplyCode.isPermanentNegativeCompletionReply(this)) {
            if (this.getReplyCode().intern() == "530".intern()) {
                throw new NotConnectedException(this.getReplyMessage());
            }
            if (this.getReplyCode().intern() == "550".intern()) {
                throw new FtpFileNotFoundException(this.getReplyMessage());
            }
            throw new FtpWorkflowException(this.getReplyCode(), this.getReplyMessage());
        }
        if (ReplyCode.isTransientNegativeCompletionReply(this)) {
            throw new FtpIOException(this.getReplyCode(), this.getReplyMessage());
        }
    }
}

