/*
 * Decompiled with CFR 0.152.
 */
package org.ftp4che.util.ftpfile;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class FTPFile
implements Comparable {
    public static final int UNKNOWN = -1;
    public static final int UNIX = 0;
    public static final int WINDOWS = 1;
    public static final int VMS = 2;
    public static final int NETWARE = 3;
    private int fileType;
    private String transferType = "TYPE I";
    private static final SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy HH:mm");
    protected boolean isLink = false;
    protected int linkCount = 1;
    protected String mode;
    protected boolean directory = false;
    protected long size = -1L;
    protected String name;
    protected String path;
    protected String linkedname;
    protected String owner;
    protected String group;
    protected Date date;
    protected String serverString;

    public FTPFile(String path, String name, boolean directory) {
        this.name = name;
        this.path = path;
        this.directory = directory;
    }

    public FTPFile(String path, String name) {
        this(path, name, false);
    }

    public FTPFile(String path, boolean directory) {
        StringTokenizer st = new StringTokenizer(path, "/");
        int count = st.countTokens();
        this.path = "/";
        for (int i = 0; i < count - 1; ++i) {
            this.path = this.path + st.nextToken() + "/";
        }
        this.name = st.nextToken();
        this.directory = directory;
    }

    public FTPFile(File file) {
        this.name = file.getName();
        this.setPath(file.getParent());
        this.size = file.length();
        String mode = "";
        if (file.isFile()) {
            mode = mode + "-";
        } else {
            mode = mode + "d";
            this.setDirectory(true);
        }
        mode = file.canRead() ? mode + "r" : mode + "-";
        mode = file.canWrite() ? mode + "w" : mode + "-";
        this.setMode(mode);
    }

    public FTPFile(int type, String path, String name, String serverString) {
        this.fileType = type;
        this.serverString = serverString;
        this.name = name;
        this.path = path;
    }

    public int getFileType() {
        return this.fileType;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public Date getDate() {
        return this.date;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getServerString() {
        return this.serverString;
    }

    public long size() {
        return this.size;
    }

    public String getMode() {
        return this.mode;
    }

    public boolean isLink() {
        return this.isLink;
    }

    public int getLinkCount() {
        return this.linkCount;
    }

    public String getLinkedname() {
        return this.linkedname;
    }

    void setGroup(String group) {
        this.group = group;
    }

    void setDirectory(boolean directory) {
        this.directory = directory;
    }

    void setLink(boolean isLink) {
        this.isLink = isLink;
    }

    void setLinkedName(String linkedname) {
        this.linkedname = linkedname;
    }

    void setOwner(String owner) {
        this.owner = owner;
    }

    void setMode(String mode) {
        this.mode = mode;
    }

    public void setLinkCount(int linkCount) {
        this.linkCount = linkCount;
    }

    public String toString() {
        if (this.path != null && this.path.length() > 0) {
            if (this.path.charAt(this.path.length() - 1) == '/') {
                return this.path + this.name;
            }
            return this.path + "/" + this.name;
        }
        return this.name;
    }

    public int compareTo(Object o) {
        FTPFile to = (FTPFile)o;
        if (this.isDirectory() && to.isDirectory()) {
            return this.getName().compareTo(to.getName());
        }
        if (this.isDirectory() && to.isDirectory()) {
            return this.getName().compareTo(to.getName());
        }
        if (this.isDirectory()) {
            return 1;
        }
        return 0;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTransferType() {
        return this.transferType;
    }

    public void setTransferType(String transferType) {
        this.transferType = transferType;
    }

    public File getFile() {
        return new File(this.getPath(), this.getName());
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setDate(Date date) {
        this.date = date;
    }
}

