/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.deployer.kar;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.apache.karaf.kar.KarService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarArtifactInstaller
implements ArtifactInstaller {
    public static final String FEATURE_CLASSIFIER = "features";
    private static final Logger LOGGER = LoggerFactory.getLogger(KarArtifactInstaller.class);
    private static final String KAR_SUFFIX = ".kar";
    private static final String ZIP_SUFFIX = ".zip";
    private KarService karService;

    public void install(File file) throws Exception {
        if (this.karService.list().contains(file.getName())) {
            LOGGER.info("KAR {} is already installed. Please uninstall it first.", (Object)file.getName());
            return;
        }
        LOGGER.info("Installing KAR file {}", (Object)file);
        this.karService.install(file.toURI());
    }

    public void uninstall(File file) throws Exception {
        String karName = this.getKarName(file);
        LOGGER.info("Uninstalling KAR {}", (Object)karName);
        this.karService.uninstall(karName);
    }

    public void update(File file) throws Exception {
        LOGGER.warn("Karaf archive {}' has been updated; redeploying.", (Object)file);
        this.karService.uninstall(this.getKarName(file));
        this.karService.install(file.toURI());
    }

    private String getKarName(File karFile) {
        String karName = karFile.getName();
        karName = karName.substring(0, karName.lastIndexOf("."));
        return karName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canHandle(File file) {
        if (file.isFile() && file.getName().endsWith(KAR_SUFFIX)) {
            LOGGER.info("Found a .kar file to deploy.");
            return true;
        }
        if (file.isFile() && file.getName().endsWith(ZIP_SUFFIX)) {
            LOGGER.debug("Found a .zip file to deploy; checking contents to see if it's a Karaf archive.");
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(file);
                if (zipFile.getEntry("META-INF/KARAF.MF") != null) {
                    LOGGER.info("Found a Karaf archive with .zip prefix; will deploy.");
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                LOGGER.warn("Problem extracting zip file '{}'; ignoring.", (Object)file.getName(), (Object)e);
            }
            finally {
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("Problem closing zip file '{}'; ignoring.", (Object)file.getName(), (Object)e);
                }
            }
        }
        return false;
    }

    public KarService getKarService() {
        return this.karService;
    }

    public void setKarService(KarService karService) {
        this.karService = karService;
    }
}

