/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.platform.plugin.deployer.impl;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginFileHandler;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginHandlingException;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginMetadata;
import org.pentaho.osgi.platform.plugin.deployer.impl.ExceptionSettable;
import org.pentaho.osgi.platform.plugin.deployer.impl.ManifestUpdaterImpl;
import org.pentaho.osgi.platform.plugin.deployer.impl.PluginMetadataImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginZipFileProcessor {
    public static final String BLUEPRINT = "OSGI-INF/blueprint/blueprint.xml";
    public static final String PLUGIN_SPRING_XML_FILENAME = "plugin.spring.xml";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<PluginFileHandler> pluginFileHandlers;
    private final String name;
    private final String symbolicName;
    private final String version;
    private boolean isPluginProcessedBefore;

    public PluginZipFileProcessor(List<PluginFileHandler> pluginFileHandlers, boolean isPluginProcessedBefore, String name, String symbolicName, String version) {
        this.pluginFileHandlers = pluginFileHandlers != null ? pluginFileHandlers : new ArrayList();
        this.name = name;
        this.symbolicName = symbolicName;
        this.version = version;
        this.isPluginProcessedBefore = isPluginProcessedBefore;
    }

    public Future<Void> processBackground(ExecutorService executorService, Supplier<ZipInputStream> zipInputStreamProvider, ZipOutputStream zipOutputStream, ExceptionSettable<Throwable> exceptionSettable) {
        return executorService.submit(() -> {
            long elapsedTime = System.currentTimeMillis();
            this.logger.debug("Start processing zip plugin '{}'", (Object)this.name);
            try {
                if (this.isPluginProcessedBefore) {
                    this.logger.debug("Found bundle {} installed. Processing manifest instead", (Object)this.name);
                    this.processManifest(zipOutputStream);
                } else {
                    this.process(zipInputStreamProvider, zipOutputStream);
                }
            }
            catch (IOException e) {
                exceptionSettable.setException(e);
            }
            this.logger.debug("Finished processing zip plugin '{}'", (Object)this.name);
            this.logger.debug("Elapsed time in millis: {} ", (Object)(System.currentTimeMillis() - elapsedTime));
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Supplier<ZipInputStream> zipInputStreamProvider, ZipOutputStream zipOutputStream) throws IOException {
        File dir = Files.createTempDir();
        PluginMetadataImpl pluginMetadata = null;
        try {
            pluginMetadata = new PluginMetadataImpl(dir);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        Manifest manifest = null;
        ZipInputStream zipInputStream = zipInputStreamProvider.get();
        try {
            ZipEntry zipEntry;
            this.logger.debug("Processing plugin - Name: {} SymbolicName: {} Version: {}", new Object[]{this.name, this.symbolicName, this.version});
            byte[] pluginSpringXmlBytes = null;
            String pluginSpringXmlName = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String name = zipEntry.getName();
                byte[] bytes = this.getEntryBytes(zipInputStream);
                if (pluginSpringXmlBytes == null && name != null && name.endsWith(PLUGIN_SPRING_XML_FILENAME)) {
                    pluginSpringXmlBytes = bytes;
                    pluginSpringXmlName = name;
                    continue;
                }
                this.processEntry(zipOutputStream, pluginMetadata, zipEntry.isDirectory(), name, bytes);
            }
            if (pluginSpringXmlBytes != null) {
                this.processEntry(zipOutputStream, pluginMetadata, false, pluginSpringXmlName, pluginSpringXmlBytes);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)zipInputStream);
        }
        int tries = 100;
        File blueprintDir = new File(dir.getAbsolutePath() + "/" + BLUEPRINT.substring(0, BLUEPRINT.lastIndexOf(47)));
        while (!blueprintDir.exists() && tries-- > 0) {
            blueprintDir.mkdirs();
        }
        try (FileOutputStream blueprintOutputStream = null;){
            blueprintOutputStream = new FileOutputStream(dir.getAbsolutePath() + "/" + BLUEPRINT);
            pluginMetadata.writeBlueprint(this.name, blueprintOutputStream);
        }
        HashSet<String> createdEntries = new HashSet<String>();
        String manifestFolder = "META-INF/MANIFEST.MF".split("/")[0] + "/";
        ZipEntry manifestFolderEntry = new ZipEntry(manifestFolder);
        zipOutputStream.putNextEntry(manifestFolderEntry);
        zipOutputStream.closeEntry();
        createdEntries.add(manifestFolder);
        ZipEntry manifestEntry = new ZipEntry("META-INF/MANIFEST.MF");
        zipOutputStream.putNextEntry(manifestEntry);
        pluginMetadata.getManifestUpdater().write(manifest, zipOutputStream, this.name, this.symbolicName, this.version);
        zipOutputStream.closeEntry();
        createdEntries.add("META-INF/MANIFEST.MF");
        Stack<File> dirStack = new Stack<File>();
        dirStack.push(dir);
        int len = 0;
        byte[] buffer = new byte[1024];
        try {
            while (dirStack.size() > 0) {
                File[] dirFiles;
                File currentDir = (File)dirStack.pop();
                String dirName = currentDir.getAbsolutePath().substring(dir.getAbsolutePath().length()) + "/";
                if (dirName.startsWith("/") || dirName.startsWith("\\")) {
                    dirName = dirName.substring(1);
                }
                if (dirName.length() > 0 && !createdEntries.contains(dirName)) {
                    ZipEntry zipEntry = new ZipEntry(dirName.replaceAll(Pattern.quote("\\"), "/"));
                    zipOutputStream.putNextEntry(zipEntry);
                    zipOutputStream.closeEntry();
                }
                if ((dirFiles = currentDir.listFiles()) == null) continue;
                for (File childFile : dirFiles) {
                    if (childFile.isDirectory()) {
                        dirStack.push(childFile);
                        continue;
                    }
                    String fileName = childFile.getAbsolutePath().substring(dir.getAbsolutePath().length() + 1);
                    try (FileInputStream fileInputStream = null;){
                        fileInputStream = new FileInputStream(childFile);
                        ZipEntry childZipEntry = new ZipEntry(fileName.replaceAll(Pattern.quote("\\"), "/"));
                        zipOutputStream.putNextEntry(childZipEntry);
                        while ((len = fileInputStream.read(buffer)) != -1) {
                            zipOutputStream.write(buffer, 0, len);
                        }
                        zipOutputStream.closeEntry();
                    }
                }
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)zipOutputStream);
            this.recursiveDelete(dir);
        }
    }

    private void processEntry(ZipOutputStream zipOutputStream, PluginMetadata pluginMetadata, boolean isDirectory, String name, byte[] bytes) throws IOException {
        this.logger.trace("Processing zip entry: {} ", (Object)name);
        AtomicBoolean output = new AtomicBoolean(false);
        boolean wasHandled = false;
        for (PluginFileHandler pluginFileHandler : this.pluginFileHandlers) {
            if (!pluginFileHandler.handles(name)) continue;
            wasHandled = true;
            this.logger.trace("Plugin file handler {} will handle {}", (Object)pluginFileHandler.toString(), (Object)name);
            try {
                boolean handlerSaysOutput = pluginFileHandler.handle(name, bytes, pluginMetadata);
                this.logger.trace("Plugin file handler {} handled {}", (Object)pluginFileHandler.toString(), (Object)name);
                output.compareAndSet(false, handlerSaysOutput);
            }
            catch (PluginHandlingException e) {
                this.logger.error("Plugin file handler " + pluginFileHandler.toString() + " threw exception when handling " + name, (Throwable)e);
                throw new IOException(e);
            }
        }
        if (!wasHandled || output.get()) {
            zipOutputStream.putNextEntry(new ZipEntry(name));
            if (!isDirectory) {
                IOUtils.write((byte[])bytes, (OutputStream)zipOutputStream);
            }
            zipOutputStream.closeEntry();
        }
    }

    private byte[] getEntryBytes(ZipInputStream zipInputStream) throws IOException {
        return IOUtils.toByteArray((InputStream)zipInputStream);
    }

    public void processManifest(ZipOutputStream zipOutputStream) throws IOException {
        Manifest manifest = null;
        String manifestFolder = "META-INF/MANIFEST.MF".split("/")[0] + "/";
        ZipEntry manifestFolderEntry = new ZipEntry(manifestFolder);
        zipOutputStream.putNextEntry(manifestFolderEntry);
        zipOutputStream.closeEntry();
        ZipEntry manifestEntry = new ZipEntry("META-INF/MANIFEST.MF");
        zipOutputStream.putNextEntry(manifestEntry);
        new ManifestUpdaterImpl().write(manifest, zipOutputStream, this.name, this.symbolicName, this.version);
        zipOutputStream.closeEntry();
        zipOutputStream.flush();
        zipOutputStream.close();
    }

    private void recursiveDelete(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.recursiveDelete(child);
            }
        }
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }
}

