/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.platform.plugin.deployer.impl.handlers;

import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginFileHandler;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginHandlingException;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginMetadata;
import org.w3c.dom.Document;

public class BlueprintFileHandler
implements PluginFileHandler {
    public static final String JAR = ".jar";
    public static final String XML = ".xml";
    public static final String OSGI_INF_BLUEPRINT = "OSGI-INF/blueprint/";

    @Override
    public boolean handles(String fileName) {
        return fileName != null && fileName.contains(OSGI_INF_BLUEPRINT) && fileName.endsWith(XML);
    }

    @Override
    public boolean handle(String relativePath, byte[] file, PluginMetadata pluginMetadata) throws PluginHandlingException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            documentBuilderFactory.setNamespaceAware(true);
            Document blueprint = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(file));
            pluginMetadata.setBlueprint(blueprint);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

