/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.modules.factory.svg;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.apache.batik.gvt.GraphicsNode;

public class SVGDrawable {
    private GraphicsNode rootNode;
    private double width;
    private double height;

    public SVGDrawable(GraphicsNode rootNode) {
        if (rootNode == null) {
            throw new NullPointerException();
        }
        this.rootNode = rootNode;
        Rectangle2D bounds = rootNode.getBounds();
        if (bounds != null) {
            this.width = bounds.getWidth();
            this.height = bounds.getHeight();
        }
    }

    public Dimension getPreferredSize() {
        int w = (int)this.width;
        int h = (int)this.height;
        if (w == 0 || h == 0) {
            return null;
        }
        return new Dimension(w, h);
    }

    public boolean isPreserveAspectRatio() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics2D g, Rectangle2D area) {
        if (this.width == 0.0 || this.height == 0.0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.translate(-area.getX(), -area.getY());
            double sx = area.getWidth() / this.width;
            double sy = area.getHeight() / this.height;
            double sm = Math.min(sx, sy);
            g2.scale(sm, sm);
            this.rootNode.paint(g2);
        }
        finally {
            g2.dispose();
        }
    }
}

