/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.drilldown;

import java.awt.Component;
import javax.swing.SwingUtilities;
import org.pentaho.reporting.designer.core.auth.AuthenticationData;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.extensions.pentaho.drilldown.PentahoPathModel;
import org.pentaho.reporting.designer.extensions.pentaho.repository.Messages;
import org.pentaho.reporting.designer.extensions.pentaho.repository.actions.AuthenticatedServerTask;
import org.pentaho.reporting.designer.extensions.pentaho.repository.actions.SelectFileFromRepositoryTask;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;

public class SelectDrillTargetTask
implements AuthenticatedServerTask {
    private PentahoPathModel wrapper;
    private AuthenticationData loginData;
    private boolean storeUpdates;
    private SelectFileFromRepositoryTask selectFileFromRepositoryTask;
    private Component uiContext;
    private Runnable triggerRefreshParameterTask;
    private ReportDocumentContext activeContext;

    public SelectDrillTargetTask(PentahoPathModel wrapper, Component uiContext, Runnable triggerRefreshParameterTask, ReportDocumentContext activeContext) {
        this.uiContext = uiContext;
        this.triggerRefreshParameterTask = triggerRefreshParameterTask;
        this.activeContext = activeContext;
        this.selectFileFromRepositoryTask = new SelectFileFromRepositoryTask(uiContext);
        this.selectFileFromRepositoryTask.setFilters(wrapper.getExtensions());
        this.wrapper = wrapper;
    }

    @Override
    public void setLoginData(AuthenticationData loginData, boolean storeUpdates) {
        this.loginData = loginData;
        this.storeUpdates = storeUpdates;
    }

    @Override
    public void run() {
        try {
            String oldName = this.loginData.getOption("lastDrillFilename");
            String selectedReport = this.selectFileFromRepositoryTask.selectFile(this.loginData, oldName);
            if (selectedReport == null) {
                return;
            }
            this.loginData.setOption("lastDrillFilename", selectedReport);
            if (this.storeUpdates && this.activeContext != null) {
                this.activeContext.getAuthenticationStore().add(this.loginData, true);
            }
            this.wrapper.setLocalPath(selectedReport);
            this.wrapper.setLoginData(this.loginData);
            SwingUtilities.invokeLater(this.triggerRefreshParameterTask);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)this.uiContext, (String)Messages.getInstance().getString("LoadReportFromRepositoryAction.Error.Title"), (String)Messages.getInstance().formatMessage("LoadReportFromRepositoryAction.Error.Message", exception.getMessage()), (Exception)exception);
            UncaughtExceptionsModel.getInstance().addException((Throwable)exception);
        }
    }

    AuthenticationData getLoginData() {
        return this.loginData;
    }
}

