/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.drilldown.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownParameterTable;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownUi;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownUiException;
import org.pentaho.reporting.designer.core.editor.drilldown.basic.DrillDownModelWrapper;
import org.pentaho.reporting.designer.core.editor.drilldown.model.DrillDownModel;
import org.pentaho.reporting.designer.core.editor.drilldown.swing.TooltipAndTargetPanel;
import org.pentaho.reporting.designer.extensions.pentaho.drilldown.swing.SwingRemoteDrillDownController;
import org.pentaho.reporting.designer.extensions.pentaho.drilldown.swing.SwingRemoteDrillDownUiProfile;

public class SwingRemoteDrillDownUi
implements DrillDownUi {
    private HashMap<ComponentLookup, Component> componentMap;
    private SwingRemoteDrillDownController controller;
    private JPanel editor = this.createEditor();
    private JTextField serverUrlField;
    private JTextField pathField;
    private TooltipAndTargetPanel tatPanel;
    private DrillDownModelWrapper wrapper;
    private ReportDesignerContext reportDesignerContext;

    public SwingRemoteDrillDownUi() {
        this.initComponentMap();
    }

    private JPanel createEditor() {
        int layoutIndent = 2;
        JPanel editor = new JPanel();
        SpringLayout layout = new SpringLayout();
        editor.setLayout(layout);
        JCheckBox serverUrlCheckBox = this.createServerUrlCheckBox();
        editor.add(serverUrlCheckBox);
        layout.putConstraint("North", (Component)serverUrlCheckBox, 2, "North", (Component)editor);
        layout.putConstraint("East", (Component)serverUrlCheckBox, 2, "East", (Component)editor);
        layout.putConstraint("West", (Component)serverUrlCheckBox, 2, "West", (Component)editor);
        JLabel serverUrlLabel = this.createServerUrlLabel();
        editor.add(serverUrlLabel);
        layout.putConstraint("North", (Component)serverUrlLabel, 2, "South", (Component)serverUrlCheckBox);
        layout.putConstraint("East", (Component)serverUrlLabel, 2, "East", (Component)editor);
        layout.putConstraint("West", (Component)serverUrlLabel, 2, "West", (Component)editor);
        JButton loginButton = this.createLoginButton();
        editor.add(loginButton);
        layout.putConstraint("North", (Component)loginButton, 2, "South", (Component)serverUrlLabel);
        layout.putConstraint("East", (Component)loginButton, 0, "East", (Component)editor);
        this.serverUrlField = this.createServerUrlField();
        editor.add(this.serverUrlField);
        layout.putConstraint("North", (Component)this.serverUrlField, 2, "South", (Component)serverUrlLabel);
        layout.putConstraint("East", (Component)this.serverUrlField, -2, "West", (Component)loginButton);
        layout.putConstraint("South", (Component)this.serverUrlField, 0, "South", (Component)loginButton);
        layout.putConstraint("West", (Component)this.serverUrlField, 2, "West", (Component)editor);
        JLabel pathLabel = this.createPathLabel();
        editor.add(pathLabel);
        layout.putConstraint("North", (Component)pathLabel, 2, "South", (Component)this.serverUrlField);
        layout.putConstraint("East", (Component)pathLabel, 2, "East", (Component)editor);
        layout.putConstraint("West", (Component)pathLabel, 2, "West", (Component)editor);
        JButton browseButton = this.createBrowseButton();
        editor.add(browseButton);
        layout.putConstraint("North", (Component)browseButton, 2, "South", (Component)pathLabel);
        layout.putConstraint("East", (Component)browseButton, 0, "East", (Component)editor);
        this.pathField = this.createPathField();
        editor.add(this.pathField);
        layout.putConstraint("North", (Component)this.pathField, 2, "South", (Component)pathLabel);
        layout.putConstraint("East", (Component)this.pathField, -2, "West", (Component)browseButton);
        layout.putConstraint("South", (Component)this.pathField, 0, "South", (Component)browseButton);
        layout.putConstraint("West", (Component)this.pathField, 2, "West", (Component)editor);
        this.tatPanel = new TooltipAndTargetPanel();
        this.tatPanel.getTargetComboBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SwingRemoteDrillDownUi.this.getModel().setTargetFormula(e.getItem().toString());
            }
        });
        this.tatPanel.getTooltipPanel().addPropertyChangeListener("formula", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SwingRemoteDrillDownUi.this.getModel().setTooltipFormula(evt.getNewValue().toString());
            }
        });
        editor.add((Component)this.tatPanel);
        layout.putConstraint("North", (Component)this.tatPanel, 2, "South", (Component)this.pathField);
        layout.putConstraint("East", (Component)this.tatPanel, 0, "East", (Component)editor);
        layout.putConstraint("West", (Component)this.tatPanel, 2, "West", (Component)editor);
        DrillDownParameterTable table = this.createParameterTable();
        editor.add((Component)table);
        layout.putConstraint("North", (Component)table, 2, "South", (Component)this.tatPanel);
        layout.putConstraint("East", (Component)table, 2, "East", (Component)editor);
        layout.putConstraint("South", (Component)table, 2, "South", (Component)editor);
        layout.putConstraint("West", (Component)table, 2, "West", (Component)editor);
        return editor;
    }

    private JCheckBox createServerUrlCheckBox() {
        JCheckBox checkBox = new JCheckBox();
        checkBox.setName(ComponentLookup.SERVER_URL_CHECKBOX.name());
        checkBox.setText(Messages.getString((String)"DrillDownDialog.ServerUrlCheckBox.Text", (Object[])new Object[0]));
        return checkBox;
    }

    private JLabel createServerUrlLabel() {
        JLabel label = new JLabel();
        label.setText(Messages.getString((String)"DrillDownDialog.ServerUrlInput.Label", (Object[])new Object[0]));
        label.setMinimumSize(new Dimension(0, 20));
        return label;
    }

    private JButton createLoginButton() {
        JButton button = new JButton();
        button.setName(ComponentLookup.LOGIN_BUTTON.name());
        button.setText(Messages.getString((String)"DrillDownDialog.LoginButton.Text", (Object[])new Object[0]));
        return button;
    }

    private JTextField createServerUrlField() {
        JTextField field = new JTextField();
        field.setName(ComponentLookup.SERVER_URL_FIELD.name());
        return field;
    }

    private JLabel createPathLabel() {
        JLabel label = new JLabel();
        label.setText(Messages.getString((String)"DrillDownDialog.PathInput.Label", (Object[])new Object[0]));
        label.setMinimumSize(new Dimension(0, 20));
        return label;
    }

    private JButton createBrowseButton() {
        JButton button = new JButton();
        button.setName(ComponentLookup.BROWSE_BUTTON.name());
        button.setText(Messages.getString((String)"DrillDownDialog.BrowseButton.Text", (Object[])new Object[0]));
        return button;
    }

    private JTextField createPathField() {
        JTextField field = new JTextField();
        field.setName(ComponentLookup.PATH_FIELD.name());
        return field;
    }

    private DrillDownParameterTable createParameterTable() {
        DrillDownParameterTable table = new DrillDownParameterTable();
        table.setName(ComponentLookup.PARAMETER_TABLE.name());
        table.setShowRefreshButton(true);
        table.setAllowCustomParameter(true);
        return table;
    }

    private void initComponentMap() {
        this.componentMap = new HashMap();
        for (Component component : this.editor.getComponents()) {
            try {
                String name = component.getName();
                if (name == null) continue;
                ComponentLookup lookupName = ComponentLookup.valueOf(name);
                this.componentMap.put(lookupName, component);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public <C extends Component> C getComponent(ComponentLookup lookupName) {
        if (this.componentMap.containsKey((Object)lookupName)) {
            return (C)this.componentMap.get((Object)lookupName);
        }
        throw new IllegalStateException("Element " + (Object)((Object)lookupName) + " wasn't initialized properly");
    }

    public Component getEditorPanel() {
        return this.editor;
    }

    public DrillDownModel getModel() {
        return this.wrapper.getModel();
    }

    public void init(Component parent, ReportDesignerContext reportDesignerContext, DrillDownModel model, String[] extraFields) throws DrillDownUiException {
        this.reportDesignerContext = reportDesignerContext;
        this.wrapper = new DrillDownModelWrapper(model);
        model.setDrillDownConfig(SwingRemoteDrillDownUiProfile.NAME_DEFAULT);
        if (this.getModel().isLimitedEditor()) {
            this.tatPanel.hideContent();
        }
        if (this.getModel().getTooltipFormula() != null) {
            this.tatPanel.getTooltipPanel().setFormula(this.getModel().getTooltipFormula());
        }
        if (this.getModel().getTargetFormula() != null) {
            this.tatPanel.getTargetComboBox().setSelectedItem(this.getModel().getTargetFormula());
        }
        if (this.getModel().getDrillDownPath() != null) {
            this.pathField.setText(this.getModel().getDrillDownPath());
        }
        this.controller = new SwingRemoteDrillDownController(this, reportDesignerContext, this.wrapper);
        this.controller.init();
    }

    public void deactivate() {
        this.controller.deactivate();
    }

    static enum ComponentLookup {
        SERVER_URL_CHECKBOX,
        LOGIN_BUTTON,
        SERVER_URL_FIELD,
        BROWSE_BUTTON,
        PATH_FIELD,
        PARAMETER_TABLE;

    }
}

