/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.repository.actions;

import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.report.SaveReportAction;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.extensions.pentaho.repository.Messages;
import org.pentaho.reporting.designer.extensions.pentaho.repository.actions.LoginTask;
import org.pentaho.reporting.designer.extensions.pentaho.repository.actions.PublishToServerTask;

public class PublishToServerAction
extends AbstractReportContextAction {
    public PublishToServerAction() {
        this.putValue("Name", Messages.getInstance().getString("PublishToServerAction.Text"));
        this.putValue("ShortDescription", Messages.getInstance().getString("PublishToServerAction.Description"));
        URL url = PublishToServerAction.class.getResource("/org/pentaho/reporting/designer/extensions/pentaho/repository/resources/PublishToServerIcon.png");
        if (url != null) {
            this.putValue("SmallIcon", new ImageIcon(url));
        }
        this.putValue("AcceleratorKey", Messages.getInstance().getKeyStroke("PublishToServerAction.Accelerator"));
    }

    public void actionPerformed(ActionEvent e) {
        ReportDesignerContext reportDesignerContext = this.getReportDesignerContext();
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        if (activeContext.isChanged()) {
            int option = JOptionPane.showConfirmDialog(reportDesignerContext.getView().getParent(), Messages.getInstance().getString("PublishToServerAction.ReportModifiedWarning.Message"), Messages.getInstance().getString("PublishToServerAction.ReportModifiedWarning.Title"), 1, 2);
            if (option == 0 && !new SaveReportAction().saveReport(reportDesignerContext, activeContext, reportDesignerContext.getView().getParent())) {
                return;
            }
            if (option == 2) {
                return;
            }
        }
        PublishToServerTask publishToServerTask = new PublishToServerTask(reportDesignerContext, reportDesignerContext.getView().getParent());
        LoginTask loginTask = new LoginTask(reportDesignerContext, reportDesignerContext.getView().getParent(), publishToServerTask, null, true);
        SwingUtilities.invokeLater(loginTask);
    }
}

