/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.repository.actions;

import java.awt.Component;
import java.awt.Cursor;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.auth.AuthenticationData;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.extensions.pentaho.repository.Messages;
import org.pentaho.reporting.designer.extensions.pentaho.repository.actions.AuthenticatedServerTask;
import org.pentaho.reporting.designer.extensions.pentaho.repository.actions.SelectFileForPublishTask;
import org.pentaho.reporting.designer.extensions.pentaho.repository.util.PublishUtil;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentMetaData;
import org.pentaho.reporting.libraries.pensol.JCRSolutionFileSystem;

public class PublishToServerTask
implements AuthenticatedServerTask {
    private static final Log logger = LogFactory.getLog(PublishToServerTask.class);
    private ReportDesignerContext reportDesignerContext;
    private Component uiContext;
    private AuthenticationData loginData;
    private boolean storeUpdates;

    public PublishToServerTask(ReportDesignerContext reportDesignerContext, Component uiContext) {
        this.reportDesignerContext = reportDesignerContext;
        this.uiContext = uiContext;
    }

    @Override
    public void setLoginData(AuthenticationData loginData, boolean storeUpdates) {
        this.loginData = loginData;
        this.storeUpdates = storeUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block13: {
            MasterReport report = (MasterReport)this.reportDesignerContext.getActiveContext().getContextRoot();
            DocumentMetaData metaData = report.getBundle().getMetaData();
            try {
                String oldName = this.extractLastFileName(report);
                SelectFileForPublishTask selectFileForPublishTask = new SelectFileForPublishTask(this.uiContext);
                this.readBundleMetaData(report, metaData, selectFileForPublishTask);
                String selectedReport = selectFileForPublishTask.selectFile(this.loginData, oldName);
                if (selectedReport == null) {
                    return;
                }
                this.loginData.setOption("lastFilename", selectedReport);
                this.storeBundleMetaData(report, selectedReport, selectFileForPublishTask);
                this.reportDesignerContext.getActiveContext().getAuthenticationStore().add(this.loginData, this.storeUpdates);
                byte[] data = PublishUtil.createBundleData(report);
                int responseCode = PublishUtil.publish(data, selectedReport, this.loginData);
                if (responseCode == 200) {
                    Component glassPane = SwingUtilities.getRootPane(this.uiContext).getGlassPane();
                    try {
                        glassPane.setVisible(true);
                        glassPane.setCursor(new Cursor(3));
                        FileObject fileSystemRoot = PublishUtil.createVFSConnection(this.loginData);
                        JCRSolutionFileSystem fileSystem = (JCRSolutionFileSystem)fileSystemRoot.getFileSystem();
                        fileSystem.getLocalFileModel().refresh();
                    }
                    catch (Exception e1) {
                        UncaughtExceptionsModel.getInstance().addException((Throwable)e1);
                    }
                    finally {
                        glassPane.setVisible(false);
                        glassPane.setCursor(new Cursor(0));
                    }
                    if (JOptionPane.showConfirmDialog(this.uiContext, Messages.getInstance().getString("PublishToServerAction.Successful.LaunchNow"), Messages.getInstance().getString("PublishToServerAction.Successful.LaunchTitle"), 0) == 0) {
                        PublishUtil.launchReportOnServer(this.loginData.getUrl(), selectedReport);
                    }
                    break block13;
                }
                if (responseCode == 403) {
                    logger.error((Object)("Publish failed. Server responded with status-code " + responseCode));
                    JOptionPane.showMessageDialog(this.uiContext, Messages.getInstance().getString("PublishToServerAction.FailedAccess"), Messages.getInstance().getString("PublishToServerAction.FailedAccessTitle"), 0);
                } else {
                    logger.error((Object)("Publish failed. Server responded with status-code " + responseCode));
                    this.showErrorMessage();
                }
            }
            catch (Exception exception) {
                logger.error((Object)"Publish failed. Unexpected error:", (Throwable)exception);
                this.showErrorMessage();
            }
        }
    }

    private String extractLastFileName(MasterReport report) {
        Object lastFilenameAttr = report.getAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "report-save-path");
        String oldName = lastFilenameAttr != null ? (String)lastFilenameAttr : null;
        return oldName;
    }

    private void readBundleMetaData(MasterReport report, DocumentMetaData metaData, SelectFileForPublishTask selectFileForPublishTask) {
        String oldDescription = (String)metaData.getBundleAttribute("http://purl.org/dc/elements/1.1/", "description");
        String oldTitle = (String)metaData.getBundleAttribute("http://purl.org/dc/elements/1.1/", "title");
        boolean oldLockOutput = Boolean.TRUE.equals(report.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "lock-preferred-output-type"));
        String oldExportType = (String)report.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "preferred-output-type");
        selectFileForPublishTask.setDescription(oldDescription);
        selectFileForPublishTask.setReportTitle(oldTitle);
        selectFileForPublishTask.setLockOutputType(oldLockOutput);
        selectFileForPublishTask.setExportType(oldExportType);
    }

    private void storeBundleMetaData(MasterReport report, String selectedReport, SelectFileForPublishTask selectFileForPublishTask) {
        DocumentMetaData metaData = report.getBundle().getMetaData();
        report.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "report-save-path", (Object)selectedReport);
        if (metaData instanceof WriteableDocumentMetaData) {
            WriteableDocumentMetaData writeableDocumentMetaData = (WriteableDocumentMetaData)metaData;
            writeableDocumentMetaData.setBundleAttribute("http://purl.org/dc/elements/1.1/", "description", (Object)selectFileForPublishTask.getDescription());
            writeableDocumentMetaData.setBundleAttribute("http://purl.org/dc/elements/1.1/", "title", (Object)selectFileForPublishTask.getReportTitle());
        }
        report.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "lock-preferred-output-type", (Object)selectFileForPublishTask.isLockOutputType());
        report.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "preferred-output-type", (Object)selectFileForPublishTask.getExportType());
    }

    private void showErrorMessage() {
        JOptionPane.showMessageDialog(this.uiContext, Messages.getInstance().getString("PublishToServerAction.Failed"), Messages.getInstance().getString("PublishToServerAction.FailedTitle"), 0);
    }
}

