/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.repository.actions;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.pentaho.reporting.designer.core.auth.AuthenticationData;
import org.pentaho.reporting.designer.core.auth.AuthenticationHelper;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.extensions.pentaho.repository.actions.AuthenticatedServerTask;
import org.pentaho.reporting.designer.extensions.pentaho.repository.util.PublishException;
import org.pentaho.reporting.designer.extensions.pentaho.repository.util.PublishUtil;

public class UpdateReservedCharsTask
implements AuthenticatedServerTask {
    private AuthenticationData loginData;

    public UpdateReservedCharsTask(AuthenticationData loginData) {
        this.loginData = loginData;
    }

    @Override
    public void setLoginData(AuthenticationData loginData, boolean storeUpdates) {
        this.loginData = loginData;
    }

    private HttpClient createHttpClient() {
        HttpClient client = new HttpClient();
        client.getParams().setCookiePolicy("compatibility");
        client.getParams().setSoTimeout(WorkspaceSettings.getInstance().getConnectionTimeout() * 1000);
        client.getParams().setAuthenticationPreemptive(true);
        client.getState().setCredentials(AuthScope.ANY, AuthenticationHelper.getCredentials((String)this.loginData.getUsername(), (String)this.loginData.getPassword()));
        return client;
    }

    private boolean checkResult(int result) throws PublishException {
        return result == 200;
    }

    @Override
    public void run() {
        int result;
        HttpClient client = this.createHttpClient();
        GetMethod reservedCharactersMethod = new GetMethod(this.loginData.getUrl() + "/api/repo/files/reservedCharacters");
        reservedCharactersMethod.setFollowRedirects(false);
        GetMethod reservedCharactersDisplayMethod = new GetMethod(this.loginData.getUrl() + "/api/repo/files/reservedCharactersDisplay");
        reservedCharactersDisplayMethod.setFollowRedirects(false);
        try {
            result = client.executeMethod((HttpMethod)reservedCharactersMethod);
            if (!this.checkResult(result)) {
                throw new PublishException(1);
            }
            PublishUtil.setReservedChars(reservedCharactersMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            result = client.executeMethod((HttpMethod)reservedCharactersDisplayMethod);
            if (!this.checkResult(result)) {
                throw new PublishException(1);
            }
            PublishUtil.setReservedCharsDisplay(reservedCharactersDisplayMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

