/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.repository.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.extensions.pentaho.repository.Messages;
import org.pentaho.reporting.designer.extensions.pentaho.repository.dialogs.CreateNewRepositoryFolderDialog;
import org.pentaho.reporting.designer.extensions.pentaho.repository.dialogs.RepositoryOpenDialog;
import org.pentaho.reporting.designer.extensions.pentaho.repository.dialogs.RepositoryTreeDialog;
import org.pentaho.reporting.designer.extensions.pentaho.repository.util.PublishUtil;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.base.util.URLEncoder;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.KeyedComboBoxModel;
import org.pentaho.reporting.libraries.pensol.WebSolutionFileObject;

public class RepositoryPublishDialog
extends RepositoryOpenDialog {
    private static final String MIME_MESSAGE_TEXT_HTML = "mime-message/text/html";
    private static final String REPORT_BUNDLE_EXTENSION = ".prpt";
    private JTextField desciptionTextField;
    private JTextField titleTextField;
    private KeyedComboBoxModel<String, String> exportFormatModel;
    private JCheckBox lockOutputTypeCheckBox;

    public RepositoryPublishDialog() {
    }

    public RepositoryPublishDialog(Frame owner) {
        super(owner);
    }

    public RepositoryPublishDialog(Dialog owner) {
        super(owner);
    }

    @Override
    public void init() {
        this.exportFormatModel = this.createExportTypeModel();
        this.desciptionTextField = new JTextField();
        this.titleTextField = new JTextField();
        this.lockOutputTypeCheckBox = new JCheckBox(Messages.getInstance().getString("RepositoryPublishDialog.Lock"));
        super.init();
        this.getTable().getSelectionModel().addListSelectionListener(new FileSelectionHandler());
    }

    @Override
    protected JPanel createHeaderPanel() {
        JPanel publishHeaderPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        publishHeaderPanel.add((Component)new JLabel(Messages.getInstance().getString("RepositoryPublishDialog.ReportName")), c);
        c.gridy = 1;
        c.insets = new Insets(2, 5, 0, 5);
        publishHeaderPanel.add((Component)this.getFileNameTextField(), c);
        c.gridy = 2;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        publishHeaderPanel.add((Component)new JLabel(Messages.getInstance().getString("RepositoryPublishDialog.ReportTitle")), c);
        c.gridy = 3;
        c.insets = new Insets(2, 5, 0, 5);
        publishHeaderPanel.add((Component)this.titleTextField, c);
        c.gridy = 4;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        publishHeaderPanel.add((Component)new JLabel(Messages.getInstance().getString("RepositoryPublishDialog.ReportDescription")), c);
        c.gridy = 5;
        c.insets = new Insets(2, 5, 0, 5);
        publishHeaderPanel.add((Component)this.desciptionTextField, c);
        c.gridy = 6;
        c.fill = 2;
        c.insets = new Insets(2, 5, 0, 5);
        publishHeaderPanel.add((Component)new JLabel(Messages.getInstance().getString("RepositoryPublishDialog.Location")), c);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 7;
        c.fill = 2;
        c.weightx = 1.0;
        c.anchor = 17;
        publishHeaderPanel.add((Component)this.createLocationFieldPanel(), c);
        return publishHeaderPanel;
    }

    @Override
    protected JPanel createLocationFieldPanel() {
        GridBagConstraints c = new GridBagConstraints();
        JPanel locationFieldPanel = new JPanel();
        locationFieldPanel.setLayout(new GridBagLayout());
        c.insets = new Insets(0, 5, 5, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.anchor = 17;
        locationFieldPanel.add((Component)this.getLocationCombo(), c);
        c.insets = new Insets(5, 8, 5, 0);
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.anchor = 17;
        locationFieldPanel.add((Component)new BorderlessButton((Action)new RepositoryOpenDialog.LevelUpAction()), c);
        c.gridx = 2;
        c.gridy = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.anchor = 13;
        locationFieldPanel.add((Component)new BorderlessButton((Action)new RepositoryOpenDialog.BrowseRepositoryAction()), c);
        c.gridx = 3;
        c.gridy = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.anchor = 13;
        locationFieldPanel.add((Component)new BorderlessButton((Action)new NewFolderAction()), c);
        return locationFieldPanel;
    }

    private KeyedComboBoxModel<String, String> createExportTypeModel() {
        KeyedComboBoxModel keyedComboBoxModel = new KeyedComboBoxModel();
        keyedComboBoxModel.add(null, null);
        keyedComboBoxModel.add((Object)"pageable/pdf", (Object)Messages.getInstance().getString("RepositoryPublishDialog.ExportType.PDF"));
        keyedComboBoxModel.add((Object)"table/html;page-mode=stream", (Object)Messages.getInstance().getString("RepositoryPublishDialog.ExportType.HTMLStream"));
        keyedComboBoxModel.add((Object)"table/csv;page-mode=stream", (Object)Messages.getInstance().getString("RepositoryPublishDialog.ExportType.CSV"));
        keyedComboBoxModel.add((Object)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;page-mode=flow", (Object)Messages.getInstance().getString("RepositoryPublishDialog.ExportType.XLSX"));
        keyedComboBoxModel.add((Object)"table/excel;page-mode=flow", (Object)Messages.getInstance().getString("RepositoryPublishDialog.ExportType.XLS"));
        keyedComboBoxModel.add((Object)"table/rtf;page-mode=flow", (Object)Messages.getInstance().getString("RepositoryPublishDialog.ExportType.RTF"));
        keyedComboBoxModel.add((Object)"pageable/text", (Object)Messages.getInstance().getString("RepositoryPublishDialog.ExportType.TEXT"));
        keyedComboBoxModel.add((Object)"table/html;page-mode=page", (Object)Messages.getInstance().getString("RepositoryPublishDialog.ExportType.HTMLPage"));
        keyedComboBoxModel.add((Object)MIME_MESSAGE_TEXT_HTML, (Object)Messages.getInstance().getString("RepositoryPublishDialog.ExportType.HTMLEmail"));
        return keyedComboBoxModel;
    }

    private JPanel createPublishSettingsPanel() {
        JComboBox fileFormat = new JComboBox(this.exportFormatModel);
        GridBagConstraints c = new GridBagConstraints();
        JPanel publishSettingsPanel = new JPanel(new GridBagLayout());
        c.insets = new Insets(5, 5, 0, 5);
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 17;
        publishSettingsPanel.add((Component)new JLabel(Messages.getInstance().getString("RepositoryPublishDialog.OutputType")), c);
        c.insets = new Insets(5, 5, 5, 0);
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 0.0;
        publishSettingsPanel.add(fileFormat, c);
        c.insets = new Insets(0, 5, 5, 5);
        c.fill = 0;
        c.anchor = 17;
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        publishSettingsPanel.add((Component)this.lockOutputTypeCheckBox, c);
        return publishSettingsPanel;
    }

    public void setExportType(String exportType) {
        this.exportFormatModel.setSelectedKey((Object)exportType);
    }

    public String getExportType() {
        return (String)this.exportFormatModel.getSelectedKey();
    }

    public void setReportTitle(String title) {
        this.titleTextField.setText(title);
    }

    public String getReportTitle() {
        if (StringUtils.isEmpty((String)this.titleTextField.getText())) {
            return null;
        }
        return this.titleTextField.getText();
    }

    public void setDescription(String description) {
        this.desciptionTextField.setText(description);
    }

    public String getDescription() {
        if (StringUtils.isEmpty((String)this.desciptionTextField.getText())) {
            return null;
        }
        return this.desciptionTextField.getText();
    }

    public void setLockOutputType(boolean lock) {
        this.lockOutputTypeCheckBox.setSelected(lock);
    }

    public boolean isLockOutputType() {
        return this.lockOutputTypeCheckBox.isSelected();
    }

    @Override
    protected Component createContentPane() {
        Container contentPane = (Container)super.createContentPane();
        contentPane.add((Component)this.createPublishSettingsPanel(), "South");
        return contentPane;
    }

    @Override
    protected boolean validateInputs(boolean onConfirm) {
        if (!super.validateInputs(onConfirm)) {
            return false;
        }
        if (!onConfirm) {
            return true;
        }
        String reportName = this.getFileNameTextField().getText();
        if (!StringUtils.isEmpty((String)reportName) && !reportName.endsWith(REPORT_BUNDLE_EXTENSION)) {
            String safeReportName = reportName + REPORT_BUNDLE_EXTENSION;
            this.getFileNameTextField().setText(safeReportName);
        }
        try {
            FileObject selectedView = this.getSelectedView();
            String validateName = this.getSelectedFile();
            if (validateName == null || selectedView == null) {
                return false;
            }
            String filename = this.getFileNameTextField().getText();
            if (!PublishUtil.validateName(filename)) {
                JOptionPane.showMessageDialog((Component)((Object)this), Messages.getInstance().formatMessage("PublishToServerAction.IllegalName", filename, PublishUtil.getReservedCharsDisplay()), Messages.getInstance().getString("PublishToServerAction.Error.Title"), 0);
                return false;
            }
            FileObject targetFile = selectedView.resolveFile(URLEncoder.encodeUTF8((String)this.getFileNameTextField().getText()).replaceAll(":", "%3A").replaceAll("\\+", "%2B").replaceAll("\\!", "%21"));
            FileObject fileObject = selectedView.getFileSystem().resolveFile(targetFile.getName());
            if (fileObject.getType() == FileType.IMAGINARY) {
                return true;
            }
            int result = JOptionPane.showConfirmDialog((Component)((Object)this), Messages.getInstance().formatMessage("PublishToServerAction.FileExistsOverride", validateName), Messages.getInstance().getString("PublishToServerAction.Information.Title"), 0);
            return result == 0;
        }
        catch (FileSystemException fse) {
            UncaughtExceptionsModel.getInstance().addException((Throwable)fse);
            return false;
        }
        catch (UnsupportedEncodingException uee) {
            UncaughtExceptionsModel.getInstance().addException((Throwable)uee);
            return false;
        }
    }

    @Override
    protected boolean isCreateFolderAllowed() {
        return true;
    }

    @Override
    protected boolean isDoubleClickConfirmsDialog() {
        return false;
    }

    private class FileSelectionHandler
    implements ListSelectionListener {
        private FileSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedRow = RepositoryPublishDialog.this.getTable().getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            FileObject selectedFileObject = RepositoryPublishDialog.this.getTable().getSelectedFileObject(selectedRow);
            if (selectedFileObject == null) {
                return;
            }
            try {
                if (selectedFileObject.getType() == FileType.FILE) {
                    RepositoryPublishDialog.this.getFileNameTextField().setText(selectedFileObject.getName().getBaseName());
                }
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
    }

    private class NewFolderAction
    extends AbstractAction {
        private NewFolderAction() {
            URL location = RepositoryTreeDialog.class.getResource("/org/pentaho/reporting/designer/extensions/pentaho/repository/resources/newfolder.png");
            if (location != null) {
                this.putValue("SmallIcon", new ImageIcon(location));
            } else {
                this.putValue("Name", Messages.getInstance().getString("SolutionRepositoryTreeDialog.NewFolderAction.Name"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            CreateNewRepositoryFolderDialog newFolderDialog = new CreateNewRepositoryFolderDialog((Dialog)((Object)RepositoryPublishDialog.this));
            if (!newFolderDialog.performEdit()) {
                return;
            }
            FileObject treeNode = RepositoryPublishDialog.this.getSelectedView();
            if (treeNode == null) {
                return;
            }
            while (!PublishUtil.validateName(newFolderDialog.getFolderName())) {
                JOptionPane.showMessageDialog((Component)((Object)RepositoryPublishDialog.this), Messages.getInstance().formatMessage("PublishToServerAction.IllegalName", newFolderDialog.getFolderName(), PublishUtil.getReservedCharsDisplay()), Messages.getInstance().getString("PublishToServerAction.Error.Title"), 0);
                if (newFolderDialog.performEdit()) continue;
                return;
            }
            Component glassPane = SwingUtilities.getRootPane((Component)((Object)RepositoryPublishDialog.this)).getGlassPane();
            try {
                glassPane.setVisible(true);
                glassPane.setCursor(new Cursor(3));
                FileObject child = treeNode.resolveFile(newFolderDialog.getFolderName().replaceAll("\\%", "%25").replaceAll("\\!", "%21"));
                child.createFolder();
                if (child instanceof WebSolutionFileObject) {
                    WebSolutionFileObject webSolutionFileObject = (WebSolutionFileObject)child;
                    webSolutionFileObject.setDescription(newFolderDialog.getDescription());
                }
                RepositoryPublishDialog.this.getTable().refresh();
            }
            catch (Exception e1) {
                UncaughtExceptionsModel.getInstance().addException((Throwable)e1);
            }
            finally {
                glassPane.setVisible(false);
                glassPane.setCursor(new Cursor(0));
            }
        }
    }
}

