/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.repository.model;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.extensions.pentaho.repository.Messages;
import org.pentaho.reporting.designer.extensions.pentaho.repository.util.PublishUtil;

public class RepositoryTableModel
extends AbstractTableModel {
    private FileObject selectedPath;
    private String[] filters = new String[0];
    private boolean showHiddenFiles;

    public boolean isShowHiddenFiles() {
        return this.showHiddenFiles;
    }

    public void setShowHiddenFiles(boolean showHiddenFiles) {
        this.showHiddenFiles = showHiddenFiles;
        this.fireTableDataChanged();
    }

    public String[] getFilters() {
        return (String[])this.filters.clone();
    }

    public void setFilters(String[] filters) {
        this.filters = (String[])filters.clone();
        this.fireTableDataChanged();
    }

    public FileObject getSelectedPath() {
        return this.selectedPath;
    }

    public void setSelectedPath(FileObject selectedPath) {
        this.selectedPath = selectedPath;
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        if (this.selectedPath == null) {
            return 0;
        }
        try {
            if (this.selectedPath.getType() != FileType.FOLDER) {
                return 0;
            }
            FileObject[] children = this.selectedPath.getChildren();
            int count = 0;
            for (int i = 0; i < children.length; ++i) {
                FileObject child = children[i];
                if (!this.isShowHiddenFiles() && child.isHidden() || child.getType() != FileType.FOLDER && !PublishUtil.acceptFilter(this.filters, child.getName().getBaseName())) continue;
                ++count;
            }
            return count;
        }
        catch (FileSystemException fse) {
            UncaughtExceptionsModel.getInstance().addException((Throwable)fse);
            return 0;
        }
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Messages.getInstance().getString("SolutionRepositoryTableView.Title");
            }
            case 1: {
                return Messages.getInstance().getString("SolutionRepositoryTableView.Name");
            }
            case 2: {
                return Messages.getInstance().getString("SolutionRepositoryTableView.DateModified");
            }
            case 3: {
                return Messages.getInstance().getString("SolutionRepositoryTableView.Description");
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public FileObject getElementForRow(int row) {
        if (this.selectedPath == null) {
            return null;
        }
        try {
            if (this.selectedPath.getType() != FileType.FOLDER) {
                return null;
            }
            FileObject[] children = this.selectedPath.getChildren();
            int count = 0;
            for (int i = 0; i < children.length; ++i) {
                FileObject child = children[i];
                if (!this.isShowHiddenFiles() && child.isHidden() || child.getType() != FileType.FOLDER && !PublishUtil.acceptFilter(this.filters, child.getName().getBaseName())) continue;
                if (count == row) {
                    return child;
                }
                ++count;
            }
            return null;
        }
        catch (FileSystemException fse) {
            UncaughtExceptionsModel.getInstance().addException((Throwable)fse);
            return null;
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        FileObject node1 = this.getElementForRow(row);
        try {
            switch (column) {
                case 0: {
                    return node1.getContent().getAttribute("localized-name");
                }
                case 1: {
                    return URLDecoder.decode(node1.getName().getBaseName().replaceAll("\\+", "%2B"), "UTF-8");
                }
                case 2: {
                    long lastModifiedTime = node1.getContent().getLastModifiedTime();
                    if (lastModifiedTime == -1L) {
                        return null;
                    }
                    return new Date(lastModifiedTime);
                }
                case 3: {
                    return node1.getContent().getAttribute("description");
                }
            }
            throw new IndexOutOfBoundsException();
        }
        catch (FileSystemException fse) {
            UncaughtExceptionsModel.getInstance().addException((Throwable)fse);
            return null;
        }
        catch (UnsupportedEncodingException e) {
            UncaughtExceptionsModel.getInstance().addException((Throwable)e);
            return null;
        }
    }

    public Class getColumnClass(int column) {
        if (column == 2) {
            return Date.class;
        }
        return String.class;
    }
}

