/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.repository.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.settings.SettingsListener;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.libraries.designtime.swing.WeakEventListenerList;

public class PublishSettings {
    private static final Log LOG = LogFactory.getLog(PublishSettings.class);
    private static PublishSettings instance;
    private static final String REMEMBER_SETTINGS = "RememberSettings";
    private Preferences properties = Preferences.userRoot().node("org/pentaho/reporting/designer/pentaho-publish-settings");
    private WeakEventListenerList settingsListeners = new WeakEventListenerList();

    public static synchronized PublishSettings getInstance() {
        if (instance == null) {
            instance = new PublishSettings();
        }
        return instance;
    }

    private PublishSettings() {
    }

    public void flush() {
        try {
            this.properties.flush();
        }
        catch (BackingStoreException e) {
            UncaughtExceptionsModel.getInstance().addException((Throwable)e);
        }
    }

    public boolean isRememberSettings() {
        return this.getBoolean(REMEMBER_SETTINGS, false);
    }

    public void setRememberSettings(boolean rememberSettings) {
        this.put(REMEMBER_SETTINGS, String.valueOf(rememberSettings));
    }

    private void put(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        this.properties.put(key, value);
        this.fireSettingsChanged();
    }

    private void put(String key, Collection<String> values) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (values == null) {
            throw new IllegalArgumentException("values must not be null");
        }
        String[] strings = values.toArray(new String[values.size()]);
        Preferences preferences = this.properties.node(key);
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            preferences.put(String.valueOf(i), string);
        }
        this.fireSettingsChanged();
    }

    private String[] getList(String key) {
        String s;
        Preferences preferences = this.properties.node(key);
        ArrayList<String> data = new ArrayList<String>();
        while ((s = preferences.get(String.valueOf(data.size()), null)) != null) {
            data.add(s);
        }
        return data.toArray(new String[data.size()]);
    }

    private Integer getInt(String key) {
        String value = this.properties.get(key, null);
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"PublishSettings.getInt ", (Throwable)e);
            }
            return null;
        }
    }

    private boolean getBoolean(String key, boolean defaultValue) {
        String value = this.properties.get(key, null);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    private Boolean getBoolean(String key) {
        String value = this.properties.get(key, null);
        if (value == null) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    private String getString(String key) {
        return this.properties.get(key, null);
    }

    public void fireSettingsChanged() {
        SettingsListener[] listeners = (SettingsListener[])this.settingsListeners.getListeners(SettingsListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            SettingsListener listener = listeners[i];
            listener.settingsChanged();
        }
    }
}

