/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.stats.jdbc.JDBCStatsPublisher;

public class JDBCStatsUtils {
    private static final List<String> supportedStats = new ArrayList<String>();
    private static final Map<String, String> columnNameMapping = new HashMap<String, String>();

    public static List<String> getSupportedStatistics() {
        return supportedStats;
    }

    public static boolean isValidStatisticSet(Collection<String> stats) {
        if (!stats.contains(JDBCStatsUtils.getBasicStat())) {
            return false;
        }
        for (String stat : stats) {
            if (supportedStats.contains(stat)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidStatistic(String statType) {
        return supportedStats.contains(statType);
    }

    public static String getIdColumnName() {
        return "ID";
    }

    public static String getTimestampColumnName() {
        return "TS";
    }

    public static String getStatTableName() {
        return "PARTITION_STATS_V2";
    }

    public static String getStatColumnName(String statType) {
        return columnNameMapping.get(statType);
    }

    public static String getBasicStat() {
        return supportedStats.get(0);
    }

    public static String getCreate(String comment, JDBCStatsPublisher.SupportedDBType dbType, Configuration hconf) {
        String create = "CREATE TABLE /* " + comment + " */ " + JDBCStatsUtils.getStatTableName() + " (" + JDBCStatsUtils.getTimestampColumnName() + " TIMESTAMP DEFAULT CURRENT_TIMESTAMP, " + JDBCStatsUtils.getIdColumnName() + " VARCHAR(" + JDBCStatsUtils.getIdColSize(hconf) + ") PRIMARY KEY ";
        for (int i = 0; i < supportedStats.size(); ++i) {
            create = create + ", " + JDBCStatsUtils.getStatColumnName(supportedStats.get(i)) + " BIGINT ";
        }
        switch (dbType) {
            case MYSQL: {
                create = create + ") ROW_FORMAT=DYNAMIC";
                break;
            }
            default: {
                create = create + ")";
            }
        }
        return create;
    }

    public static String getAlterIdColumn(JDBCStatsPublisher.SupportedDBType dbType, Configuration hconf) {
        String alter = "ALTER TABLE " + JDBCStatsUtils.getStatTableName();
        switch (dbType) {
            case MYSQL: {
                alter = alter + " MODIFY " + JDBCStatsUtils.getIdColumnName();
                break;
            }
            case DERBY: {
                alter = alter + " ALTER COLUMN " + JDBCStatsUtils.getIdColumnName() + " SET DATA TYPE ";
                break;
            }
            case POSTGRES: {
                alter = alter + " ALTER COLUMN " + JDBCStatsUtils.getIdColumnName() + " TYPE ";
                break;
            }
            default: {
                alter = alter + " ALTER COLUMN " + JDBCStatsUtils.getIdColumnName();
            }
        }
        alter = alter + " VARCHAR(" + JDBCStatsUtils.getIdColSize(hconf) + ")";
        return alter;
    }

    public static String getUpdate(String comment) {
        String update = "UPDATE /* " + comment + " */ " + JDBCStatsUtils.getStatTableName() + " SET ";
        for (int i = 0; i < supportedStats.size(); ++i) {
            update = update + columnNameMapping.get(supportedStats.get(i)) + " = ? , ";
        }
        update = update + JDBCStatsUtils.getTimestampColumnName() + " = CURRENT_TIMESTAMP";
        update = update + " WHERE " + JDBCStatsUtils.getIdColumnName() + " = ? AND ? > ( SELECT TEMP." + JDBCStatsUtils.getStatColumnName(JDBCStatsUtils.getBasicStat()) + " FROM ( " + " SELECT " + JDBCStatsUtils.getStatColumnName(JDBCStatsUtils.getBasicStat()) + " FROM " + JDBCStatsUtils.getStatTableName() + " WHERE " + JDBCStatsUtils.getIdColumnName() + " = ? ) TEMP )";
        return update;
    }

    public static String getInsert(String comment) {
        String columns = JDBCStatsUtils.getIdColumnName();
        String values = "?";
        for (int i = 0; i < supportedStats.size(); ++i) {
            columns = columns + ", " + JDBCStatsUtils.getStatColumnName(supportedStats.get(i));
            values = values + ", ?";
        }
        String insert = "INSERT INTO /* " + comment + " */ " + JDBCStatsUtils.getStatTableName() + "(" + columns + ") VALUES (" + values + ")";
        return insert;
    }

    public static String getSelectAggr(String statType, String comment) {
        String select = "SELECT /* " + comment + " */ " + "SUM( " + JDBCStatsUtils.getStatColumnName(statType) + " ) " + " FROM " + JDBCStatsUtils.getStatTableName() + " WHERE " + JDBCStatsUtils.getIdColumnName() + " LIKE ? ESCAPE ?";
        return select;
    }

    public static String getDeleteAggr(String rowID, String comment) {
        String delete = "DELETE /* " + comment + " */ " + " FROM " + JDBCStatsUtils.getStatTableName() + " WHERE " + JDBCStatsUtils.getIdColumnName() + " LIKE ? ESCAPE ?";
        return delete;
    }

    public static void validateRowId(String rowId, Configuration hconf) {
        if (rowId.length() > JDBCStatsUtils.getIdColSize(hconf)) {
            throw new RuntimeException("ID is too big, client should have truncated it: " + rowId);
        }
    }

    public static int getIdColSize(Configuration hconf) {
        return HiveConf.getIntVar(hconf, HiveConf.ConfVars.PART_STAT_TABLE_ID_COLUMN_VARCHAR_SIZE);
    }

    static {
        supportedStats.add("numRows");
        supportedStats.add("rawDataSize");
        columnNameMapping.put("numRows", "ROW_COUNT");
        columnNameMapping.put("rawDataSize", "RAW_DATA_SIZE");
    }
}

