/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.util.debug.Logger;

public class BandwidthThrottler {
    private Logger log = Logger.getLogger("BandwidthThrottler");
    private long lastTime = 0L;
    private long lastBytes = 0L;
    private int thresholdBytesPerSec = -1;

    public BandwidthThrottler(int thresholdBytesPerSec) {
        this.thresholdBytesPerSec = thresholdBytesPerSec;
    }

    public void setThreshold(int thresholdBytesPerSec) {
        this.thresholdBytesPerSec = thresholdBytesPerSec;
    }

    public int getThreshold() {
        return this.thresholdBytesPerSec;
    }

    public void throttleTransfer(long bytesSoFar) {
        long time = System.currentTimeMillis();
        long diffBytes = bytesSoFar - this.lastBytes;
        long diffTime = time - this.lastTime;
        if (diffTime == 0L) {
            return;
        }
        double rate = (double)diffBytes / (double)diffTime * 1000.0;
        if (this.log.isDebugEnabled()) {
            this.log.debug("rate= " + rate);
        }
        while (rate > (double)this.thresholdBytesPerSec) {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Sleeping to decrease transfer rate (rate = " + rate + " bytes/s");
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            diffTime = System.currentTimeMillis() - this.lastTime;
            rate = (double)diffBytes / (double)diffTime * 1000.0;
        }
        this.lastTime = time;
        this.lastBytes = bytesSoFar;
    }

    public void reset() {
        this.lastTime = System.currentTimeMillis();
        this.lastBytes = 0L;
    }
}

