/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.mapreduce.ui.step.enter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.big.data.kettle.plugins.mapreduce.step.enter.HadoopEnterMeta;
import org.pentaho.big.data.kettle.plugins.mapreduce.ui.step.enter.HadoopEnterMetaMapper;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.ui.trans.step.BaseStepXulDialog;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.components.XulTextbox;

public class HadoopEnterDialog
extends BaseStepXulDialog
implements StepDialogInterface {
    private static final Class<?> PKG = HadoopEnterMeta.class;
    private String workingStepname;
    private HadoopEnterMetaMapper metaMapper;
    private List<String> typeList = new ArrayList<String>();

    public HadoopEnterDialog(Shell parent, Object in, TransMeta tr, String sname) throws Throwable {
        super("org/pentaho/big/data/kettle/plugins/mapreduce/ui/step/enter/dialog.xul", parent, (BaseStepMeta)in, tr, sname);
        for (String type : ValueMeta.getAllTypes()) {
            this.typeList.add(type);
        }
        this.init();
    }

    public void init() throws Throwable {
        this.workingStepname = this.stepname;
        this.metaMapper = new HadoopEnterMetaMapper();
        this.metaMapper.loadMeta((HadoopEnterMeta)this.baseStepMeta);
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.setTextBoxValue("input-key-length", this.metaMapper.getInKeyLength());
        this.setTextBoxValue("input-key-precision", this.metaMapper.getInKeyPrecision());
        this.setTextBoxValue("input-value-length", this.metaMapper.getInValueLength());
        this.setTextBoxValue("input-value-precision", this.metaMapper.getInValuePrecision());
        this.bf.createBinding("step-name", "value", (Object)this, "stepName", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "stepName", "step-name", "value", new BindingConvertor[0]).fireSourceChanged();
        this.bf.createBinding((Object)this, "types", "input-key-type", "elements", new BindingConvertor[0]).fireSourceChanged();
        this.bf.createBinding((Object)this, "types", "input-value-type", "elements", new BindingConvertor[0]).fireSourceChanged();
        if (this.metaMapper.getInKeyType() >= 0) {
            ((XulMenuList)this.getXulDomContainer().getDocumentRoot().getElementById("input-key-type")).setSelectedItem((Object)ValueMeta.getTypeDesc((int)this.metaMapper.getInKeyType()));
        }
        if (this.metaMapper.getInValueType() >= 0) {
            ((XulMenuList)this.getXulDomContainer().getDocumentRoot().getElementById("input-value-type")).setSelectedItem((Object)ValueMeta.getTypeDesc((int)this.metaMapper.getInValueType()));
        }
    }

    protected Class<?> getClassForMessages() {
        return HadoopEnterMeta.class;
    }

    public void onAccept() {
        this.metaMapper.setInKeyType(this.fetchValue((XulMenuList)this.getXulDomContainer().getDocumentRoot().getElementById("input-key-type")));
        this.metaMapper.setInKeyLength(this.fetchValue((XulTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("input-key-length")));
        this.metaMapper.setInKeyPrecision(this.fetchValue((XulTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("input-key-precision")));
        this.metaMapper.setInValueType(this.fetchValue((XulMenuList)this.getXulDomContainer().getDocumentRoot().getElementById("input-value-type")));
        this.metaMapper.setInValueLength(this.fetchValue((XulTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("input-value-length")));
        this.metaMapper.setInValuePrecision(this.fetchValue((XulTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("input-value-precision")));
        if (!this.workingStepname.equals(this.stepname)) {
            this.stepname = this.workingStepname;
            this.baseStepMeta.setChanged();
        }
        this.metaMapper.saveMeta((HadoopEnterMeta)this.baseStepMeta);
        this.dispose();
    }

    private int fetchValue(XulTextbox textbox) {
        int result = -1;
        if (textbox != null && !StringUtil.isEmpty((String)textbox.getValue())) {
            try {
                result = Integer.parseInt(textbox.getValue());
            }
            catch (NumberFormatException e) {
                this.log.logError(BaseMessages.getString((String)"HadoopEnter.Error.ParseInteger", (String)textbox.getValue()));
            }
        }
        return result;
    }

    private int fetchValue(XulMenuList<?> menulist) {
        int result = -1;
        if (menulist != null && menulist.getValue() != null) {
            result = ValueMeta.getType((String)menulist.getValue());
        }
        return result;
    }

    private void setTextBoxValue(String textbox, int value) {
        String v = "";
        if (value >= 0) {
            v = Integer.toString(value);
        }
        ((XulTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(textbox)).setValue(v);
    }

    public void onCancel() {
        this.setStepName(null);
        this.dispose();
    }

    public void setStepName(String stepname) {
        this.workingStepname = stepname;
    }

    public String getStepName() {
        return this.workingStepname;
    }

    public List<String> getTypes() {
        return this.typeList;
    }
}

