/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.NullOutputCommitter;
import org.apache.sqoop.mapreduce.SQLServerAsyncDBExecThread;
import org.apache.sqoop.mapreduce.SQLServerExportDBExecThread;
import org.apache.sqoop.mapreduce.db.DBConfiguration;

public class SQLServerResilientExportOutputFormat<K extends SqoopRecord, V>
extends OutputFormat<K, V> {
    private static final Log LOG = LogFactory.getLog(SQLServerResilientExportOutputFormat.class);
    public static final String EXPORT_FAILURE_HANDLER_CLASS = "sqoop.export.failure.handler.class";
    public static final int DEFAULT_RECORDS_PER_STATEMENT = 1000;
    private int curListIdx = 0;

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        DBConfiguration dbConf = new DBConfiguration(conf);
        if (null == conf.get("mapreduce.jdbc.url")) {
            throw new IOException("Database connection URL is not set.");
        }
        if (null == dbConf.getOutputTableName()) {
            throw new IOException("Table name is not set for export");
        }
        if (null == dbConf.getOutputFieldNames() && 0 == dbConf.getOutputFieldCount()) {
            throw new IOException("Output field names are null and zero output field count set.");
        }
    }

    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException {
        try {
            return new SQLServerExportRecordWriter(context);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new NullOutputCommitter();
    }

    public class SQLServerExportRecordWriter<K extends SqoopRecord, V>
    extends RecordWriter<K, V> {
        private final Log LOG = LogFactory.getLog(SQLServerExportRecordWriter.class);
        private final int LIST_COUNT = 2;
        protected Configuration conf;
        protected SQLServerAsyncDBExecThread execThread;
        protected int recordsPerStmt;
        protected List<List<SqoopRecord>> recordsLists = new ArrayList<List<SqoopRecord>>();
        protected List<SqoopRecord> currentList;

        public SQLServerExportRecordWriter(TaskAttemptContext context) throws IOException {
            this.conf = context.getConfiguration();
            this.recordsPerStmt = this.conf.getInt("sqoop.export.records.per.statement", 1000);
            for (int i = 0; i < 2; ++i) {
                ArrayList newList = new ArrayList(this.recordsPerStmt);
                this.recordsLists.add(newList);
            }
            this.currentList = this.recordsLists.get(0);
            this.initializeExecThread();
            this.execThread.start();
        }

        protected void initializeExecThread() throws IOException {
            this.execThread = new SQLServerExportDBExecThread();
            this.execThread.initialize(this.conf);
        }

        public void write(K key, V value) throws InterruptedException, IOException {
            try {
                this.currentList.add((SqoopRecord)((SqoopRecord)key).clone());
                if (this.currentList.size() >= this.recordsPerStmt) {
                    this.execThread.put(this.currentList);
                    SQLServerResilientExportOutputFormat.this.curListIdx = (SQLServerResilientExportOutputFormat.this.curListIdx + 1) % this.recordsLists.size();
                    this.currentList = this.recordsLists.get(SQLServerResilientExportOutputFormat.this.curListIdx);
                    this.currentList.clear();
                }
            }
            catch (CloneNotSupportedException cnse) {
                throw new IOException("Could not buffer record", cnse);
            }
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            try {
                if (this.currentList.size() > 0) {
                    this.execThread.put(this.currentList);
                }
            }
            finally {
                this.execThread.close();
                this.execThread.join();
            }
            Exception lastException = this.execThread.getLastError();
            if (lastException != null) {
                this.LOG.error((Object)("Asynchronous writer thread encountered the following exception: " + lastException.toString()));
                throw new IOException(lastException);
            }
        }
    }
}

