/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public class DateTimeWritable
implements WritableComparable {
    private static final int ONE_MINUTE = 60000;
    private DateTime value = null;

    public DateTimeWritable() {
    }

    public DateTimeWritable(DateTime dt) {
        this.value = dt;
    }

    public void readFields(DataInput in) throws IOException {
        this.value = new DateTime(in.readLong(), DateTimeZone.forOffsetMillis((int)(in.readShort() * 60000)));
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.value.getMillis());
        out.writeShort(this.value.getZone().getOffset((ReadableInstant)this.value) / 60000);
    }

    public void set(DateTime dt) {
        this.value = dt;
    }

    public DateTime get() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DateTimeWritable)) {
            return false;
        }
        DateTimeWritable other = (DateTimeWritable)o;
        return this.value.equals((Object)other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public int compareTo(Object o) {
        DateTimeWritable other = (DateTimeWritable)o;
        return this.value.compareTo((ReadableInstant)other.value);
    }

    public String toString() {
        return this.value.toString();
    }

    static {
        WritableComparator.define(DateTimeWritable.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(DateTimeWritable.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            DateTime thisValue = new DateTime(Comparator.readLong((byte[])b1, (int)s1));
            DateTime thatValue = new DateTime(Comparator.readLong((byte[])b2, (int)s2));
            return thisValue.compareTo((ReadableInstant)thatValue);
        }
    }
}

