/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.List;
import java.util.Random;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class POReservoirSample
extends PhysicalOperator {
    private static final long serialVersionUID = 1L;
    protected int numSamples;
    private transient int nextSampleIdx = 0;
    private transient int rowProcessed = 0;
    private transient boolean sampleCollectionDone = false;
    private transient Result[] samples = null;
    private transient Result lastSample = null;

    public POReservoirSample(OperatorKey k) {
        this(k, -1, null);
    }

    public POReservoirSample(OperatorKey k, int rp) {
        this(k, rp, null);
    }

    public POReservoirSample(OperatorKey k, List<PhysicalOperator> inp) {
        this(k, -1, inp);
    }

    public POReservoirSample(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k, rp, inp);
    }

    public POReservoirSample(OperatorKey k, int rp, List<PhysicalOperator> inp, int numSamples) {
        super(k, rp, inp);
        this.numSamples = numSamples;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        return null;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitReservoirSample(this);
    }

    @Override
    public Result getNextTuple() throws ExecException {
        if (this.sampleCollectionDone) {
            return this.getSample();
        }
        if (this.samples == null) {
            this.samples = new Result[this.numSamples];
        }
        Result res = null;
        while (this.rowProcessed < this.numSamples) {
            res = this.processInput();
            if (res.returnStatus == 0) {
                this.samples[this.rowProcessed] = res;
                ++this.rowProcessed;
                continue;
            }
            if (res.returnStatus == 1) continue;
            if (res.returnStatus != 3 || this.parentPlan.endOfAllInput) break;
            return res;
        }
        if (res == null || res.returnStatus != 3) {
            Random randGen = new Random();
            while (true) {
                res = this.processInput();
                if (res.returnStatus == 1) continue;
                if (res.returnStatus != 0) break;
                int rand = randGen.nextInt(this.rowProcessed);
                if (rand < this.numSamples) {
                    this.samples[rand] = res;
                }
                ++this.rowProcessed;
            }
        }
        if (this.parentPlan.endOfAllInput && res.returnStatus == 3) {
            this.sampleCollectionDone = true;
        }
        return this.getSample();
    }

    private Result getSample() throws ExecException {
        if (this.lastSample == null) {
            this.lastSample = this.retrieveSample();
        }
        if (this.lastSample.returnStatus == 3) {
            return this.lastSample;
        }
        Result currentSample = this.retrieveSample();
        if (currentSample.returnStatus == 3) {
            this.lastSample = this.createNumRowTuple((Tuple)this.lastSample.result);
        } else if (currentSample.returnStatus == 1) {
            return currentSample;
        }
        Result result = this.lastSample;
        this.lastSample = currentSample;
        return result;
    }

    private Result retrieveSample() throws ExecException {
        if (this.nextSampleIdx < Math.min(this.rowProcessed, this.samples.length)) {
            Result res;
            if (this.illustrator != null) {
                this.illustratorMarkup(this.samples[this.nextSampleIdx].result, this.samples[this.nextSampleIdx].result, 0);
            }
            if ((res = this.samples[this.nextSampleIdx++]) == null) {
                return RESULT_EMPTY;
            }
            return res;
        }
        return RESULT_EOP;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public String name() {
        return this.getAliasString() + "ReservoirSample - " + this.mKey.toString();
    }

    private Result createNumRowTuple(Tuple sample) throws ExecException {
        int sz = sample == null ? 0 : sample.size();
        Tuple t = mTupleFactory.newTuple(sz + 2);
        if (sample != null) {
            for (int i = 0; i < sample.size(); ++i) {
                t.set(i, sample.get(i));
            }
        }
        t.set(sz, "\u4956\u3838_pig_inTeRnal-spEcial_roW_num_tuple3kt579CFLehkblah");
        t.set(sz + 1, this.rowProcessed);
        return new Result(0, t);
    }
}

