/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer;

import java.util.LinkedList;
import java.util.List;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POLocalRearrangeTez;
import org.apache.pig.backend.hadoop.executionengine.util.CombinerOptimizerUtil;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

public class CombinerOptimizer
extends TezOpPlanVisitor {
    private CompilationMessageCollector messageCollector = null;
    private boolean doMapAgg;

    public CombinerOptimizer(TezOperPlan plan, boolean doMapAgg) {
        this(plan, doMapAgg, new CompilationMessageCollector());
    }

    public CombinerOptimizer(TezOperPlan plan, boolean doMapAgg, CompilationMessageCollector messageCollector) {
        super(plan, (PlanWalker<TezOperator, TezOperPlan>)new DepthFirstWalker<TezOperator, TezOperPlan>(plan));
        this.messageCollector = messageCollector;
        this.doMapAgg = doMapAgg;
    }

    public CompilationMessageCollector getMessageCollector() {
        return this.messageCollector;
    }

    @Override
    public void visitTezOp(TezOperator to) throws VisitorException {
        LinkedList<POPackage> packages = PlanHelper.getPhysicalOperators(to.plan, POPackage.class);
        if (packages.isEmpty()) {
            return;
        }
        List<TezOperator> predecessors = ((TezOperPlan)this.mPlan).getPredecessors(to);
        if (predecessors == null) {
            return;
        }
        if (to.isCogroup()) {
            return;
        }
        for (TezOperator from : predecessors) {
            LinkedList<POLocalRearrangeTez> rearranges = PlanHelper.getPhysicalOperators(from.plan, POLocalRearrangeTez.class);
            if (rearranges.isEmpty()) continue;
            Operator connectingLR = null;
            PhysicalPlan rearrangePlan = from.plan;
            for (POLocalRearrangeTez lr : rearranges) {
                if (!lr.getOutputKey().equals(to.getOperatorKey().toString())) continue;
                connectingLR = lr;
                break;
            }
            if (from.plan.getOperator(connectingLR.getOperatorKey()) == null) {
                rearrangePlan = PlanHelper.getLocalRearrangePlanFromSplit(from.plan, connectingLR.getOperatorKey());
            }
            PhysicalPlan combinePlan = to.inEdges.get((Object)from.getOperatorKey()).combinePlan;
            CombinerOptimizerUtil.addCombiner(rearrangePlan, to.plan, combinePlan, this.messageCollector, this.doMapAgg);
            if (combinePlan.isEmpty()) continue;
            from.setOverrideIntermediateParallelism(true);
        }
    }
}

