/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.Iterator;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class LongAvg
extends EvalFunc<Double>
implements Algebraic,
Accumulator<Double> {
    private static TupleFactory mTupleFactory = TupleFactory.getInstance();
    private Long intermediateSum = null;
    private Double intermediateCount = null;

    @Override
    public Double exec(Tuple input) throws IOException {
        Long sum = LongAvg.sum(input);
        if (sum == null) {
            return null;
        }
        double count = LongAvg.count(input);
        Double avg = null;
        if (count > 0.0) {
            avg = new Double((double)sum.longValue() / count);
        }
        return avg;
    }

    @Override
    public String getInitial() {
        return Initial.class.getName();
    }

    @Override
    public String getIntermed() {
        return Intermediate.class.getName();
    }

    @Override
    public String getFinal() {
        return Final.class.getName();
    }

    protected static Tuple combine(DataBag values) throws ExecException {
        long sum = 0L;
        long count = 0L;
        Tuple output = mTupleFactory.newTuple(2);
        boolean sawNonNull = false;
        for (Tuple t : values) {
            Long l = (Long)t.get(0);
            if (l == null) {
                l = 0L;
            } else {
                sawNonNull = true;
            }
            sum += l.longValue();
            count += ((Long)t.get(1)).longValue();
        }
        if (sawNonNull) {
            output.set(0, sum);
        } else {
            output.set(0, null);
        }
        output.set(1, count);
        return output;
    }

    protected static long count(Tuple input) throws ExecException {
        DataBag values = (DataBag)input.get(0);
        Iterator<Tuple> it = values.iterator();
        long cnt = 0L;
        while (it.hasNext()) {
            Tuple t = it.next();
            if (t == null || t.size() <= 0 || t.get(0) == null) continue;
            ++cnt;
        }
        return cnt;
    }

    protected static Long sum(Tuple input) throws ExecException, IOException {
        DataBag values = (DataBag)input.get(0);
        if (values == null || values.size() == 0L) {
            return null;
        }
        long sum = 0L;
        boolean sawNonNull = false;
        for (Tuple t : values) {
            try {
                Long l = (Long)t.get(0);
                if (l == null) continue;
                sawNonNull = true;
                sum += l.longValue();
            }
            catch (RuntimeException exp) {
                int errCode = 2103;
                String msg = "Problem while computing sum of longs.";
                throw new ExecException(msg, errCode, 4, exp);
            }
        }
        if (sawNonNull) {
            return sum;
        }
        return null;
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 25));
    }

    @Override
    public void accumulate(Tuple b) throws IOException {
        try {
            double count;
            Long sum = LongAvg.sum(b);
            if (sum == null) {
                return;
            }
            if (this.intermediateSum == null || this.intermediateCount == null) {
                this.intermediateSum = 0L;
                this.intermediateCount = 0.0;
            }
            if ((count = (double)Long.valueOf(LongAvg.count(b)).longValue()) > 0.0) {
                this.intermediateCount = this.intermediateCount + count;
                this.intermediateSum = this.intermediateSum + sum;
            }
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            String msg = "Error while computing average in " + this.getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, e);
        }
    }

    @Override
    public void cleanup() {
        this.intermediateSum = null;
        this.intermediateCount = null;
    }

    @Override
    public Double getValue() {
        Double avg = null;
        if (this.intermediateCount != null && this.intermediateCount > 0.0) {
            avg = new Double((double)this.intermediateSum.longValue() / this.intermediateCount);
        }
        return avg;
    }

    public static class Final
    extends EvalFunc<Double> {
        @Override
        public Double exec(Tuple input) throws IOException {
            try {
                DataBag b = (DataBag)input.get(0);
                Tuple combined = LongAvg.combine(b);
                Long sum = (Long)combined.get(0);
                if (sum == null) {
                    return null;
                }
                double count = ((Long)combined.get(1)).longValue();
                Double avg = null;
                if (count > 0.0) {
                    avg = new Double((double)sum.longValue() / count);
                }
                return avg;
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing average in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }

    public static class Intermediate
    extends EvalFunc<Tuple> {
        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                DataBag b = (DataBag)input.get(0);
                return LongAvg.combine(b);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing average in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }

    public static class Initial
    extends EvalFunc<Tuple> {
        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                Tuple t = mTupleFactory.newTuple(2);
                DataBag bg = (DataBag)input.get(0);
                Long l = null;
                if (bg.iterator().hasNext()) {
                    Tuple tp = bg.iterator().next();
                    l = (Long)tp.get(0);
                }
                t.set(0, l);
                if (l != null) {
                    t.set(1, 1L);
                } else {
                    t.set(1, 0L);
                }
                return t;
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing average in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }
}

