/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.plan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanVisitor;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.Utils;

public class ReverseDependencyOrderWalker<O extends Operator, P extends OperatorPlan<O>>
extends PlanWalker<O, P> {
    public ReverseDependencyOrderWalker(P plan) {
        super(plan);
    }

    @Override
    public void walk(PlanVisitor<O, P> visitor) throws VisitorException {
        ArrayList fifo = new ArrayList();
        HashSet seen = new HashSet();
        List roots = this.mPlan.getRoots();
        if (roots == null) {
            return;
        }
        for (Operator op : roots) {
            this.doAllSuccessors(op, seen, fifo);
        }
        for (Operator op : fifo) {
            op.visit(visitor);
        }
    }

    @Override
    public PlanWalker<O, P> spawnChildWalker(P plan) {
        return new ReverseDependencyOrderWalker<O, P>(plan);
    }

    protected void doAllSuccessors(O node, Set<O> seen, Collection<O> fifo) throws VisitorException {
        if (!seen.contains(node)) {
            Collection<Operator> succs = Utils.mergeCollection(this.mPlan.getSuccessors(node), this.mPlan.getSoftLinkSuccessors(node));
            if (succs != null && succs.size() > 0) {
                for (Operator op : succs) {
                    this.doAllSuccessors(op, seen, fifo);
                }
            }
            seen.add(node);
            fifo.add(node);
        }
    }
}

